/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.io.PdfObjectReader;

public class PDFExponential
extends PDFGenericFunction
implements PDFFunction {
    private float[] C0;
    private float[] C1;
    private float[] domain;
    private float[] range;
    private float N;
    private Map tintTransform;

    public String getType() {
        return "EXPONENTIAL";
    }

    public PDFExponential(Map map, float[] fArray, float[] fArray2, PdfObjectReader pdfObjectReader) {
        this.domain = fArray;
        this.range = fArray2;
        this.tintTransform = map;
        String string = (String)map.get("N");
        if (string != null) {
            this.N = Float.parseFloat(string);
        }
        this.setC0(pdfObjectReader);
        this.setC1(pdfObjectReader);
    }

    public String[] compute(float[] fArray) {
        int n = this.C0.length;
        float[] fArray2 = new float[n];
        String[] stringArray = new String[n];
        try {
            float f = this.min(this.max(fArray[0], this.domain[0]), this.domain[1]);
            if (this.N == 1.0f) {
                for (int i = 0; i < this.C0.length; ++i) {
                    fArray2[i] = this.C0[i] + f * (this.C1[i] - this.C0[i]);
                    if (this.range != null) {
                        fArray2[i] = this.min(this.max(fArray2[i], this.range[i * 2]), this.range[i * 2 + 1]);
                    }
                    stringArray[stringArray.length - (i + 1)] = String.valueOf(fArray2[i]);
                }
            } else {
                for (int i = 0; i < this.C0.length; ++i) {
                    fArray2[i] = this.C0[i] + (float)Math.pow(f, this.N) * (this.C1[i] - this.C0[i]);
                    if (this.range != null) {
                        fArray2[i] = this.min(this.max(fArray2[i], this.range[i * 2]), this.range[i * 2 + 1]);
                    }
                    stringArray[stringArray.length - (i + 1)] = String.valueOf(fArray2[i]);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exp error " + exception);
            exception.printStackTrace();
        }
        return stringArray;
    }

    public float[] computeFloat(float[] fArray) {
        int n = this.C0.length;
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        try {
            float f = this.min(this.max(fArray[0], this.domain[0]), this.domain[1]);
            if (this.N == 1.0f) {
                for (int i = 0; i < this.C0.length; ++i) {
                    fArray2[i] = this.C0[i] + f * (this.C1[i] - this.C0[i]);
                    if (this.range != null) {
                        fArray2[i] = this.min(this.max(fArray2[i], this.range[i * 2]), this.range[i * 2 + 1]);
                    }
                    fArray3[fArray3.length - (i + 1)] = fArray2[i];
                }
            } else {
                for (int i = 0; i < this.C0.length; ++i) {
                    fArray2[i] = this.C0[i] + (float)Math.pow(f, this.N) * (this.C1[i] - this.C0[i]);
                    if (this.range != null) {
                        fArray2[i] = this.min(this.max(fArray2[i], this.range[i * 2]), this.range[i * 2 + 1]);
                    }
                    fArray3[fArray3.length - (i + 1)] = fArray2[i];
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exp error " + exception);
            exception.printStackTrace();
        }
        return fArray3;
    }

    private void setC0(PdfObjectReader pdfObjectReader) {
        String string = (String)this.tintTransform.get("C0");
        if (string != null) {
            string = pdfObjectReader.getValue(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
            this.C0 = new float[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.C0[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        } else {
            this.C0 = new float[1];
            this.C0[0] = 0.0f;
        }
    }

    private void setC1(PdfObjectReader pdfObjectReader) {
        String string = (String)this.tintTransform.get("C1");
        if (string != null) {
            string = pdfObjectReader.getValue(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
            this.C1 = new float[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.C1[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        } else {
            this.C1 = new float[1];
            this.C1[0] = 1.0f;
        }
    }
}

