/*
 * Decompiled with CFR 0.152.
 */
package jreepad.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Stack;
import jreepad.JreepadNode;
import jreepad.JreepadTreeModel;
import jreepad.io.JreepadReader;

public class TreepadReader
implements JreepadReader {
    private boolean autoDetectHtmlArticles;
    private String encoding;
    private int fileFormat;

    public TreepadReader(String encoding, boolean autoDetectHtmlArticles) {
        this.encoding = encoding;
        this.autoDetectHtmlArticles = autoDetectHtmlArticles;
    }

    public JreepadTreeModel read(InputStream in) throws IOException {
        String depthLine;
        String titleLine;
        String nodeLine;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, this.encoding));
        reader.readLine();
        Stack<JreepadNode> nodeStack = new Stack<JreepadNode>();
        JreepadNode rootNode = null;
        String dtLine = "dt=text";
        while ((this.fileFormat == 2 || (dtLine = reader.readLine()) != null) && (nodeLine = reader.readLine()) != null && (titleLine = reader.readLine()) != null && (depthLine = reader.readLine()) != null) {
            String currentLine;
            if (dtLine.equals("") && nodeLine.startsWith("<bmarks>")) {
                throw new IOException("This is not a Treepad-Lite-compatible file!\n\nFiles created in more advanced versions of Treepad\ncontain features that are not available in Jreepad.");
            }
            if (this.fileFormat != 2 && !dtLine.toLowerCase().startsWith("dt=text")) {
                throw new IOException("Unrecognised node dt format at line " + reader.getLineNumber() + ": " + dtLine);
            }
            if (!nodeLine.toLowerCase().startsWith("<node>")) {
                throw new IOException("Unrecognised node format at line " + (reader.getLineNumber() + 1) + ": " + nodeLine);
            }
            StringBuffer currentContent = new StringBuffer();
            while ((currentLine = reader.readLine()) != null && !currentLine.equals("<end node> 5P9i0s8y19Z")) {
                currentContent.append(currentLine + "\n");
            }
            String content = currentContent.substring(0, Math.max(currentContent.length() - 1, 0));
            JreepadNode newNode = new JreepadNode(titleLine, content);
            String compareContent = newNode.getContent().toLowerCase().trim();
            int newArticleMode = this.autoDetectHtmlArticles && compareContent.startsWith("<html>") && compareContent.endsWith("</html>") ? 2 : 1;
            newNode.getArticle().setArticleMode(newArticleMode);
            if (depthLine.equals("0")) {
                rootNode = newNode;
            } else {
                int depthMarker = Integer.parseInt(depthLine);
                while (nodeStack.size() > depthMarker) {
                    nodeStack.pop();
                }
                ((JreepadNode)nodeStack.peek()).add(newNode);
            }
            nodeStack.push(newNode);
        }
        JreepadTreeModel document = new JreepadTreeModel(rootNode);
        document.setFileType(1);
        document.setEncoding(this.encoding);
        return document;
    }

    public boolean isAutoDetectHtmlArticles() {
        return this.autoDetectHtmlArticles;
    }

    public void setAutoDetectHtmlArticles(boolean autoDetectHtmlArticles) {
        this.autoDetectHtmlArticles = autoDetectHtmlArticles;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(int fileFormat) {
        this.fileFormat = fileFormat;
    }
}

