/*
 * Decompiled with CFR 0.152.
 */
package makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.border.Border;
import org.makagiga.commons.UI;

public class DropShadowBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 715287754750604058L;
    private static final Map<Double, Map<Position, BufferedImage>> CACHE = new HashMap<Double, Map<Position, BufferedImage>>();
    private Color shadowColor;
    private int shadowSize;
    private float shadowOpacity;
    private int cornerSize;
    private boolean showTopShadow;
    private boolean showLeftShadow;
    private boolean showBottomShadow;
    private boolean showRightShadow;

    public DropShadowBorder() {
        this(Color.BLACK, 5);
    }

    public DropShadowBorder(Color color, int n) {
        this(color, n, 0.5f, 12, false, false, true, true);
    }

    public DropShadowBorder(boolean bl) {
        this(Color.BLACK, 5, 0.5f, 12, false, bl, true, true);
    }

    public DropShadowBorder(Color color, int n, float f, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.shadowColor = color;
        this.shadowSize = n;
        this.shadowOpacity = f;
        this.cornerSize = n2;
        this.showTopShadow = bl;
        this.showLeftShadow = bl2;
        this.showBottomShadow = bl3;
        this.showRightShadow = bl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Map<Position, BufferedImage> map = this.getImages((Graphics2D)graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Rectangle rectangle;
            int n5 = 2;
            Point point = null;
            if (this.showLeftShadow || this.showTopShadow) {
                point = new Point();
                if (this.showLeftShadow && !this.showTopShadow) {
                    point.setLocation(n, n2 + n5);
                } else if (this.showLeftShadow && this.showTopShadow) {
                    point.setLocation(n, n2);
                } else if (!this.showLeftShadow && this.showTopShadow) {
                    point.setLocation(n + this.shadowSize, n2);
                }
            }
            Point point2 = null;
            if (this.showLeftShadow || this.showBottomShadow) {
                point2 = new Point();
                if (this.showLeftShadow && !this.showBottomShadow) {
                    point2.setLocation(n, n2 + n4 - this.shadowSize - this.shadowSize);
                } else if (this.showLeftShadow && this.showBottomShadow) {
                    point2.setLocation(n, n2 + n4 - this.shadowSize);
                } else if (!this.showLeftShadow && this.showBottomShadow) {
                    point2.setLocation(n + this.shadowSize, n2 + n4 - this.shadowSize);
                }
            }
            Point point3 = null;
            if (this.showRightShadow || this.showBottomShadow) {
                point3 = new Point();
                if (this.showRightShadow && !this.showBottomShadow) {
                    point3.setLocation(n + n3 - this.shadowSize, n2 + n4 - this.shadowSize - this.shadowSize);
                } else if (this.showRightShadow && this.showBottomShadow) {
                    point3.setLocation(n + n3 - this.shadowSize, n2 + n4 - this.shadowSize);
                } else if (!this.showRightShadow && this.showBottomShadow) {
                    point3.setLocation(n + n3 - this.shadowSize - this.shadowSize, n2 + n4 - this.shadowSize);
                }
            }
            Point point4 = null;
            if (this.showRightShadow || this.showTopShadow) {
                point4 = new Point();
                if (this.showRightShadow && !this.showTopShadow) {
                    point4.setLocation(n + n3 - this.shadowSize, n2 + n5);
                } else if (this.showRightShadow && this.showTopShadow) {
                    point4.setLocation(n + n3 - this.shadowSize, n2);
                } else if (!this.showRightShadow && this.showTopShadow) {
                    point4.setLocation(n + n3 - this.shadowSize - this.shadowSize, n2);
                }
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            if (this.showLeftShadow) {
                rectangle = new Rectangle(n, point.y + this.shadowSize, this.shadowSize, point2.y - point.y - this.shadowSize);
                graphics2D.drawImage(map.get((Object)Position.LEFT), rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
            }
            if (this.showBottomShadow) {
                rectangle = new Rectangle(point2.x + this.shadowSize, n2 + n4 - this.shadowSize, point3.x - point2.x - this.shadowSize, this.shadowSize);
                graphics2D.drawImage(map.get((Object)Position.BOTTOM), rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
            }
            if (this.showRightShadow) {
                rectangle = new Rectangle(n + n3 - this.shadowSize, point4.y + this.shadowSize, this.shadowSize, point3.y - point4.y - this.shadowSize);
                graphics2D.drawImage(map.get((Object)Position.RIGHT), rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
            }
            if (this.showTopShadow) {
                rectangle = new Rectangle(point.x + this.shadowSize, n2, point4.x - point.x - this.shadowSize, this.shadowSize);
                graphics2D.drawImage(map.get((Object)Position.TOP), rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
            }
            if (this.showLeftShadow || this.showTopShadow) {
                graphics2D.drawImage((Image)map.get((Object)Position.TOP_LEFT), point.x, point.y, null);
            }
            if (this.showLeftShadow || this.showBottomShadow) {
                graphics2D.drawImage((Image)map.get((Object)Position.BOTTOM_LEFT), point2.x, point2.y, null);
            }
            if (this.showRightShadow || this.showBottomShadow) {
                graphics2D.drawImage((Image)map.get((Object)Position.BOTTOM_RIGHT), point3.x, point3.y, null);
            }
            if (this.showRightShadow || this.showTopShadow) {
                graphics2D.drawImage((Image)map.get((Object)Position.TOP_RIGHT), point4.x, point4.y, null);
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Position, BufferedImage> getImages(Graphics2D graphics2D) {
        Map<Position, BufferedImage> map = CACHE.get((double)this.shadowSize + (double)this.shadowColor.hashCode() * 0.3 + (double)this.shadowOpacity * 0.12);
        if (map == null) {
            map = new HashMap<Position, BufferedImage>();
            int n = this.cornerSize + 1;
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n, n, this.cornerSize, this.cornerSize);
            int n2 = n + this.shadowSize * 2;
            BufferedImage bufferedImage = UI.createCompatibleImage(n2, n2, true);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D2.setPaint(new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), (int)(this.shadowOpacity * 255.0f)));
                graphics2D2.translate(this.shadowSize, this.shadowSize);
                graphics2D2.fill(double_);
            }
            finally {
                graphics2D2.dispose();
            }
            float f = 1.0f / (float)(this.shadowSize * this.shadowSize);
            float[] fArray = new float[this.shadowSize * this.shadowSize];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = f;
            }
            ConvolveOp convolveOp = new ConvolveOp(new Kernel(this.shadowSize, this.shadowSize, fArray));
            BufferedImage bufferedImage2 = UI.createCompatibleImage(n2, n2, true);
            ((Graphics2D)bufferedImage2.getGraphics()).drawImage(bufferedImage, convolveOp, -(this.shadowSize / 2), -(this.shadowSize / 2));
            int n3 = 1;
            int n4 = 1;
            int n5 = this.shadowSize;
            int n6 = this.shadowSize;
            map.put(Position.TOP_LEFT, this.getSubImage(bufferedImage2, n3, n4, n5, n6));
            n3 = 1;
            n4 = n6;
            n5 = this.shadowSize;
            n6 = 1;
            map.put(Position.LEFT, this.getSubImage(bufferedImage2, n3, n4, n5, n6));
            n3 = 1;
            n4 = n;
            n5 = this.shadowSize;
            n6 = this.shadowSize;
            map.put(Position.BOTTOM_LEFT, this.getSubImage(bufferedImage2, n3, n4, n5, n6));
            n3 = this.cornerSize + 1;
            n4 = n;
            n5 = 1;
            n6 = this.shadowSize;
            map.put(Position.BOTTOM, this.getSubImage(bufferedImage2, n3, n4, n5, n6));
            n4 = n3 = n;
            n5 = this.shadowSize;
            n6 = this.shadowSize;
            map.put(Position.BOTTOM_RIGHT, this.getSubImage(bufferedImage2, n3, n4, n5, n6));
            n3 = n;
            n4 = this.cornerSize + 1;
            n5 = this.shadowSize;
            n6 = 1;
            map.put(Position.RIGHT, this.getSubImage(bufferedImage2, n3, n4, n5, n6));
            n3 = n;
            n4 = 1;
            n5 = this.shadowSize;
            n6 = this.shadowSize;
            map.put(Position.TOP_RIGHT, this.getSubImage(bufferedImage2, n3, n4, n5, n6));
            n3 = this.shadowSize;
            n4 = 1;
            n5 = 1;
            n6 = this.shadowSize;
            map.put(Position.TOP, this.getSubImage(bufferedImage2, n3, n4, n5, n6));
            bufferedImage.flush();
            CACHE.put((double)this.shadowSize + (double)this.shadowColor.hashCode() * 0.3 + (double)this.shadowOpacity * 0.12, map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getSubImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage2 = UI.createCompatibleImage(n3, n4, true);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.drawImage(bufferedImage, 0, 0, n3, n4, n, n2, n + n3, n2 + n4, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        int n = this.showTopShadow ? this.shadowSize : 0;
        int n2 = this.showLeftShadow ? this.shadowSize : 0;
        int n3 = this.showBottomShadow ? this.shadowSize : 0;
        int n4 = this.showRightShadow ? this.shadowSize : 0;
        return new Insets(n, n2, n3, n4);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public boolean isShowTopShadow() {
        return this.showTopShadow;
    }

    public boolean isShowLeftShadow() {
        return this.showLeftShadow;
    }

    public boolean isShowRightShadow() {
        return this.showRightShadow;
    }

    public boolean isShowBottomShadow() {
        return this.showBottomShadow;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
    }

    public void setShadowSize(int n) {
        this.shadowSize = n;
    }

    public void setShadowOpacity(float f) {
        this.shadowOpacity = f;
    }

    public void setCornerSize(int n) {
        this.cornerSize = n;
    }

    public void setShowTopShadow(boolean bl) {
        this.showTopShadow = bl;
    }

    public void setShowLeftShadow(boolean bl) {
        this.showLeftShadow = bl;
    }

    public void setShowBottomShadow(boolean bl) {
        this.showBottomShadow = bl;
    }

    public void setShowRightShadow(boolean bl) {
        this.showRightShadow = bl;
    }

    private static enum Position {
        TOP,
        TOP_LEFT,
        LEFT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT,
        RIGHT,
        TOP_RIGHT;

    }
}

