/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.Sidebar;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.Args;
import org.makagiga.commons.Config;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAboutDialog;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MCellTip;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLineBorder;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.MMenuBar;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSettingsDialog;
import org.makagiga.commons.MSettingsPage;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MSplitPane;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MSystemTray;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.MainView;
import org.makagiga.commons.MouseGestures;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.help.Help;
import org.makagiga.commons.help.HelpContext;
import org.makagiga.commons.mods.Mod;
import org.makagiga.commons.mods.Mods;
import org.makagiga.commons.print.PrintDialog;
import org.makagiga.commons.proxy.ProxySettings;
import org.makagiga.commons.script.ScriptError;
import org.makagiga.commons.script.ScriptExecutor;
import org.makagiga.commons.script.ScriptYourself;
import org.makagiga.console.Console;
import org.makagiga.desktop.Desktop;
import org.makagiga.desktop.Pager;
import org.makagiga.desktop.Widget;
import org.makagiga.editors.AnnotationBar;
import org.makagiga.editors.ConsoleTab;
import org.makagiga.editors.Designer;
import org.makagiga.editors.DocumentHelp;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorDesigner;
import org.makagiga.editors.EditorExport;
import org.makagiga.editors.EditorNavigation;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.EditorPrint;
import org.makagiga.editors.EditorSearch;
import org.makagiga.editors.EditorZoom;
import org.makagiga.editors.NavigationUtils;
import org.makagiga.editors.WebBrowserEditor;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.tree.TreeFS;
import org.makagiga.plugins.LookAndFeelSettings;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.plugins.PluginSettings;
import org.makagiga.plugins.PluginType;
import org.makagiga.search.SearchBar;
import org.makagiga.tabs.DesktopTab;
import org.makagiga.tabs.WikiTab;
import org.makagiga.tags.TagsMenu;
import org.makagiga.tools.Autosave;
import org.makagiga.tools.Bookmarks;
import org.makagiga.tools.Browser;
import org.makagiga.tools.DocumentList;
import org.makagiga.tools.EditorQuickFind;
import org.makagiga.tools.GeneralSettings;
import org.makagiga.tools.QuickOpenDialog;
import org.makagiga.tools.SessionManager;
import org.makagiga.tools.presentation.Presentation;
import org.makagiga.tools.summary.SummaryData;
import org.makagiga.tree.ImportExport;
import org.makagiga.tree.LocationBar;
import org.makagiga.tree.PropertiesBar;
import org.makagiga.tree.PropertiesPanel;
import org.makagiga.tree.Tree;
import org.makagiga.tree.TreePanel;
import org.makagiga.tree.TreeSettings;
import org.makagiga.tree.tracker.Tracker;
import org.makagiga.web.wiki.WikiPanel;

public final class MainWindow
extends MMainWindow {
    private Bookmarks.Menu bookmarksMenu;
    private final DesktopTab desktopTab;
    private final DocumentList documentList;
    private Editor<?> lastTab;
    private int viewMenuItemCount;
    private JComponent tabBar;
    private static MainWindow _instance;
    private Map<String, Object> elements;
    private MLabel editorStatusText;
    private MMenu editMenu;
    private MMenu exportMenu;
    private MMenu fileMenu;
    private MMenu goToMenu;
    private MMenu helpMenu;
    private MMenu importMenu;
    private MMenu tabsMenu;
    private MMenu tagsMenu;
    private MMenu toolsMenu;
    private MMenu viewMenu;
    private final MPanel tabPanel;
    private final MSplitPane mainSplitPane;
    private MToolBar editorToolBar;
    private final MToolBar mainToolBar;
    private final Object updateComponentsLock = new Object();
    private final Object updateStateLock = new Object();
    private EmailAction emailAction;
    private PrintAction printAction;
    private FindAction findAction;
    private FindNextAction findNextAction;
    private ToggleSummaryAction toggleSummaryAction;
    private ToggleDesignerAction toggleDesignerAction;
    private ToggleDesktopAction toggleDesktopAction;
    private ShowHideSidebarAction showHideSidebarAction;
    private ShowHideLocationBarAction showHideLocationBarAction;
    private ShowHideMainToolBarAction showHideMainToolBarAction;
    private ShowHidePropertiesBarAction showHidePropertiesBarAction;
    private MApplication.ToggleStatusBarAction toggleStatusBarAction;
    private Presentation.Action presentationAction;
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private SearchBar.Action searchAction;
    private Console.Action consoleAction;
    private ConfigureAction configureAction;
    private HelpAction helpAction;
    private DocumentHelpAction documentHelpAction;
    private MAction quickOpenAction;

    public Desktop getDesktop() {
        return (Desktop)this.desktopTab.getCore();
    }

    public Object getElementById(String string) {
        if (this.elements == null) {
            this.elements = TK.newHashMap("file-menu", this.fileMenu, "tabs-menu", this.tabsMenu, "import-menu", this.importMenu, "export-menu", this.exportMenu, "edit-menu", this.editMenu, "view-menu", this.viewMenu, "goto-menu", this.goToMenu, "bookmarks-menu", this.bookmarksMenu, "tags-menu", this.tagsMenu, "tools-menu", this.toolsMenu, "help-menu", this.helpMenu, "main-tool-bar", this.mainToolBar, "main-split-pane", this.mainSplitPane, "tab-panel", this.tabPanel, "previous-action", NavigationUtils.getPreviousAction(), "next-action", NavigationUtils.getNextAction(), "presentation-action", this.presentationAction, "quick-open-action", this.quickOpenAction);
        }
        this.elements.put("editor-tool-bar", this.editorToolBar);
        return this.elements.get(string);
    }

    public static synchronized MainWindow getInstance() {
        if (_instance == null) {
            new MainWindow();
        }
        return _instance;
    }

    public void installTabBar(JComponent jComponent) {
        if (jComponent != null) {
            jComponent.setVisible(true);
        }
        UI.replaceComponent(this.tabPanel, this.tabBar, jComponent, "Last", true);
        this.tabBar = jComponent;
    }

    @Override
    public boolean isDesktopVisible() {
        return this.desktopTab != null && this.desktopTab.isCurrent();
    }

    @Override
    public void setDesktopVisible(boolean bl) {
        Editor editor;
        Editor editor2;
        Tabs tabs = Tabs.getInstance();
        if (bl) {
            editor2 = (Editor)tabs.getSelectedTab();
            if (editor2 != this.desktopTab) {
                this.lastTab = editor2;
            }
            editor = this.desktopTab;
        } else {
            editor = this.lastTab;
            if ((editor == null || tabs.indexOfComponent(editor) == -1) && tabs.getTabCount() > 1) {
                editor = (Editor)tabs.getTabAt(1);
            }
        }
        tabs.selectEditor(editor);
        if (tabs.getTabCount() == 1 && (editor2 = (Editor)tabs.getSelectedTab()) == this.desktopTab) {
            this.desktopTab.focus();
        }
    }

    @Deprecated
    public boolean isHorizontalSplit() {
        return this.mainSplitPane.getOrientation() == 1;
    }

    public static boolean isInstance() {
        return _instance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object onDynamicInit(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = object;
        synchronized (object2) {
            if (object instanceof MouseGestures) {
                Tabs tabs = Tabs.getInstance();
                TreePanel treePanel = TreePanel.getInstance();
                MouseGestures mouseGestures = (MouseGestures)object;
                mouseGestures.registerGesture("D", (Action)treePanel.getActionGroup().getAction("new-file"));
                if (((Boolean)Kiosk.consoleEnabled.get()).booleanValue()) {
                    mouseGestures.add(this.consoleAction);
                }
                mouseGestures.registerGesture("Ds", (Action)treePanel.getActionGroup().getAction("new-folder"));
                mouseGestures.registerGesture("DR", tabs.getCloseAction());
                mouseGestures.registerGesture("DRs", tabs.getCloseAllAction());
                mouseGestures.registerGesture("L", NavigationUtils.getPreviousAction());
                mouseGestures.registerGesture("Lc", this.toggleDesignerAction);
                mouseGestures.registerGesture("LD", this.searchAction);
                mouseGestures.registerGesture("LR", new MAction(UI._("Show/Hide Sidebar")){

                    @Override
                    public void onAction() {
                        MainWindow.this.mainSplitPane.toggleSidebar();
                    }
                });
                mouseGestures.registerGesture("Ls", this.toggleSummaryAction);
                mouseGestures.registerGesture("LU", new MAction(UI._("Show Tree")){

                    @Override
                    public void onAction() {
                        Sidebar.getInstance().goTo(Sidebar.Tab.TREE);
                    }
                });
                mouseGestures.registerGesture("R", NavigationUtils.getNextAction());
                mouseGestures.add(this.documentList.getAction());
                mouseGestures.registerGesture("Uc", (Action)TreePanel.getInstance().getActionGroup().getAction("properties"));
                mouseGestures.registerGesture("Ucs", this.configureAction);
                mouseGestures.registerGesture("UD", this.toggleDesktopAction);
                mouseGestures.registerGesture("UR", UI._("Find Text"), this.findAction);
                mouseGestures.registerGesture("URDL", this.printAction);
                mouseGestures.registerGesture("Us", this.presentationAction);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object onDynamicInit(Object object, Object object2) {
        if (object instanceof TrayIcon) {
            if (object2 instanceof MMenu) {
                MMenu mMenu = (MMenu)object2;
                mMenu.add((Action)TreePanel.getInstance().getActionGroup().getAction("quick-paste"));
                mMenu.add(new Bookmarks.Menu(MIcon.small("ui/bookmark"), false));
                PluginManager.updateMenu(mMenu, "TRAY_MENU", false);
            } else if (object2 instanceof MouseEvent) {
                Object object3 = object2;
                synchronized (object3) {
                    MouseEvent mouseEvent = (MouseEvent)object2;
                    if (MMouseAdapter.isMiddle(mouseEvent)) {
                        ImportExport.importClipboard();
                        return true;
                    }
                }
            }
        }
        return null;
    }

    public synchronized void saveSession(int n) {
        MLogger.info("makagiga", "Saving session...");
        Config config = Config.getDefault();
        config.write("Splitter.Main.location", this.mainSplitPane.getDividerLocation());
        config.write("PropertiesBar.enabled", this.showHidePropertiesBarAction.isSelected());
        config.write("StatusBar.enabled", this.toggleStatusBarAction.isSelected());
        config.write("ToolBar.Main.enabled", this.showHideMainToolBarAction.isSelected());
        PropertiesBar.sync();
        Tabs.getInstance().saveAllEditors(n);
        Tree.getInstance().saveAllItems();
        SessionManager.save();
        this.getDesktop().saveSession();
        config.sync();
    }

    public void setEditorStatusText(String string) {
        this.editorStatusText.setText(string);
        this.editorStatusText.setToolTipText(string);
        this.editorStatusText.setVisible(!TK.isEmpty(string));
    }

    public void showProperties(MetaInfo ... metaInfoArray) {
        PropertiesPanel.showDialog(this, metaInfoArray);
    }

    public static void showSidebar() {
        MainWindow.showSidebar(null, false);
    }

    public static void showSidebar(Sidebar.Tab tab, boolean bl) {
        MainWindow mainWindow = MainWindow.getInstance();
        Sidebar.show(tab, bl, mainWindow.mainSplitPane);
    }

    public static void showTree(MetaInfo metaInfo) {
        MainWindow.showSidebar();
        Sidebar.getInstance().goTo(Sidebar.Tab.TREE, false);
        if (metaInfo != null) {
            Tree.getInstance().focusItem(metaInfo);
        }
    }

    public static void showWidget(Widget widget, boolean bl) {
        MainWindow mainWindow = MainWindow.getInstance();
        if (bl) {
            mainWindow.restore();
        }
        mainWindow.setDesktopVisible(true);
        Pager.getInstance().setCurrent(widget.getDesktopNumber());
        widget.select();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateComponents(MetaInfo ... metaInfoArray) {
        MetaInfo[] metaInfoArray2 = this.updateComponentsLock;
        synchronized (this.updateComponentsLock) {
            Tabs tabs = Tabs.getInstance();
            if (metaInfoArray != null) {
                Editor editor = (Editor)tabs.getSelectedTab();
                for (MetaInfo metaInfo : metaInfoArray) {
                    if (!metaInfo.isFile() && !metaInfo.isVirtualFile()) continue;
                    tabs.setTabInfo(metaInfo);
                    Editor<?> lockable = tabs.getTabAt(metaInfo);
                    if (lockable == null) continue;
                    boolean bl = !metaInfo.canModify();
                    lockable.setLocked(bl);
                    if (lockable instanceof EditorDesigner) {
                        ((Designer)((EditorDesigner)EditorDesigner.class.cast(lockable)).getEditorDesigner()).setLocked(bl);
                    }
                    lockable.updateActions();
                }
                if (editor != null) {
                    LocationBar.getInstance().update(editor.getMetaInfo());
                }
            }
            this.updateTitle();
            TreePanel.getInstance().updateActions();
            // ** MonitorExit[metaInfoArray2] (shouldn't be in output)
            if (!TK.isEmpty(metaInfoArray)) {
                for (MetaInfo metaInfo : metaInfoArray) {
                    metaInfo.refresh(true);
                }
            }
            return;
        }
    }

    @Override
    protected void onMinimize() {
        this.saveSession(1);
    }

    private MainWindow() {
        if (_instance != null) {
            throw new WTFError("org.makagiga.MainWindow already created");
        }
        _instance = this;
        Tabs tabs = Tabs.getInstance();
        Sidebar sidebar = Sidebar.getInstance();
        PluginManager.Table table = PluginManager.getTable();
        this.documentList = new DocumentList();
        this.initActions();
        this.initMenuBar(table);
        this.initStatusBar();
        this.mainSplitPane = new MSplitPane();
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setSidebar(sidebar);
        this.tabPanel = new MPanel(){

            @Override
            public void updateUI() {
                super.updateUI();
                if (UI.isMetal()) {
                    this.setBackground(MColor.WHITE);
                }
            }
        };
        this.tabPanel.addCenter(tabs);
        TreePanel treePanel = TreePanel.getInstance();
        PluginManager.updateToolBar(table, treePanel.getToolBar(), "TREE_TOOL_BAR", false);
        this.mainToolBar = new MToolBar(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(dimension.width, Math.max(16, dimension.height));
            }
        };
        this.mainToolBar.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        MWhatsThis.set(this.mainToolBar, UI._("Main Tool Bar"));
        PluginManager.updateToolBar(table, this.mainToolBar, "MAIN_TOOL_BAR", true);
        this.mainToolBar.readConfig("main");
        this.mainToolBar.addStretch();
        this.addNorth(this.mainToolBar);
        this.desktopTab = new DesktopTab(Desktop.getInstance());
        tabs.addEditor(this.desktopTab);
        this.mainSplitPane.setRightComponent(this.tabPanel);
        this.addCenter(this.mainSplitPane);
        if (((Boolean)MApplication.consoleOpenInTab.get()).booleanValue()) {
            ConsoleTab.install();
        }
        this.restoreSession();
        ScriptException scriptException = null;
        try {
            ScriptExecutor.executeUserScript();
        }
        catch (ScriptException scriptException2) {
            scriptException = scriptException2;
        }
        boolean bl = Args.isSet("autostart");
        tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MainWindow.this.updateState();
            }
        });
        Autosave.init();
        this.setMouseGestures(new MouseGestures(){

            @Override
            public boolean canShowMessage() {
                return !Presentation.isActive();
            }
        });
        MSystemTray.setVisible((Boolean)UI.systemTray.get());
        if (bl && MSystemTray.getIcon() == null) {
            this.setState(1);
            this.setVisible(true);
        }
        if (scriptException != null) {
            ScriptError.getSharedInstance().showError(scriptException);
        }
        PluginManager.postInit();
        if (!bl) {
            if (Args.isSet("full-screen")) {
                this.setFullScreen(true);
            } else if (Args.isSet("presentation")) {
                Presentation.setActive(true);
            }
            this.setVisible(true);
        }
        if (tabs.getTabCount() > 1) {
            tabs.selectEditorAt(tabs.findEditor(SessionManager.getCurrentItem()));
        }
        MStatusBar.ready();
        this.updateState();
        if (tabs.getTabCount() == 1) {
            Tree.getInstance().requestFocusInWindow();
        }
        Tracker.addTrackerListener(SummaryData.getInstance());
        Tracker.startScheduler();
        Mods.add("initCredits@org.makagiga.commons.MAboutDialog", new Mod(){

            @Override
            public Object exec(Object object, String string, Object ... objectArray) {
                if (object instanceof MAboutDialog) {
                    MAboutDialog mAboutDialog = (MAboutDialog)object;
                    mAboutDialog.addCredit("Thotheolh", "Coding, Testing, Ideas...", "http://sourceforge.net/users/thotheolh");
                    mAboutDialog.addCredit("Dewitte Pierre-Alban", "Various PIM improvements", null);
                    mAboutDialog.addCredit("M. Korbar", "German Translation, Ideas, Testing", null);
                }
                return null;
            }
        });
        Mods.replace("showPanel@org.makagiga.web.wiki.WikiPanel", new Mod(){

            @Override
            public Object exec(Object object, String string, Object ... objectArray) {
                if (objectArray.length == 1 && objectArray[0] instanceof URI) {
                    URI uRI = (URI)objectArray[0];
                    Tabs tabs = Tabs.getInstance();
                    WikiTab wikiTab = tabs.findEditor(WikiTab.class);
                    if (wikiTab != null) {
                        wikiTab.getWikiPanel().setPageURI(uRI);
                        tabs.selectEditor(wikiTab);
                    } else {
                        tabs.addEditor(new WikiTab(new WikiPanel(uRI)));
                    }
                    return true;
                }
                return false;
            }
        });
        Mods.replace("handleURL@org.makagiga.commons.WebBrowser", new Mod(){

            @Override
            public Object exec(Object object, String string, Object ... objectArray) {
                if (objectArray.length == 1 && objectArray[0] instanceof URL) {
                    URL uRL = (URL)objectArray[0];
                    Browser.openURL(uRL.toString());
                    return true;
                }
                return false;
            }
        });
    }

    private void initActions() {
        this.emailAction = new EmailAction();
        this.printAction = new PrintAction();
        this.findAction = new FindAction();
        this.toggleSummaryAction = new ToggleSummaryAction();
        this.toggleDesignerAction = new ToggleDesignerAction();
        this.toggleDesktopAction = new ToggleDesktopAction();
        this.showHideSidebarAction = new ShowHideSidebarAction();
        this.showHideLocationBarAction = new ShowHideLocationBarAction();
        this.showHideMainToolBarAction = new ShowHideMainToolBarAction();
        this.showHidePropertiesBarAction = new ShowHidePropertiesBarAction();
        this.toggleStatusBarAction = new MApplication.ToggleStatusBarAction(this.getStatusBar());
        this.presentationAction = new Presentation.Action();
        this.searchAction = new SearchBar.Action();
        this.consoleAction = new Console.Action();
        this.configureAction = new ConfigureAction();
        this.helpAction = new HelpAction();
        this.documentHelpAction = new DocumentHelpAction();
        this.quickOpenAction = new QuickOpenDialog.Action();
        Tabs tabs = Tabs.getInstance();
        MainView.bind(new QuickSaveAction(), this.quickOpenAction, this.searchAction, this.toggleDesignerAction, this.toggleDesktopAction, this.toggleSummaryAction, NavigationUtils.getPreviousAction(), NavigationUtils.getNextAction(), tabs.getCloseAllAction(), tabs.getCloseAction());
    }

    private void initExportMenu() {
        List<EditorPlugin.FileType> list;
        Object object;
        this.exportMenu.removeAll();
        this.exportMenu.setSplitMenu(true);
        Editor editor = (Editor)Tabs.getInstance().getSelectedTab();
        if (editor != null && editor.getInfo() != null) {
            this.exportMenu.addTitle(UI._("Export \"{0}\"", editor.getMetaInfo()));
            if (editor instanceof EditorExport) {
                object = (EditorPlugin)editor.getInfo().getPluggable();
                list = ((EditorPlugin)object).getExportTypes();
                if (!list.isEmpty()) {
                    for (EditorPlugin.FileType fileType : list) {
                        this.exportMenu.add(new ImportExport.ExportAction(fileType));
                    }
                    this.exportMenu.addSeparator();
                }
                this.exportMenu.add(new ImportExport.ExportAction(new EditorPlugin.FileType("png", UI._("PNG Image (document screenshot)"), "image/png", true)));
            } else {
                this.exportMenu.addTitle(UI._("Export is not supported"), "ui/info");
            }
        }
        if ((list = ((MetaInfo)(object = Tree.getInstance().getCurrentFolder(false))).getFS()) instanceof PluginMenu) {
            ((PluginMenu)PluginMenu.class.cast(list)).updateMenu("EXPORT_MENU", this.exportMenu);
        }
        if (this.exportMenu.isEmpty()) {
            this.exportMenu.addTitle(UI._("Open or select a tab you want to export"), "ui/info");
        }
        if (OS.isLinux() && ((Boolean)Vars.actionSendFile.get()).booleanValue()) {
            this.emailAction.setEnabled(editor != null && editor.getMetaInfo().isFile());
            this.exportMenu.addSeparator(false);
            this.exportMenu.add(this.emailAction);
        }
    }

    private void initMenuBar(PluginManager.Table table) {
        Tabs tabs = Tabs.getInstance();
        MMenuBar mMenuBar = new MMenuBar();
        MWhatsThis.set(mMenuBar, UI._("Main Menu")).setKeyStroke(121);
        this.fileMenu = new MMenu(UI._("&File"));
        this.fileMenu.setSplitMenu(true);
        this.tabsMenu = tabs.createTabsMenu();
        PluginManager.updateMenu(table, this.fileMenu, "FILE_MENU", true);
        this.importMenu = new ImportMenu();
        this.exportMenu = new MMenu(UI._("Export"));
        UI.setHTMLHelp(this.exportMenu, UI._("Exports the content of the active document.<br>For example, you can save a \"todo\" table in the HTML format."));
        this.exportMenu.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                MainWindow.this.initExportMenu();
            }
        });
        if (!((Boolean)Kiosk.actionExport.get()).booleanValue()) {
            this.exportMenu.setEnabled(false);
        }
        this.fileMenu.add(this.importMenu);
        this.fileMenu.add(this.exportMenu);
        this.fileMenu.add(this.printAction);
        MAction mAction = MApplication.getQuitAction();
        mAction.setHTMLHelp(UI._("Quits the application.<br>All the modified files are saved automatically."));
        if (((Boolean)Kiosk.actionQuit.get()).booleanValue()) {
            this.fileMenu.addSeparator();
            this.fileMenu.add(mAction);
        }
        mMenuBar.add(this.fileMenu);
        this.editMenu = new MMenu(UI._("&Edit"));
        this.editMenu.addMenuListener(new MMenuAdapter(){

            @Override
            protected void onSelect(MMenu mMenu) {
                MainWindow.this.updateEditMenu((Editor)Tabs.getInstance().getSelectedTab());
            }
        });
        mMenuBar.add(this.editMenu);
        this.viewMenu = new MMenu(UI._("&View"));
        MMenu mMenu = new MMenu(UI._("Tool Bars"));
        if (!((Boolean)Kiosk.toolBarLocked.get()).booleanValue()) {
            mMenu.addCheckBox(this.showHideLocationBarAction);
            mMenu.addCheckBox(this.showHideMainToolBarAction);
            mMenu.addCheckBox(this.showHidePropertiesBarAction);
            mMenu.addCheckBox(this.toggleStatusBarAction);
            mMenu.addSeparator();
        }
        mMenu.add(this.showHideSidebarAction);
        this.viewMenu.add(mMenu);
        this.goToMenu = new MMenu("Go To");
        if (((Boolean)Kiosk.actionFullScreen.get()).booleanValue()) {
            this.viewMenu.add(new MApplication.FullScreenAction());
        }
        if (((Boolean)Vars.actionPresentation.get()).booleanValue()) {
            this.viewMenu.add(this.presentationAction);
        }
        PluginManager.updateMenu(table, this.viewMenu, "VIEW_MENU_ALL", false);
        this.viewMenuItemCount = this.viewMenu.getItemCount();
        mMenuBar.add(this.viewMenu);
        this.bookmarksMenu = new Bookmarks.Menu(null);
        mMenuBar.add(this.bookmarksMenu);
        this.tagsMenu = new TagsMenu();
        mMenuBar.add(this.tagsMenu);
        this.toolsMenu = new MMenu(UI._("&Tools"));
        this.toolsMenu.setSplitMenu(true);
        if (((Boolean)Kiosk.consoleEnabled.get()).booleanValue()) {
            this.toolsMenu.add(this.consoleAction);
        }
        PluginManager.updateMenu(table, this.toolsMenu, "TOOLS_MENU", false);
        this.toolsMenu.addSeparator();
        if (((Boolean)Kiosk.pluginManager.get()).booleanValue()) {
            this.toolsMenu.add(new PluginSettings.Action());
        }
        this.toolsMenu.add(this.configureAction);
        mMenuBar.add(this.toolsMenu);
        this.helpMenu = new MMenu(UI._("&Help"));
        this.helpMenu.add(this.helpAction);
        this.helpMenu.add(this.documentHelpAction);
        if (((Boolean)Kiosk.actionWhatsThis.get()).booleanValue()) {
            this.helpMenu.add(MWhatsThis.createAction(this));
        }
        this.helpMenu.addSeparator();
        PluginManager.updateMenu(table, this.helpMenu, "HELP_MENU", true);
        this.helpMenu.add(new MApplication.AboutAction());
        mMenuBar.add(this.helpMenu);
        mMenuBar.add(LocationBar.getInstance());
        mMenuBar.add(Box.createHorizontalGlue());
        mMenuBar.add(this.documentList);
        if (!((Boolean)Kiosk.mainWindowShowMenuBar.get()).booleanValue()) {
            mMenuBar.setMinimized(true);
        }
        this.setJMenuBar(mMenuBar);
    }

    private void initStatusBar() {
        MStatusBar mStatusBar = this.getStatusBar();
        this.editorStatusText = new MLabel();
        this.editorStatusText.setStyle("margin-right: 5px");
        mStatusBar.addStretch();
        mStatusBar.add(this.editorStatusText);
    }

    private void restoreSession() {
        Config config = Config.getDefault();
        int n = config.readInt("Splitter.Main.location", 250);
        this.mainSplitPane.setDividerLocation(n);
        this.mainSplitPane.setSidebarVisible(n == -1 || this.mainSplitPane.isSidebarVisible());
        this.showHideLocationBarAction.setSelected((Boolean)Vars.treeLocationBarVisible.get());
        this.showHidePropertiesBarAction.setSelected(config.read("PropertiesBar.enabled", true));
        this.getStatusBar().setClosed(!config.read("StatusBar.enabled", true));
        this.showHideMainToolBarAction.setSelected(config.read("ToolBar.Main.enabled", false) && this.mainToolBar.getComponentCount() > 1);
        this.mainToolBar.setVisible(this.showHideMainToolBarAction.isSelected());
        SessionManager.restore();
        this.getDesktop().restoreSession();
    }

    private void updateEditMenu(Editor<?> editor) {
        this.editMenu.removeAll();
        if (editor != null) {
            if (editor instanceof PluginMenu) {
                PluginMenu pluginMenu = (PluginMenu)((Object)editor);
                pluginMenu.updateMenu("EDIT_MENU", this.editMenu);
            }
            if (editor instanceof EditorSearch) {
                int n = ((EditorSearch)EditorSearch.class.cast(editor)).getSupportedSearchOptions();
                boolean bl = (n & 2) == 0;
                this.findAction.setEnabled(bl);
                if (this.findNextAction == null) {
                    this.findNextAction = new FindNextAction();
                }
                this.findNextAction.setEnabled(bl);
                if (bl) {
                    this.editMenu.addTitle(UI._("Search"));
                    this.editMenu.add(this.findAction);
                    this.editMenu.add(this.findNextAction);
                }
            } else {
                this.findAction.setEnabled(false);
                if (this.findNextAction != null) {
                    this.findNextAction.setEnabled(false);
                }
            }
        }
        if (this.editMenu.isEmpty()) {
            this.editMenu.addTitle(UI._("No Items"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState() {
        Object object = this.updateStateLock;
        synchronized (object) {
            JComponent jComponent;
            Tabs tabs = Tabs.getInstance();
            if (tabs.removingTab) {
                return;
            }
            Designer designer = null;
            this.viewMenu.removeFrom(this.viewMenuItemCount);
            tabs.updateState();
            MAction mAction = tabs.getCloseAction();
            this.tabsMenu.setEnabled(mAction.isEnabled());
            MetaInfo metaInfo = tabs.getCurrentMetaInfo();
            Tree.getInstance().focusItem(metaInfo);
            Editor editor = (Editor)tabs.getSelectedTab();
            NavigationUtils.updateActions(editor, metaInfo);
            if (editor != null) {
                Object object2;
                Object object3;
                this.documentHelpAction.updateProperties(editor);
                jComponent = LocationBar.getInstance();
                ((LocationBar)jComponent).update(metaInfo);
                ((LocationBar)jComponent).setVisible(true);
                MMenu.Title title = this.viewMenu.addTitle(UI._("Current Tab"));
                int n = this.viewMenu.getItemCount();
                if (editor instanceof EditorNavigation && ((object3 = (EditorNavigation)((Object)editor)).getNavigationCapabilities() & 0x20) != 0) {
                    this.viewMenu.add(NavigationUtils.getPreviousAction());
                    this.viewMenu.add(NavigationUtils.getNextAction());
                }
                if (editor instanceof EditorZoom) {
                    object3 = (EditorZoom)((Object)editor);
                    if (this.zoomInAction == null) {
                        this.zoomInAction = new ZoomInAction();
                    }
                    this.zoomInAction.setEnabled(object3.isZoomEnabled(EditorZoom.ZoomType.IN));
                    this.viewMenu.add(this.zoomInAction);
                    if (this.zoomOutAction == null) {
                        this.zoomOutAction = new ZoomOutAction();
                    }
                    this.zoomOutAction.setEnabled(object3.isZoomEnabled(EditorZoom.ZoomType.OUT));
                    this.viewMenu.add(this.zoomOutAction);
                }
                if (editor instanceof PluginMenu) {
                    PluginManager.updateMenu((PluginMenu)((Object)editor), this.viewMenu, "VIEW_MENU_EDITOR", false);
                }
                if (this.viewMenu.getItemCount() == n) {
                    title.setVisible(false);
                }
                if (editor instanceof EditorDesigner) {
                    designer = (Designer)((EditorDesigner)EditorDesigner.class.cast(editor)).getEditorDesigner();
                    ((EditorDesigner)EditorDesigner.class.cast(editor)).updateEditorDesigner();
                }
                if (this.editorToolBar == null) {
                    this.editorToolBar = new MToolBar();
                    this.editorToolBar.setID("editor");
                    MWhatsThis.set(this.editorToolBar, UI._("Tab Tool Bar\nEach tab has its own tool bar"));
                } else {
                    this.editorToolBar.removeAll();
                }
                this.editorToolBar.setTextPosition(editor.getPreferredToolBarTextPosition());
                this.editorToolBar.putClientProperty("org.makagiga.commons.script.ScriptYourself.CONTEXT_PROPERTY", editor.getClass().getName());
                object3 = editor.getSupportsToolBarUnderTabs() && editor.getLayout() instanceof BorderLayout ? editor : this.tabPanel;
                this.editorToolBar.setOpaque(object3 == editor);
                Container container = this.editorToolBar.getParent();
                if (container != object3) {
                    if (container != null) {
                        container.remove(this.editorToolBar);
                        container.validate();
                    }
                    ((Container)object3).add((Component)this.editorToolBar, "First");
                    ((Container)object3).validate();
                }
                if (object3 == editor) {
                    this.editorToolBar.showLineBorder(MLineBorder.Position.BOTTOM);
                } else {
                    this.editorToolBar.setBorder(null);
                    this.editorToolBar.setBorderPainted(false);
                }
                if (editor instanceof EditorPrint) {
                    if (editor instanceof WebBrowserEditor && !((WebBrowserEditor)WebBrowserEditor.class.cast(editor)).isPrintActionVisible()) {
                        this.printAction.setEnabled(false);
                    } else {
                        this.printAction.setEnabled(true);
                    }
                } else {
                    this.printAction.setEnabled(false);
                }
                if (editor instanceof PluginMenu) {
                    object2 = (PluginMenu)((Object)editor);
                    object2.updateToolBar("EDITOR_TOOL_BAR", this.editorToolBar);
                }
                PluginManager.updateToolBar(this.editorToolBar, "EDITOR_TOOL_BAR", false);
                ScriptYourself.install(this.editorToolBar);
                this.editorToolBar.addStretch();
                if (editor instanceof EditorNavigation && ((object2 = (EditorNavigation)((Object)editor)).getNavigationCapabilities() & 0x10) != 0) {
                    JComponent jComponent2 = object2.getNavigationComponent();
                    if (jComponent2 != null) {
                        this.editorToolBar.add(jComponent2);
                        this.editorToolBar.addGap();
                    }
                    this.editorToolBar.add(NavigationUtils.getPreviousAction());
                    this.editorToolBar.add(NavigationUtils.getNextAction(), 1);
                }
                if (editor instanceof EditorZoom && ((Boolean)Kiosk.actionZoom.get()).booleanValue() && (object2 = ((EditorZoom)EditorZoom.class.cast(editor)).getZoomComponent()) != null) {
                    this.editorToolBar.addGap();
                    this.editorToolBar.add((Component)object2);
                    this.editorToolBar.addGap();
                    this.editorToolBar.addButton(new MSmallButton(this.zoomInAction, false), 2);
                    this.editorToolBar.addButton(new MSmallButton(this.zoomOutAction, false), 2);
                }
                this.editorToolBar.setVisible(!Presentation.isActive() || editor == this.desktopTab);
                this.editorToolBar.validate();
                this.editorToolBar.repaint();
                this.editorStatusText.setVisible(true);
                this.setEditorStatusText(editor.getStatusText());
                editor.updateActions();
            }
            this.updateEditMenu(editor);
            this.updateTabBar(editor);
            if (PropertiesBar.isInstance()) {
                jComponent = PropertiesBar.getInstance();
                ((PropertiesBar)jComponent).setMetaInfo(metaInfo);
                ((PropertiesBar)jComponent).showOrHide(this.showHidePropertiesBarAction.isSelected());
            }
            AnnotationBar.getInstance().setEditor(editor);
            Sidebar.getInstance().update(editor, designer, this.toggleDesignerAction);
            this.updateTitle();
            MCellTip.getInstance().setVisible(false);
            if (editor != null) {
                UI.requestFocus(editor);
            }
        }
    }

    private void updateTabBar(Editor<?> editor) {
        if (editor == null) {
            this.installTabBar(null);
        } else if (editor instanceof EditorSearch && EditorQuickFind.isInstance() && this.tabBar == EditorQuickFind.getInstance()) {
            this.installTabBar(EditorQuickFind.getInstance());
        } else if (editor.getMetaInfo().isDummy()) {
            this.installTabBar(null);
        } else if (this.showHidePropertiesBarAction.isSelected()) {
            PropertiesBar propertiesBar = PropertiesBar.getInstance();
            this.installTabBar(propertiesBar);
            propertiesBar.showOrHide(true);
        }
    }

    private void updateTitle() {
        MetaInfo metaInfo = Tabs.getInstance().getCurrentMetaInfo();
        this.updateTitle(metaInfo == null ? null : metaInfo.toString());
    }

    private void zoomEditor(EditorZoom.ZoomType zoomType) {
        Editor editor = (Editor)Tabs.getInstance().getSelectedTab();
        if (editor instanceof EditorZoom) {
            EditorZoom editorZoom = (EditorZoom)((Object)editor);
            editorZoom.zoom(zoomType);
            this.zoomInAction.setEnabled(editorZoom.isZoomEnabled(EditorZoom.ZoomType.IN));
            this.zoomOutAction.setEnabled(editorZoom.isZoomEnabled(EditorZoom.ZoomType.OUT));
        }
    }

    private static final class ZoomOutAction
    extends MApplication.ZoomOutAction {
        private ZoomOutAction() {
        }

        @Override
        public void onAction() {
            MainWindow.getInstance().zoomEditor(EditorZoom.ZoomType.OUT);
        }
    }

    private static final class ZoomInAction
    extends MApplication.ZoomInAction {
        private ZoomInAction() {
        }

        @Override
        public void onAction() {
            MainWindow.getInstance().zoomEditor(EditorZoom.ZoomType.IN);
        }
    }

    private static final class ToggleSummaryAction
    extends MAction {
        @Override
        public void onAction() {
            MainWindow.showSidebar(Sidebar.Tab.SUMMARY, true);
        }

        private ToggleSummaryAction() {
            super(UI._("Toggle Summary"), "summary", 83, 3);
        }
    }

    private static final class ToggleDesktopAction
    extends MAction {
        @Override
        public void onAction() {
            MainWindow mainWindow;
            mainWindow.setDesktopVisible(!(mainWindow = MainWindow.getInstance()).isDesktopVisible());
        }

        private ToggleDesktopAction() {
            super(UI._("Show Widgets"), "ui/desktop", 116);
        }
    }

    private static final class ToggleDesignerAction
    extends MAction {
        @Override
        public void onAction() {
            MainWindow.showSidebar(Sidebar.Tab.DESIGNER, true);
        }

        private ToggleDesignerAction() {
            super(UI._("Toggle Designer"), "ui/wizard", 115);
        }
    }

    private static final class ShowHideSidebarAction
    extends MAction {
        @Override
        public Component getHighlightedComponent() {
            return Sidebar.getInstance();
        }

        @Override
        public void onAction() {
            MainWindow.getInstance().mainSplitPane.toggleSidebar();
        }

        private ShowHideSidebarAction() {
            super(UI._("Sidebar"), null, 120);
        }
    }

    private static final class ShowHidePropertiesBarAction
    extends MAction {
        @Override
        public Component getHighlightedComponent() {
            return PropertiesBar.isInstance() ? PropertiesBar.getInstance() : null;
        }

        @Override
        public void onAction() {
            this.setInstalled(this.isSelected());
        }

        private ShowHidePropertiesBarAction() {
            super(UI._("Properties Bar"));
        }

        private void setInstalled(boolean bl) {
            MainWindow mainWindow = MainWindow.getInstance();
            this.setSelected(bl);
            if (bl) {
                PropertiesBar propertiesBar = PropertiesBar.getInstance();
                propertiesBar.setMetaInfo(Tabs.getInstance().getCurrentMetaInfo());
                mainWindow.installTabBar(propertiesBar);
                propertiesBar.showOrHide(true);
            } else {
                mainWindow.installTabBar(null);
                if (PropertiesBar.isInstance()) {
                    PropertiesBar.getInstance().setVisible(false);
                }
            }
        }
    }

    private static final class ShowHideMainToolBarAction
    extends MAction {
        @Override
        public Component getHighlightedComponent() {
            return MainWindow.getInstance().mainToolBar;
        }

        @Override
        public void onAction() {
            MToolBar mToolBar = MainWindow.getInstance().mainToolBar;
            mToolBar.setVisible(this.isSelected());
        }

        private ShowHideMainToolBarAction() {
            super(UI._("Main Tool Bar"));
        }
    }

    private static final class ShowHideLocationBarAction
    extends MAction {
        @Override
        public Component getHighlightedComponent() {
            return LocationBar.getInstance();
        }

        @Override
        public void onAction() {
            Vars.treeLocationBarVisible.set(this.isSelected());
        }

        private ShowHideLocationBarAction() {
            super(UI._("Location Bar"));
        }
    }

    private static final class QuickSaveAction
    extends MAction {
        @Override
        public void onAction() {
            MainWindow.getInstance().saveSession(1);
        }

        private QuickSaveAction() {
            super(UI._("Save all the modified files now"), 83, QuickSaveAction.getMenuMask());
        }
    }

    private static final class PrintAction
    extends MApplication.PrintAction {
        @Override
        public void onAction() {
            Editor editor = (Editor)Tabs.getInstance().getSelectedTab();
            if (editor instanceof EditorPrint) {
                Flags flags = new Flags(editor.getPrintingCapabilities());
                if (flags.isSet(128L)) {
                    PrintDialog.printDocument(editor, new Flags(0L));
                } else {
                    PrintDialog printDialog = new PrintDialog((Window)MainWindow.getInstance(), editor);
                    printDialog.exec();
                }
            }
        }

        private PrintAction() {
            this.setEnabled(false);
            this.setHTMLHelp(UI._("Prints the content of the active document."));
        }
    }

    private static final class HelpAction
    extends MAction {
        @Override
        public void onAction() {
            org.makagiga.tools.Help.show();
        }

        private HelpAction() {
            super(MActionInfo.HELP);
        }
    }

    private static final class FindNextAction
    extends MApplication.FindNextAction {
        @Override
        public void onAction() {
            EditorQuickFind editorQuickFind = EditorQuickFind.getInstance();
            MainWindow.getInstance().installTabBar(editorQuickFind);
            editorQuickFind.findNext();
        }

        private FindNextAction() {
            this.setHTMLHelp(UI._("Search for the next matching text in the active document."));
        }
    }

    private static final class FindAction
    extends MAction {
        @Override
        public void onAction() {
            EditorQuickFind editorQuickFind = EditorQuickFind.getInstance();
            MainWindow.getInstance().installTabBar(editorQuickFind);
            editorQuickFind.setActive(true);
        }

        private FindAction() {
            super(MActionInfo.FIND);
            this.setHTMLHelp(UI._("Search for a text in the active document."));
        }
    }

    private static final class EmailAction
    extends MAction {
        @Override
        public void onAction() {
            if (!((Boolean)Vars.actionSendFile.get()).booleanValue()) {
                return;
            }
            MetaInfo metaInfo = Tabs.getInstance().getCurrentMetaInfo();
            if (metaInfo != null && metaInfo.isFile()) {
                OS.email(null, metaInfo.toString(), metaInfo.getFile());
            }
        }

        private EmailAction() {
            super(UI._("Email File..."));
        }
    }

    private static final class DocumentHelpAction
    extends MAction {
        @Override
        public void onAction() {
            HelpContext helpContext;
            Editor editor = (Editor)Tabs.getInstance().getSelectedTab();
            if (editor instanceof DocumentHelp && (helpContext = ((DocumentHelp)DocumentHelp.class.cast(editor)).showHelp()) != null) {
                Help.show(editor, helpContext);
            }
        }

        private DocumentHelpAction() {
            super(MActionInfo.HELP.getText());
        }

        private void updateProperties(Editor<?> editor) {
            this.setEnabled(editor instanceof DocumentHelp);
            PluginInfo pluginInfo = editor.getMetaInfo().getPluginInfo();
            String string = pluginInfo != null ? pluginInfo.toString() : editor.getMetaInfo().toString();
            this.setName(UI._("Help: {0}", TK.rightSqueeze(string, 20)));
        }
    }

    private static final class ConfigureAction
    extends MApplication.SettingsAction {
        @Override
        public void onAction() {
            MainWindow mainWindow = MainWindow.getInstance();
            MSettingsDialog<MSettingsPage> mSettingsDialog = new MSettingsDialog<MSettingsPage>((Window)mainWindow, "configure", 1);
            mSettingsDialog.setAutoResizeWindow(true);
            mSettingsDialog.addPage(new GeneralSettings());
            mSettingsDialog.addPage(new LookAndFeelSettings());
            PluginManager.addPluginOptions(mSettingsDialog);
            mSettingsDialog.addAdvancedPage(ProxySettings.class);
            mSettingsDialog.addAdvancedPage(GeneralSettings.Advanced.class);
            mSettingsDialog.addAdvancedPage(TreeSettings.Advanced.class);
            mSettingsDialog.addAdvancedPage(LookAndFeelSettings.Advanced.class);
            if (mSettingsDialog.exec()) {
                mainWindow.repaint();
            }
        }

        private ConfigureAction() {
            this.setHTMLHelp(UI._("Application settings (look and feel, browser, etc)."));
        }
    }

    public static final class ImportMenu
    extends MMenu {
        public ImportMenu() {
            super(MActionInfo.IMPORT.getText());
            this.setToolTipText(UI.makeHTML(UI._("Imports a selected files into the <b>Tree</b>.<br>Tip: You can use drag and drop to import/export files.")));
            this.addMenuListener(new MMenuAdapter(true){

                @Override
                protected void onSelect(MMenu mMenu) {
                    ((ImportMenu)ImportMenu.class.cast(mMenu)).doInit();
                }
            });
            if (((Boolean)Vars.treeReadOnly.get()).booleanValue()) {
                this.setEnabled(false);
            }
        }

        private void doInit() {
            this.removeAll();
            this.setSplitMenu(true);
            MetaInfo metaInfo = Tree.getInstance().getCurrentFolder(false);
            AbstractFS abstractFS = metaInfo.getFS();
            if (abstractFS instanceof TreeFS) {
                if (metaInfo.canModify()) {
                    this.addTitle(UI._("Import into \"{0}\"", metaInfo));
                    for (PluginInfo object : PluginType.EDITOR.get()) {
                        EditorPlugin editorPlugin = (EditorPlugin)object.getPluggable();
                        List<EditorPlugin.FileType> list = editorPlugin.getImportTypes();
                        if (list.isEmpty()) continue;
                        ImportExport.ImportAction importAction = new ImportExport.ImportAction(editorPlugin, editorPlugin.getDocumentDisplayName(), list);
                        importAction.setSmallIcon(object.getSmallIcon());
                        this.add(importAction);
                    }
                    this.addSeparator();
                    this.add(new MAction(UI._("Import from {0}", "Incollector 1.x")){

                        @Override
                        public void onAction() {
                            ImportExport.importIncollector();
                        }
                    });
                } else {
                    this.addTitle(UI._("This folder is locked (read only): {0}", metaInfo), "ui/error");
                }
            }
            for (AbstractFS abstractFS2 : Tree.getInstance().getFileSystems().values()) {
                if (!(abstractFS2 instanceof PluginMenu)) continue;
                ((PluginMenu)PluginMenu.class.cast(abstractFS2)).updateMenu("IMPORT_MENU", this);
            }
            PluginManager.updateMenu(this, "IMPORT_MENU", false);
        }
    }
}

