/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.security.BasicPermission;
import java.util.Map;
import java.util.TreeMap;
import org.makagiga.commons.CommandOptions;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MHTMLViewer;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public final class Args {
    private static CommandOptions commandOptions = new CommandOptions();

    public static synchronized void add(String string, String string2) {
        Args.checkPermission("add");
        if (string != null) {
            commandOptions.registerOption(null, string, string2);
        }
    }

    public static synchronized boolean check() {
        if (Args.isSet("help")) {
            if (OS.isHeadless()) {
                Args.helpCLI();
            } else {
                Args.helpGUI();
            }
            return true;
        }
        if (Args.isSet("version")) {
            Args.versionGUI();
            return true;
        }
        return false;
    }

    public static int count() {
        return commandOptions.size();
    }

    public static String get(int n) {
        return commandOptions.getRaw(n);
    }

    public static Map<String, String> getAdded() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (CommandOptions.Option option : commandOptions.getRegisteredOptions()) {
            if (option.getLongName() != null) {
                treeMap.put(option.getLongName(), option.getDescription());
            }
            if (option.getShortName() == null) continue;
            treeMap.put(option.getShortName(), option.getDescription());
        }
        return treeMap;
    }

    public static String getOption(String string) {
        if (TK.isEmpty(string)) {
            return null;
        }
        return commandOptions.getOption(string);
    }

    public static synchronized void helpCLI() {
        System.out.println();
        System.out.printf("%s\n", MApplication.getTitle());
        System.out.printf("%s\n", MApplication.getCopyright());
        System.out.println();
        System.out.println(commandOptions.toString());
        System.out.println();
    }

    public static synchronized void helpGUI() {
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.addHeader(1, HTMLBuilder.escape(MApplication.getTitle()));
        hTMLBuilder.addHeader(2, HTMLBuilder.escape(MApplication.getCopyright()));
        hTMLBuilder.addHeader(2, HTMLBuilder.escape(UI._("Command line options:")));
        Map<String, String> map = Args.getAdded();
        hTMLBuilder.beginTag("table");
        String string = "font-family: Monospaced; font-weight: bold";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            hTMLBuilder.beginTag("tr");
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape("--" + entry.getKey()), "style", string);
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(entry.getValue()), new Object[0]);
            hTMLBuilder.endTag("tr");
        }
        hTMLBuilder.endTag("table");
        Args.showWindow(MActionInfo.HELP.getDialogTitle(), hTMLBuilder);
    }

    public static synchronized void init(String[] stringArray) {
        Args.checkPermission("init");
        commandOptions.set(stringArray);
        Args.add("help", UI._("Help"));
        Args.add("portable", UI._("Use this option if application is stored on a writeable and removable storage device (USB flash drive or flash card)"));
        Args.add("profile", UI._("Start with profile. Example: {0}", "--profile \"" + UI._("Profile Name") + "\""));
        Args.add("rtl", UI._("Use right-to-left layout"));
        Args.add("safe-mode", UI._("Safe mode"));
        Args.add("user-files", UI._("Directory with configuration and data files. Example: {0}", "--user-files \"/home/foo/Makagiga\""));
        Args.add("version", UI._("Show version info and exit"));
        commandOptions.setErrorMode(CommandOptions.ErrorMode.WARNING);
    }

    public static boolean isSet(String string) {
        if (TK.isEmpty(string)) {
            return false;
        }
        return commandOptions.isSet(string);
    }

    public static synchronized void versionCLI() {
        System.out.print(OS.getSummary());
    }

    public static synchronized void versionGUI() {
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.doubleTag("pre", HTMLBuilder.escape(OS.getSummary()), new Object[0]);
        Args.showWindow(UI._("Version"), hTMLBuilder);
    }

    private Args() {
    }

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(string));
        }
    }

    private static void showWindow(String string, HTMLBuilder hTMLBuilder) {
        MDialog mDialog = new MDialog(null, string, 36);
        MHTMLViewer mHTMLViewer = new MHTMLViewer();
        mHTMLViewer.setHTML(hTMLBuilder);
        mHTMLViewer.setToolTipText(string);
        mDialog.addCenter(mHTMLViewer);
        mDialog.pack();
        mDialog.exec(mHTMLViewer);
    }

    public static final class Permission
    extends BasicPermission {
        private Permission(String string) {
            super(string);
        }
    }
}

