/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import org.makagiga.commons.MLogger;

public final class Benchmark {
    private long nanoStart;
    private MLogger log;

    public Benchmark() {
        this("benchmark");
    }

    public Benchmark(String string) {
        this.log = MLogger.get(string);
    }

    public void begin() {
        this.nanoStart = System.nanoTime();
    }

    public static Benchmark begin(String string) {
        Benchmark benchmark = new Benchmark(string);
        benchmark.begin();
        return benchmark;
    }

    public long elapsedMS() {
        return this.elapsedNano() / 1000000L;
    }

    public long elapsedNano() {
        return Math.abs(System.nanoTime() - this.nanoStart);
    }

    public long elapsedSeconds() {
        return this.elapsedMS() / 1000L;
    }

    public long end() {
        long l = this.elapsedNano();
        this.log.info(this.formatNano(l));
        return l / 1000000L;
    }

    public long end(String string, Object ... objectArray) {
        long l = this.elapsedNano();
        this.log.infoFormat(this.formatNano(l) + ": " + string, objectArray);
        return l / 1000000L;
    }

    private String formatNano(long l) {
        return String.format("%1.2f ms", Float.valueOf((float)l / 1000000.0f));
    }
}

