/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import org.makagiga.commons.FS;

public final class Checksum {
    public static Result get(String string, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
        FS.copyStream(digestInputStream, null);
        Result result = new Result();
        Result.access$002(result, messageDigest.digest());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result get(String string, File file) throws IOException, NoSuchAlgorithmException {
        Result result;
        FS.BufferedFileInput bufferedFileInput = null;
        try {
            bufferedFileInput = new FS.BufferedFileInput(file);
            result = Checksum.get(string, bufferedFileInput);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileInput);
            throw throwable;
        }
        FS.close(bufferedFileInput);
        return result;
    }

    public static String toString(byte[] byArray) {
        Formatter formatter = new Formatter(Locale.US);
        return formatter.format("%0" + byArray.length * 2 + "x", new BigInteger(1, byArray)).toString();
    }

    private Checksum() {
    }

    public static final class Result {
        private byte[] digest;
        private String string;

        public byte[] getDigest() {
            return Arrays.copyOf(this.digest, this.digest.length);
        }

        public String toString() {
            if (this.string == null) {
                this.string = Checksum.toString(this.digest);
            }
            return this.string;
        }

        static /* synthetic */ byte[] access$002(Result result, byte[] byArray) {
            result.digest = byArray;
            return byArray;
        }
    }
}

