/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.Action;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MObject;
import org.makagiga.commons.TK;

public class HistoryManager<T>
implements Iterable<T>,
Serializable {
    public static final int NO_LIMIT = -1;
    private boolean modified;
    private int current;
    private int limit = 1000;
    private final LinkedList<T> list = new LinkedList();

    public HistoryManager() {
        this.clear();
    }

    public synchronized boolean add(T t) {
        TK.checkNull(t);
        if (!this.isEmpty() && MObject.safeEquals(this.list.get(this.current), t)) {
            return false;
        }
        if (this.current == this.list.size() - 1) {
            this.list.add(t);
            this.current = this.list.size() - 1;
        } else if (this.isEmpty()) {
            this.list.add(t);
            this.current = 0;
        } else {
            this.list.add(++this.current, t);
        }
        this.modified = true;
        if (this.limit != -1 && this.list.size() > this.limit) {
            this.list.removeFirst();
            if (this.current > this.list.size() - 1) {
                this.current = this.list.size() - 1;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T back() {
        if (!this.canBack()) {
            throw new NoSuchElementException();
        }
        HistoryManager historyManager = this;
        synchronized (historyManager) {
            --this.current;
            return this.list.get(this.current);
        }
    }

    public synchronized boolean canBack() {
        return !this.isEmpty() && this.current > 0;
    }

    public synchronized boolean canForward() {
        return !this.isEmpty() && this.current < this.list.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear() {
        if (this.isEmpty()) {
            return false;
        }
        HistoryManager historyManager = this;
        synchronized (historyManager) {
            this.list.clear();
            this.current = 0;
            this.modified = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T forward() {
        if (!this.canForward()) {
            throw new NoSuchElementException();
        }
        HistoryManager historyManager = this;
        synchronized (historyManager) {
            ++this.current;
            return this.list.get(this.current);
        }
    }

    public synchronized T getCurrent() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.list.get(this.current);
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimit(int n) {
        if (n != -1 && n < 1) {
            throw new IllegalArgumentException("History limit cannot be less than 1 (NO_LIMIT - unlimited): " + n);
        }
        HistoryManager historyManager = this;
        synchronized (historyManager) {
            this.limit = n;
            if (this.limit > 0) {
                while (this.list.size() > this.limit) {
                    this.list.removeLast();
                }
                if (this.current > this.list.size() - 1) {
                    this.current = this.list.size() - 1;
                }
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.list.isEmpty();
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public synchronized void read(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            this.list.add(string);
        }
        this.current = Math.max(0, this.list.size() - 1);
    }

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized List<T> toList() {
        return Collections.unmodifiableList(this.list);
    }

    public void updateActions(Action action, Action action2) {
        action.setEnabled(this.canBack());
        action2.setEnabled(this.canForward());
    }

    @Override
    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    public static abstract class HistoryAction<T>
    extends MDataAction.Weak<HistoryManager<T>> {
        protected HistoryAction(MActionInfo mActionInfo, HistoryManager<T> historyManager) {
            super(historyManager, mActionInfo);
        }

        protected abstract void onAction(T var1);
    }

    public static abstract class ForwardAction<T>
    extends HistoryAction<T> {
        public ForwardAction(HistoryManager<T> historyManager) {
            super(MActionInfo.FORWARD, historyManager);
            this.setEnabled(historyManager.canForward());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onAction() {
            HistoryManager historyManager = (HistoryManager)this.get();
            if (historyManager.canForward()) {
                try {
                    this.onAction(historyManager.forward());
                }
                finally {
                    this.setEnabled(historyManager.canForward());
                }
            }
        }
    }

    public static abstract class BackAction<T>
    extends HistoryAction<T> {
        public BackAction(HistoryManager<T> historyManager) {
            super(MActionInfo.BACK, historyManager);
            this.setEnabled(historyManager.canBack());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onAction() {
            HistoryManager historyManager = (HistoryManager)this.get();
            if (historyManager.canBack()) {
                try {
                    this.onAction(historyManager.back());
                }
                finally {
                    this.setEnabled(historyManager.canBack());
                }
            }
        }
    }
}

