/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.TK;

public class Item<T>
implements MIcon.Name,
MRenderer.Renderable,
Serializable {
    private static final long serialVersionUID = -6126164908015747257L;
    protected Icon icon;
    protected String text;
    protected transient T value;
    static Renderer<Item<?>> sharedRenderer;

    public Item() {
    }

    public Item(T t) {
        this.value = t;
    }

    public Item(T t, String string) {
        this.value = t;
        this.text = string;
    }

    public static synchronized ListCellRenderer createListCellRenderer() {
        if (sharedRenderer == null) {
            sharedRenderer = new Renderer();
        }
        return sharedRenderer;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public String getIconName() {
        return MIcon.getName(this.icon);
    }

    @Override
    public void setIconName(String string) {
        this.icon = MIcon.stock(string);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T t) {
        this.value = t;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public String toString() {
        String string = this.getText();
        if (string != null) {
            return string;
        }
        T t = this.getValue();
        return t != null ? t.toString() : "";
    }

    @Override
    public void setupRenderer(MRenderer<?> mRenderer) {
        mRenderer.setIcon(this.getIcon());
        mRenderer.setText(this.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = TK.deserialize(objectInputStream, "value");
        if (object != null) {
            this.value = object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        TK.serialize(objectOutputStream, "value", this.value);
    }

    public static class Renderer<I extends Item<?>>
    extends MRenderer<I> {
        public Renderer() {
        }

        public Renderer(int n) {
            super(n);
        }

        @Override
        protected void onRender(I i) {
            super.onRender(i);
        }
    }
}

