/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.FileLock;
import java.security.BasicPermission;
import java.text.ParseException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import org.makagiga.commons.Args;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.ConfigEntry;
import org.makagiga.commons.FS;
import org.makagiga.commons.FileCache;
import org.makagiga.commons.IntegerProperty;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.LogFile;
import org.makagiga.commons.MAboutDialog;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MAuthenticator;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MGraphics2D;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MNotification;
import org.makagiga.commons.MSplashScreen;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MTip;
import org.makagiga.commons.MainView;
import org.makagiga.commons.Net;
import org.makagiga.commons.OS;
import org.makagiga.commons.StringProperty;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.VersionProperty;
import org.makagiga.commons.proxy.ProxyManager;

public abstract class MApplication {
    @ConfigEntry(value="Confirm.exit")
    public static final BooleanProperty confirmExit = new BooleanProperty();
    @ConfigEntry(value="Console.fontSize")
    public static final IntegerProperty consoleFontSize = new IntegerProperty(12);
    @ConfigEntry(value="Console.openInTab")
    public static final BooleanProperty consoleOpenInTab = new BooleanProperty(true);
    @ConfigEntry(value="Console.prompt")
    public static final StringProperty consolePrompt = new StringProperty(">:");
    @Deprecated
    public static final BooleanProperty consoleWrapLines = new BooleanProperty(true);
    @Deprecated
    public static final BooleanProperty modsEnabled = new BooleanProperty(true);
    private static volatile boolean callOnShutDown = true;
    private static boolean firstRun;
    private static boolean initialized;
    private static boolean isShutDown;
    private static boolean safeMode;
    private static Class<? extends MApplication> resourcesClass;
    private static Color _lightBrandColor;
    private static EventListenerList listeners;
    private static FileLock fileLock;
    private static Icon icon;
    private static Image logo;
    private static LogFile _logFile;
    private static MAction quitAction;
    private static MApplication _instance;
    private static ResourceBundle resources;
    private static Set<Init> initSet;
    private static String _bugs;
    private static String _buildInfo;
    private static String _copyright;
    private static String _description;
    private static String _fileVersion;
    private static String _fullName;
    private static String _fullVersion;
    private static String _homePage;
    private static String _internalName;
    private static String lockPath;
    private static String _releaseNotes;
    private static VersionProperty _internalVersion;
    static boolean forceRTL;

    public static void addConfigEntries(Class<?> clazz) {
        MApplication.checkPermission("addConfigEntries");
        Config.registerDefaultClass(clazz);
    }

    public static synchronized void addShutDownListener(ShutDownListener shutDownListener) {
        listeners.add(ShutDownListener.class, shutDownListener);
    }

    public static synchronized void removeShutDownListener(ShutDownListener shutDownListener) {
        listeners.remove(ShutDownListener.class, shutDownListener);
    }

    public static boolean canLaunchAnotherInstance() {
        if (!MApplication.isLocked()) {
            return true;
        }
        try {
            return UI.invokeAndWait(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    UIManager.put("swing.boldMetal", false);
                    return MMessage.customConfirm(null, MApplication.getIcon(), MActionInfo.CONTINUE, MActionInfo.QUIT, UI.makeHTML(UI._("It seems that {0} is already running", MApplication.getTitle())));
                }
            });
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return true;
        }
    }

    public static boolean checkOneInstance() {
        if (!MApplication.isLocked()) {
            return true;
        }
        try {
            return UI.invokeAndWait(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    UIManager.put("swing.boldMetal", false);
                    MMessage.info(null, UI.makeHTML(UI._("It seems that {0} is already running", MApplication.getTitle())));
                    return false;
                }
            });
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return true;
        }
    }

    public static String getBugs() {
        return _bugs == null ? MApplication.getResourceString("Application.x.bugs", null) : _bugs;
    }

    public static String getBuildInfo() {
        return _buildInfo == null ? MApplication.getResourceString("Application.x.buildInfo", null) : _buildInfo;
    }

    public static String getCopyright() {
        return _copyright == null ? MApplication.getResourceString("Application.vendor", null) : _copyright;
    }

    public static String getDescription() {
        return _description == null ? MApplication.getResourceString("Application.description", null) : _description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDescription(String string) {
        MApplication.checkPermission("setDescription");
        Class<MApplication> clazz = MApplication.class;
        synchronized (MApplication.class) {
            _description = string;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String getFileVersion() {
        return _fileVersion == null ? MApplication.getResourceString("Application.x.fileVersion", null) : _fileVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFileVersion(String string) {
        MApplication.checkPermission("setFileVersion");
        Class<MApplication> clazz = MApplication.class;
        synchronized (MApplication.class) {
            _fileVersion = string;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String getFullName() {
        return _fullName == null ? MApplication.getResourceString("Application.name", MApplication.getInternalName()) : _fullName;
    }

    public static String getFullVersion() {
        return _fullVersion == null ? MApplication.getResourceString("Application.version", null) : _fullVersion;
    }

    public static String getHomePage() {
        return _homePage == null ? MApplication.getResourceString("Application.homepage", null) : _homePage;
    }

    public static synchronized Color getLightBrandColor() {
        if (_lightBrandColor == null) {
            String string = MApplication.getResourceString("Application.x.lightBrandColor", null);
            if (TK.isEmpty(string)) {
                _lightBrandColor = MColor.SKY_BLUE;
            } else {
                try {
                    _lightBrandColor = ColorProperty.parseColor(string);
                }
                catch (ParseException parseException) {
                    _lightBrandColor = MColor.SKY_BLUE;
                    MLogger.exception(parseException);
                }
            }
        }
        return _lightBrandColor;
    }

    public static synchronized String getLockPath() {
        return lockPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFile getLogFile() {
        MApplication.checkPermission("getLogFile");
        Class<MApplication> clazz = MApplication.class;
        synchronized (MApplication.class) {
            if (_logFile == null) {
                _logFile = new LogFile(FS.makeConfigFile("console.log"));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _logFile;
        }
    }

    public static synchronized Icon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIcon(Icon icon) {
        MApplication.checkPermission("setIcon");
        Class<MApplication> clazz = MApplication.class;
        synchronized (MApplication.class) {
            MApplication.icon = icon;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String getInternalName() {
        if (TK.isEmpty(_internalName)) {
            throw new IllegalStateException("\"internal name\" is not set");
        }
        return _internalName;
    }

    public static synchronized VersionProperty getInternalVersion() {
        String string;
        if (_internalVersion.equalsValue(0) && (string = MApplication.getResourceString("Application.x.internalVersion", null)) != null) {
            if (string.contains(".")) {
                try {
                    _internalVersion.parse(string);
                }
                catch (ParseException parseException) {
                    MLogger.exception(parseException);
                }
            } else {
                _internalVersion.set(Integer.parseInt(string, 16));
            }
        }
        return _internalVersion;
    }

    public static synchronized Image getLogo() {
        return logo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogo(Image image) {
        MApplication.checkPermission("setLogo");
        Class<MApplication> clazz = MApplication.class;
        synchronized (MApplication.class) {
            logo = image;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Deprecated
    public static MMainWindow getMainWindow() {
        Window window = MainView.getWindow();
        return window instanceof MMainWindow ? (MMainWindow)window : null;
    }

    public static synchronized MAction getQuitAction() {
        if (quitAction == null) {
            quitAction = new QuitAction();
        }
        return quitAction;
    }

    @Deprecated
    public static String getReleaseNotes() {
        return _releaseNotes;
    }

    @Deprecated
    public static synchronized String getResourcesPath() {
        if (resourcesClass == null) {
            return "/resources";
        }
        return resourcesClass.getPackage().getName().replace('.', '/') + "/resources";
    }

    public static synchronized String getResourceString(String string, String string2) {
        if (resources == null) {
            MLogger.warning("core", "No Application resource for \"%s\" key", string);
            return string2;
        }
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            MLogger.exception(missingResourceException);
            return string2;
        }
    }

    public static String getRestartMessage() {
        return UI._("OK. Restart application to apply changes.");
    }

    @Deprecated
    public static MStatusBar getStatusBar() {
        MMainWindow mMainWindow = MApplication.getMainWindow();
        return mMainWindow == null ? null : mMainWindow.getStatusBar();
    }

    public static synchronized String getTitle() {
        String string = MApplication.getFullVersion();
        if (string == null) {
            return MApplication.getFullName();
        }
        return MApplication.getFullName() + " " + string;
    }

    public static boolean isFirstRun() {
        return firstRun;
    }

    public static synchronized boolean isInitialized() {
        return initialized;
    }

    public static synchronized boolean isLocked() {
        lockPath = FS.makeConfigPath(MApplication.getInternalName() + ".lock");
        try {
            fileLock = new FileOutputStream(lockPath).getChannel().tryLock();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return fileLock == null;
    }

    public static synchronized boolean isSafeMode() {
        return safeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void setSafeMode(boolean bl) {
        MApplication.checkPermission("setSafeMode");
        Class<MApplication> clazz = MApplication.class;
        synchronized (MApplication.class) {
            safeMode = bl;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized boolean isShutDown() {
        return isShutDown;
    }

    public static void launch(Class<? extends MApplication> clazz) {
        MApplication.checkPermission("launch");
        try {
            clazz.newInstance();
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
    }

    public static void quit() {
        MApplication.checkPermission("quit");
        if (!((Boolean)Kiosk.actionQuit.get()).booleanValue()) {
            MLogger.info("core", "\"Quit\" action is disabled");
            return;
        }
        if (_instance != null) {
            if (_instance.onQuit()) {
                _instance.shutDown();
            }
        } else {
            System.exit(0);
        }
    }

    protected MApplication() {
        _instance = this;
        MLogger.info("core", MApplication.getTitle());
        if (initSet != null && initSet.contains((Object)Init.TIPS)) {
            MTip.load();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n;
                Serializable serializable;
                if (Args.check()) {
                    return;
                }
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.setDismissDelay(8000);
                MApplication.this.startup();
                initialized = true;
                MSplashScreen.close();
                MMainWindow mMainWindow = MApplication.getMainWindow();
                if (mMainWindow != null && MLogger.isDeveloper() && (serializable = mMainWindow.getJMenuBar()) != null) {
                    n = -1;
                    int n2 = ((Container)serializable).getComponentCount();
                    for (int i = 0; i < n2; ++i) {
                        if (!(((Container)serializable).getComponent(i) instanceof Box.Filler)) continue;
                        n = i;
                        break;
                    }
                    ((Container)serializable).add((Component)MLogger.createMemoryPanel(), n);
                }
                serializable = Config.getDefault();
                n = 0;
                if (MApplication.isSafeMode()) {
                    ((Config)serializable).write("safeMode", false);
                    n = 1;
                }
                if (!OS.isSupported() && ((Config)serializable).read("showOSWarning." + OS.getName(), true)) {
                    ((Config)serializable).write("showOSWarning." + OS.getName(), false);
                    n = 1;
                    MNotification.showInfo(UI._("This operating system ({0}) is not fully supported", OS.getName()));
                }
                if (n != 0) {
                    ((Config)serializable).sync();
                }
                MApplication.this.installShutDownHooks();
            }
        });
    }

    protected boolean confirmQuit() {
        if (!((Boolean)confirmExit.get()).booleanValue()) {
            return true;
        }
        Component component = null;
        JComponent jComponent = null;
        MMainWindow mMainWindow = MApplication.getMainWindow();
        if (mMainWindow != null) {
            if (mMainWindow.isLocked()) {
                return true;
            }
            component = mMainWindow.getGlassPane();
            mMainWindow.clearGlassPane();
            mMainWindow.restore();
            jComponent = new MComponent(){

                @Override
                public void paintComponent(Graphics graphics) {
                    graphics.setColor(UI.TRANSPARENT_BLACK);
                    MGraphics2D.fillRect(graphics, this);
                }
            };
            component.setVisible(false);
            mMainWindow.setGlassPane(jComponent);
            jComponent.setVisible(true);
        }
        boolean bl = MMessage.simpleConfirm(mMainWindow, MActionInfo.QUIT);
        if (mMainWindow != null) {
            jComponent.setVisible(false);
            mMainWindow.setGlassPane(component);
        }
        return bl;
    }

    protected static void init(String[] stringArray, String string) {
        MApplication.init(stringArray, string, string, 0, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void init(String[] stringArray, String string, Class<? extends MApplication> clazz) {
        Class<MApplication> clazz2 = MApplication.class;
        synchronized (MApplication.class) {
            resourcesClass = clazz;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            MApplication.init(stringArray, string, null, 0, null, null, null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void init(String[] stringArray, String string, String string2, int n, String string3, String string4, String string5) {
        if (OS.isLinux() && OS.isOpenJDK()) {
            System.setProperty("sun.java2d.pmoffscreen", "false");
        }
        Object object = FS.class;
        synchronized (FS.class) {
            FS.restricted = false;
            // ** MonitorExit[var7_7] (shouldn't be in output)
            _copyright = string4;
            _fullName = string2;
            _fullVersion = string3;
            _homePage = string5;
            if ("categories".equals(string) || "internetsearch".equals(string)) {
                throw new IllegalArgumentException("Reserved internal name: " + string);
            }
            _internalName = string;
            _internalVersion = new VersionProperty(n);
            object = MApplication.class;
            synchronized (MApplication.class) {
                int n2;
                if (resourcesClass != null && resources == null) {
                    String string6 = resourcesClass.getPackage().getName() + ".resources." + resourcesClass.getSimpleName();
                    try {
                        resources = ResourceBundle.getBundle(string6);
                        String string7 = MApplication.getResourceString("Application.x.logo", null);
                        if (string7 != null && !OS.isHeadless()) {
                            MApplication.setIcon(MIcon.stock(string7));
                            MApplication.setLogo(MIcon.getImage(string7));
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        MLogger.exception(missingResourceException);
                        MLogger.warning("core", "Missing Application resources: %s", string6);
                    }
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                Args.init(stringArray);
                forceRTL = Args.isSet("rtl");
                Config.setDefaultComment("Generated by " + MApplication.getFullName() + ", do not modify!");
                object = Config.getDefault();
                MApplication.setSafeMode(Args.isSet("safe-mode"));
                if (!MApplication.isSafeMode() && !MLogger.isDeveloper()) {
                    MApplication.setSafeMode(((Config)object).read("safeMode", false));
                }
                boolean bl = firstRun = (n2 = ((Config)object).readInt("run", 1, 1)) == 1;
                if (firstRun) {
                    MLogger.info("core", "First run. Setting default values...");
                    ((Config)object).write("run", ++n2);
                    UI.buttonIcons.set(!OS.isMac() && !OS.isWindows());
                    ((Config)object).sync();
                }
                return;
            }
        }
    }

    protected static void initLookAndFeel() {
        try {
            String string = UI.getPreferredLookAndFeelClassName();
            UI.setLookAndFeel(string);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
    }

    protected static void initPlatform(Set<Init> set) {
        initSet = set;
        if (set.contains((Object)Init.USER_AGENT)) {
            Net.init();
        }
        if (set.contains((Object)Init.AUTHENTICATOR)) {
            MAuthenticator.init();
        }
        if (set.contains((Object)Init.PROXY)) {
            ProxyManager.init();
        }
    }

    protected boolean onQuit() {
        MLogger.info("core", "Quit...");
        return this.confirmQuit();
    }

    protected static void setBugs(String string) {
        _bugs = string;
    }

    protected static void setBuildInfo(String string) {
        _buildInfo = string;
    }

    @Deprecated
    protected static void setReleaseNotes(String string) {
        _releaseNotes = string;
    }

    protected abstract void startup();

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(string));
        }
    }

    private void doShutDownAndCleanUp() {
        ShutDownListener[] shutDownListenerArray;
        MLogger.info("core", "Shut down...");
        Config config = Config.getDefault();
        MMainWindow mMainWindow = MApplication.getMainWindow();
        if (mMainWindow != null) {
            mMainWindow.writeConfig(config, null);
        }
        if ((shutDownListenerArray = (ShutDownListener[])listeners.getListeners(ShutDownListener.class)).length > 0) {
            ShutDownEvent shutDownEvent = new ShutDownEvent(this);
            for (ShutDownListener shutDownListener : shutDownListenerArray) {
                shutDownListener.shutDown(shutDownEvent);
            }
        }
        config.sync();
        FileCache.shutDown();
    }

    private void installShutDownHooks() {
        if (!initialized) {
            return;
        }
        if (OS.isWindows()) {
            try {
                InvocationHandler invocationHandler = new InvocationHandler(){

                    @Override
                    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                        if ("handle".equals(method.getName()) && callOnShutDown) {
                            MApplication.this.shutDown();
                        }
                        return null;
                    }
                };
                Class<?> clazz = Class.forName("sun.misc.Signal");
                Class<?> clazz2 = Class.forName("sun.misc.SignalHandler");
                Object obj = clazz.getConstructor(String.class).newInstance("TERM");
                Method method = clazz.getMethod("handle", clazz, clazz2);
                method.invoke(null, obj, Proxy.newProxyInstance(clazz2.getClassLoader(), new Class[]{clazz2}, invocationHandler));
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                MLogger.exception(throwable);
            }
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (callOnShutDown) {
                        MApplication.this.shutDown();
                    }
                }
            });
        }
    }

    private synchronized void shutDown() {
        callOnShutDown = false;
        try {
            UI.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MApplication.this.doShutDownAndCleanUp();
                }
            });
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
        isShutDown = true;
        System.exit(0);
    }

    static {
        listeners = new EventListenerList();
    }

    public static class ZoomOutAction
    extends MAction {
        public ZoomOutAction() {
            super(UI._("Zoom Out"), "ui/zoomout", 45, ZoomOutAction.getMenuMask());
            this.setAuthorizationProperty(Kiosk.actionZoom);
        }
    }

    public static class ZoomInAction
    extends MAction {
        public ZoomInAction() {
            super(UI._("Zoom In"), "ui/zoomin", 61, ZoomInAction.getMenuMask());
            this.setAuthorizationProperty(Kiosk.actionZoom);
        }
    }

    public static class ToggleStatusBarAction
    extends MDataAction.Weak<MStatusBar> {
        public ToggleStatusBarAction(MStatusBar mStatusBar) {
            super(mStatusBar, UI._("Status Bar"));
            this.setSelected(!mStatusBar.isClosed());
            mStatusBar.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("MStatusBar.closed")) {
                        ToggleStatusBarAction.this.setSelected((Boolean)propertyChangeEvent.getNewValue() == false);
                    }
                }
            });
        }

        @Override
        public Component getHighlightedComponent() {
            return this.getStatusBar();
        }

        public MStatusBar getStatusBar() {
            return (MStatusBar)this.get();
        }

        @Override
        public void onAction() {
            MStatusBar mStatusBar = this.getStatusBar();
            if (mStatusBar != null) {
                mStatusBar.setClosed(!this.isSelected());
            }
        }
    }

    public static interface ShutDownListener
    extends EventListener {
        public void shutDown(ShutDownEvent var1);
    }

    public static final class ShutDownEvent
    extends EventObject {
        public ShutDownEvent(Object object) {
            super(object);
        }
    }

    public static class SettingsAction
    extends MAction {
        public SettingsAction() {
            super(MActionInfo.SETTINGS);
            this.setAuthorizationProperty(Kiosk.actionSettings);
        }
    }

    @Deprecated
    public static class SaveAction
    extends MAction {
        public SaveAction() {
            super(MActionInfo.SAVE);
        }
    }

    @Deprecated
    public static class QuitAction
    extends MAction {
        public QuitAction() {
            super(MActionInfo.QUIT);
            if (!((Boolean)Kiosk.actionQuit.get()).booleanValue()) {
                this.setEnabled(false);
            }
        }

        @Override
        public void onAction() {
            MApplication.quit();
        }
    }

    @Deprecated
    public static class PropertiesAction
    extends MAction {
        public PropertiesAction() {
            super(MActionInfo.PROPERTIES);
        }
    }

    public static class PrintAction
    extends MAction {
        public PrintAction() {
            super(MActionInfo.PRINT);
            this.setAuthorizationProperty(Kiosk.actionPrint);
        }
    }

    public static final class Permission
    extends BasicPermission {
        private Permission(String string) {
            super(string);
        }
    }

    @Deprecated
    public static class OpenAction
    extends MAction {
        public OpenAction() {
            super(MActionInfo.OPEN);
        }
    }

    @Deprecated
    public static class HelpAction
    extends MAction {
        public HelpAction() {
            super(MActionInfo.HELP);
        }
    }

    public static class FullScreenAction
    extends MAction {
        public FullScreenAction() {
            super(UI._("Full Screen"), "ui/fullscreen", FullScreenAction.getFullScreenKeyStroke());
            if (!((Boolean)Kiosk.actionFullScreen.get()).booleanValue()) {
                this.setEnabled(false);
            }
        }

        @Override
        public void onAction() {
            MMainWindow mMainWindow;
            if (((Boolean)Kiosk.actionFullScreen.get()).booleanValue() && (mMainWindow = MApplication.getMainWindow()) != null) {
                mMainWindow.toggleFullScreen();
            }
        }
    }

    public static class FindNextAction
    extends MAction {
        public FindNextAction() {
            super(UI._("Find Next"), "ui/findnext", FindNextAction.getFindNextKeyStroke());
        }
    }

    @Deprecated
    public static class FindAction
    extends MAction {
        public FindAction() {
            super(MActionInfo.FIND);
        }
    }

    @Deprecated
    public static class ConfigureAction
    extends MAction {
        public ConfigureAction() {
            super(MActionInfo.SETTINGS);
        }
    }

    @Deprecated
    public static class CloseAction
    extends MAction {
        public CloseAction() {
            super(MActionInfo.CLOSE);
        }
    }

    public static class AboutAction
    extends MAction {
        public AboutAction() {
            super(MApplication.getTitle());
            this.setHTMLHelp(UI._("Displays the information about this application."));
            Icon icon = MApplication.getIcon();
            if (icon instanceof MIcon) {
                icon = ((MIcon)MIcon.class.cast(icon)).scaleSmall();
            }
            if (icon != null) {
                this.setSmallIcon(icon);
            }
        }

        @Override
        public void onAction() {
            MMainWindow mMainWindow = MApplication.getMainWindow();
            if (mMainWindow == null) {
                MAboutDialog mAboutDialog = new MAboutDialog(null);
                mAboutDialog.exec();
            } else {
                mMainWindow.about();
            }
        }
    }

    public static enum Init {
        AUTHENTICATOR,
        PROXY,
        TIPS,
        USER_AGENT;

    }
}

