/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.makagiga.commons.AbstractIterator;
import org.makagiga.commons.MText;
import org.makagiga.commons.Sortable;
import org.makagiga.commons.UI;
import org.makagiga.commons.autocompletion.AutoCompletion;

public class MComboBox<I>
extends JComboBox
implements Iterable<I>,
MouseWheelListener,
MText.TextFieldExtensions,
Sortable<I>,
UI.ComponentExtensions,
UI.EventsControl,
UI.MouseWheelEventsControl {
    private boolean eventsEnabled = true;
    private boolean layingOut;
    private boolean mouseWheelEventsEnabled = true;
    private boolean wideList;

    public MComboBox() {
        this((ComboBoxModel)new DefaultComboBoxModel());
    }

    public MComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.addActionListener(new StaticHandler());
        this.addMouseWheelListener(this);
        MText.commonSetup(this.getTextField());
    }

    public void addAllItems(Collection<? extends I> collection) {
        for (I i : collection) {
            this.addItem(i);
        }
    }

    public void addAllItems(I ... IArray) {
        if (IArray.length > 0) {
            for (I i : IArray) {
                this.addItem(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    public Action getEnterPressAction() {
        return MText.getEnterPressAction(this.getTextField());
    }

    @Override
    public void setEnterPressAction(Action action) {
        MText.setEnterPressAction(this.getTextField(), action);
    }

    @Override
    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    @Override
    public void setEventsEnabled(boolean bl) {
        this.eventsEnabled = bl;
    }

    public I getItemAt(int n) {
        return (I)super.getItemAt(n);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
    }

    @Override
    public boolean getMouseWheelEventsEnabled() {
        return this.mouseWheelEventsEnabled;
    }

    @Override
    public void setMouseWheelEventsEnabled(boolean bl) {
        this.mouseWheelEventsEnabled = bl;
    }

    public I getSelectedItem() {
        return (I)super.getSelectedItem();
    }

    @Override
    public Dimension getSize() {
        Dimension dimension = super.getSize();
        if (!this.wideList) {
            return dimension;
        }
        if (!this.layingOut) {
            dimension.width = Math.max(dimension.width, this.getPreferredSize().width);
            dimension.width = Math.min(dimension.width, UI.getScreenSize().width);
        }
        return dimension;
    }

    @Override
    public String getText() {
        return this.isEditable() ? this.getTextField().getText() : null;
    }

    @Override
    public void setText(String string) {
        if (this.isEditable()) {
            MText.setText(this.getTextField(), string);
        }
    }

    public JTextField getTextField() {
        return (JTextField)this.getEditor().getEditorComponent();
    }

    public boolean isWideList() {
        return this.wideList;
    }

    public void setWideList(boolean bl) {
        this.wideList = bl;
    }

    @Override
    public Iterator<I> iterator() {
        return new AbstractIterator<I>(){

            @Override
            public I getObjectAt(int n) {
                return MComboBox.this.getItemAt(n);
            }

            @Override
            public int getObjectCount() {
                return MComboBox.this.getItemCount();
            }
        };
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!this.mouseWheelEventsEnabled) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        int n = this.getItemCount();
        if (n < 2) {
            return;
        }
        int n2 = this.getSelectedIndex();
        if (n2 == -1) {
            n2 = 0;
        }
        if (mouseWheelEvent.getWheelRotation() < 0) {
            if (n2 > 0) {
                this.setSelectedIndex(n2 - 1);
            }
        } else if (n2 < n - 1) {
            this.setSelectedIndex(n2 + 1);
        }
        mouseWheelEvent.consume();
    }

    @Override
    public void setMaximumRowCount(int n) {
        super.setMaximumRowCount(n == -1 ? this.getItemCount() : n);
    }

    @Override
    public void sort() {
        this.sort((Comparator<I>)null);
    }

    @Override
    public void sort(Comparator<I> comparator) {
        ComboBoxModel comboBoxModel = this.getModel();
        if (comboBoxModel == null || comboBoxModel.getClass() != DefaultComboBoxModel.class) {
            throw new UnsupportedOperationException("\"DefaultComboBoxModel\" expected");
        }
        int n = comboBoxModel.getSize();
        if (n < 2) {
            return;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = comboBoxModel.getElementAt(i);
        }
        Arrays.sort(objectArray, comparator);
        this.setModel(new DefaultComboBoxModel<Object>(objectArray));
    }

    @Override
    public void updateUI() {
        if (UI.isSubstance()) {
            this.putClientProperty("lafwidgets.comboboxNoAutoCompletion", true);
        }
        super.updateUI();
    }

    @Override
    @Deprecated
    public void clear() {
        this.setText(null);
    }

    @Override
    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    @Override
    public void makeDefault() {
        if (this.isEditable()) {
            MText.makeDefault(this.getTextField());
        } else {
            this.requestFocusInWindow();
        }
    }

    @Override
    public AutoCompletion getAutoCompletion() {
        return MText.getAutoCompletion(this.getTextField());
    }

    @Override
    public void saveAutoCompletion() {
        MText.saveAutoCompletion(this.getTextField());
    }

    @Override
    public void setAutoCompletion(String string) {
        MText.installAutoCompletion(this.getTextField(), string);
    }

    protected void onSelect() {
    }

    private static final class StaticHandler
    implements ActionListener {
        private StaticHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MComboBox mComboBox = (MComboBox)actionEvent.getSource();
            if (mComboBox.eventsEnabled) {
                mComboBox.onSelect();
            }
        }
    }
}

