/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Font;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MFontChooser;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.ValueListener;
import org.makagiga.commons.swing.ValueChooser;

public class MFontButton
extends MButton
implements ValueChooser<Font> {
    public static final String SELECTED_FONT_PROPERTY = "selectedFont";
    private Font selectedFont;
    private String textLabel;

    public MFontButton() {
        this((String)null, (Font)null);
    }

    public MFontButton(Font font) {
        this(null, font);
    }

    public MFontButton(String string, Font font) {
        this.textLabel = string;
        if (((Boolean)UI.buttonIcons.get()).booleanValue()) {
            this.setIcon(MIcon.medium("ui/font"));
        }
        this.setSelectedFont(font);
        this.setToolTipText(UI._("Select a Font"));
    }

    @Override
    public void addValueListener(ValueListener<Font> valueListener) {
        this.listenerList.add(ValueListener.class, valueListener);
    }

    @Override
    public ValueListener<Font>[] getValueListeners() {
        return (ValueListener[])this.listenerList.getListeners(ValueListener.class);
    }

    @Override
    public void removeValueListener(ValueListener<Font> valueListener) {
        this.listenerList.remove(ValueListener.class, valueListener);
    }

    public String getTextLabel() {
        return this.textLabel;
    }

    public void setTextLabel(String string) {
        if (TK.isChange(this.textLabel, string)) {
            this.textLabel = string;
            this.updateFontText();
        }
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font font) {
        Font font2;
        Font font3 = font2 = font == null ? this.getFont() : font;
        if (TK.isChange(this.selectedFont, font2)) {
            Font font4 = this.selectedFont;
            this.selectedFont = font2;
            this.firePropertyChange(SELECTED_FONT_PROPERTY, font4, font2);
            this.firePropertyChange("value", font4, font2);
            this.updateFontText();
        }
    }

    @Override
    public Font getValue() {
        return this.getSelectedFont();
    }

    @Override
    public void setValue(Font font) {
        this.setSelectedFont(font);
    }

    protected void fireValueChanged(Font font, Font font2) {
        TK.fireValueChanged(this, this.getValueListeners(), font, font2);
    }

    @Override
    protected final void onClick() {
        Font font = this.getSelectedFont();
        Font font2 = MFontChooser.getFont(this.getWindowAncestor(), font);
        if (font2 != null) {
            this.setSelectedFont(font2);
            this.fireValueChanged(font, this.getSelectedFont());
        }
    }

    private void updateFontText() {
        String string = this.textLabel == null ? UI._("Select a Font...") : this.textLabel;
        this.setText(string + " [" + this.selectedFont.getName() + " " + this.selectedFont.getSize() + "]");
        this.setFont(this.getFont().deriveFont(this.selectedFont.getStyle()));
    }
}

