/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import com.jhlabs.image.ColorizeFilter;
import com.jhlabs.image.GrayscaleFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.makagiga.commons.Base64;
import org.makagiga.commons.Ico;
import org.makagiga.commons.Immutable;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.fx.Reflection;
import org.makagiga.commons.icons.DefaultIconLoader;

public class MIcon
extends ImageIcon
implements Immutable<MIcon> {
    @Deprecated
    public static final int DEFAULT_SIZE = MIcon.getDefaultSize();
    public static final int MAX_SIZE = 64;
    public static final int MIN_SIZE = 16;
    @Deprecated
    public static final MIcon MISC = MIcon.stock("ui/misc").freeze();
    private boolean immutable;
    private boolean stockLoadDone;
    private Image overlay;
    private int stockSize;
    private String stockName;

    public MIcon() {
    }

    public MIcon(byte[] byArray) {
        super(byArray);
    }

    public MIcon(File file) {
        this.loadImage(file.getPath());
    }

    public MIcon(Image image) {
        super(image);
    }

    public MIcon(URL uRL) {
        this.loadImage(uRL);
    }

    public static MIcon fromDataURI(String string) throws IOException {
        try {
            String string2;
            List<String> list;
            String string3;
            int n;
            URI uRI;
            String string4;
            if (string != null) {
                string = string.trim();
            }
            if ("data".equals(string4 = (uRI = new URI(string)).getScheme()) && (n = (string3 = string.substring("data:".length())).indexOf(44)) != -1 && ((list = TK.fastSplit(string2 = string3.substring(0, n), ';')).contains("image/vnd.microsoft.icon") || list.contains("image/x-icon") || list.contains("image/png"))) {
                Object object;
                byte[] byArray;
                String string5 = string3.substring(n + 1);
                if (list.contains("base64")) {
                    byArray = Base64.decode(string5);
                } else {
                    object = new ByteArrayOutputStream(1024);
                    boolean bl = false;
                    StringBuilder stringBuilder = new StringBuilder(2);
                    for (int i = 0; i < string5.length(); ++i) {
                        char c = string5.charAt(i);
                        if (c == '%') {
                            bl = true;
                        } else if (bl) {
                            stringBuilder.append(c);
                        } else {
                            ((ByteArrayOutputStream)object).write(c);
                        }
                        if (stringBuilder.length() != 2) continue;
                        ((ByteArrayOutputStream)object).write(Integer.parseInt(stringBuilder.toString(), 16));
                        stringBuilder.setLength(0);
                        bl = false;
                    }
                    byArray = ((ByteArrayOutputStream)object).toByteArray();
                }
                if (byArray != null) {
                    if (byArray.length > 4 && byArray[0] == -119 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71) {
                        return new MIcon(byArray);
                    }
                    if (byArray.length > 3 && byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70) {
                        return new MIcon(byArray);
                    }
                    object = new Ico(new ByteArrayInputStream(byArray));
                    if (((Ico)object).getNumImages() > 0) {
                        return new MIcon(((Ico)object).getImage(0));
                    }
                }
            }
            throw new IOException("Unsupported icon URI \"" + string + "\"");
        }
        catch (Ico.BadIcoResException badIcoResException) {
            throw new IOException(badIcoResException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
    }

    @Deprecated
    public static MIcon fromFileURI(String string) {
        return MIcon.fromFileURI(string, MIcon.getUISize());
    }

    public static MIcon fromFileURI(String string, int n) {
        if (string.startsWith("file:/")) {
            try {
                MIcon mIcon = new MIcon(new File(new URI(string)));
                if (mIcon.isEmpty()) {
                    return null;
                }
                return n == -1 ? mIcon : mIcon.scale(n, n, UI.Quality.HIGH);
            }
            catch (URISyntaxException uRISyntaxException) {
                MLogger.exception(uRISyntaxException);
                return null;
            }
        }
        return n == -1 ? MIcon.unscaled(string) : MIcon.stock(string, n);
    }

    public static MIcon get(Class<?> clazz, String string, int n) {
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            return null;
        }
        MIcon mIcon = new MIcon(uRL);
        return n == -1 ? mIcon : mIcon.scale(n, n, UI.Quality.HIGH);
    }

    public static MIcon get(File file, int n) {
        MIcon mIcon = new MIcon(file);
        return n == -1 ? mIcon : mIcon.scale(n, n, UI.Quality.HIGH);
    }

    public static MIcon getColorizedInstance(Icon icon, Color color) {
        return MIcon.getFilteredInstance(icon, new ColorizeFilter(color));
    }

    public static int getDefaultSize() {
        return 24;
    }

    public MIcon getDisabledInstance() {
        return new MIcon(GrayFilter.createDisabledImage(this.getImage()));
    }

    public MIcon getFilteredInstance(BufferedImageOp bufferedImageOp) {
        return MIcon.getFilteredInstance(this, bufferedImageOp);
    }

    public static MIcon getFilteredInstance(Icon icon, BufferedImageOp bufferedImageOp) {
        BufferedImage bufferedImage = icon instanceof ImageIcon ? UI.toBufferedImage(((ImageIcon)ImageIcon.class.cast(icon)).getImage(), false) : UI.toBufferedImage(icon);
        return new MIcon(bufferedImageOp.filter(bufferedImage, null));
    }

    public MIcon getGrayscaleInstance() {
        return this.getFilteredInstance(new GrayscaleFilter());
    }

    public static List<Image> getIcoImages(File file) throws IOException {
        try {
            Ico ico = new Ico(file);
            int n = ico.getNumImages();
            MArrayList<Image> mArrayList = new MArrayList<Image>(n);
            for (int i = 0; i < n; ++i) {
                mArrayList.add(ico.getImage(i));
            }
            return mArrayList;
        }
        catch (Ico.BadIcoResException badIcoResException) {
            throw new IOException(badIcoResException);
        }
    }

    public Dimension getIconSize() {
        return new Dimension(this.getIconWidth(), this.getIconHeight());
    }

    @Override
    public Image getImage() {
        this.loadOnDemand();
        return super.getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImage(Image image) {
        this.checkImmutable();
        MIcon mIcon = this;
        synchronized (mIcon) {
            this.stockLoadDone = true;
        }
        super.setImage(image);
    }

    public static Image getImage(String string) {
        MIcon mIcon = MIcon.unscaled(string);
        return mIcon == null ? null : mIcon.getImage();
    }

    public static int getMediumSize() {
        return Math.min(MIcon.getUISize(), DefaultIconLoader.getDefaultIconLoader().getMediumSize());
    }

    public String getName() {
        return this.stockName;
    }

    public static String getName(Icon icon) {
        if (icon instanceof MIcon) {
            return ((MIcon)MIcon.class.cast(icon)).getName();
        }
        return null;
    }

    public Image getOverlay() {
        return this.overlay;
    }

    public void setOverlay(Image image) {
        this.overlay = image;
    }

    public MIcon getReflectionInstance() {
        return this.getReflectionInstance(new Reflection());
    }

    public MIcon getReflectionInstance(Reflection reflection) {
        return reflection.createIcon(this);
    }

    public static int getSmallSize() {
        return DefaultIconLoader.getDefaultIconLoader().getSmallSize();
    }

    public static int getUISize() {
        int n = (Integer)UI.iconSize.get();
        return TK.range(n, MIcon.getDefaultSize(), 16, 64);
    }

    public boolean isEmpty() {
        return this.getIconWidth() < 1 || this.getIconHeight() < 1;
    }

    public static boolean isEmpty(Icon icon) {
        return icon == null || icon.getIconWidth() < 1 || icon.getIconHeight() < 1;
    }

    @Override
    public void loadImage(Image image) {
        block5: {
            this.checkImmutable();
            if (image instanceof BufferedImage) {
                try {
                    final int n = image.getWidth(null);
                    final int n2 = image.getHeight(null);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager == null) {
                        this.finishMediaTracker(n, n2);
                        break block5;
                    }
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            MIcon.this.finishMediaTracker(n, n2);
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    MLogger.exception(exception);
                    super.loadImage(image);
                }
            } else {
                super.loadImage(image);
            }
        }
    }

    public static MIcon medium(String string) {
        return MIcon.stock(string, MIcon.getMediumSize());
    }

    public MIcon scale(int n, int n2, UI.Quality quality) {
        return new MIcon(UI.scaleImage(this.getImage(), n, n2, quality));
    }

    public MIcon scaleSmall() {
        int n = MIcon.getSmallSize();
        return this.scale(n, n, UI.Quality.HIGH);
    }

    public MIcon scaleUI() {
        int n = MIcon.getUISize();
        return this.scale(n, n, UI.Quality.HIGH);
    }

    @Override
    public void setDescription(String string) {
        this.checkImmutable();
        super.setDescription(string);
    }

    @Override
    public void setImageObserver(ImageObserver imageObserver) {
        this.checkImmutable();
        super.setImageObserver(imageObserver);
    }

    public static MIcon small(String string) {
        return MIcon.stock(string, MIcon.getSmallSize());
    }

    public static MIcon stock(String string) {
        return MIcon.stock(string, MIcon.getUISize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MIcon stock(String string, int n) {
        MIcon mIcon;
        if (string == null) {
            return null;
        }
        MIcon mIcon2 = mIcon = new MIcon();
        synchronized (mIcon2) {
            mIcon.stockName = string;
            mIcon.stockSize = n;
        }
        return mIcon;
    }

    public static MIcon unscaled(Class<?> clazz, String string) {
        return MIcon.get(clazz, string, -1);
    }

    public static MIcon unscaled(String string) {
        return MIcon.stock(string, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIconHeight() {
        MIcon mIcon = this;
        synchronized (mIcon) {
            if (this.stockSize > 0) {
                return this.stockSize;
            }
        }
        this.loadOnDemand();
        return super.getIconHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIconWidth() {
        MIcon mIcon = this;
        synchronized (mIcon) {
            if (this.stockSize > 0) {
                return this.stockSize;
            }
        }
        this.loadOnDemand();
        return super.getIconWidth();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3;
        this.loadOnDemand();
        super.paintIcon(component, graphics, n, n2);
        if (this.overlay != null && (n3 = this.overlay.getWidth(null)) > 5) {
            graphics.drawImage(this.overlay, n + this.getIconWidth() - n3 - 1, n2 + this.getIconHeight() - this.overlay.getHeight(null) - 1, null);
        }
    }

    @Override
    @Deprecated
    public MIcon freeze() {
        this.loadOnDemand();
        this.immutable = true;
        return this;
    }

    @Override
    @Deprecated
    public boolean isImmutable() {
        return this.immutable;
    }

    protected void loadImage(String string) {
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        if (image != null) {
            this.setImage(image);
        }
    }

    protected void loadImage(URL uRL) {
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image != null) {
            this.setImage(image);
        }
    }

    private void checkImmutable() {
        if (this.immutable) {
            throw new IllegalArgumentException("Icon is immutable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishMediaTracker(int n, int n2) throws Exception {
        Field field = ImageIcon.class.getDeclaredField("loadStatus");
        Field field2 = ImageIcon.class.getDeclaredField("width");
        Field field3 = ImageIcon.class.getDeclaredField("height");
        try {
            field.setAccessible(true);
            field.set(this, 8);
            field2.setAccessible(true);
            field2.set(this, n);
            field3.setAccessible(true);
            field3.set(this, n2);
        }
        finally {
            field2.setAccessible(false);
            field3.setAccessible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadOnDemand() {
        Serializable serializable;
        if (this.stockLoadDone || this.stockName == null || super.getImage() != null) {
            return;
        }
        this.stockLoadDone = true;
        Cache cache = Cache.getInstance();
        int n = this.stockSize == -1 ? this.stockSize : TK.range(this.stockSize, MIcon.getDefaultSize(), 16, 64);
        String string = this.stockName + "-" + n;
        Serializable serializable2 = cache;
        synchronized (serializable2) {
            serializable = (MIcon)cache.get(string);
        }
        if (serializable == null) {
            Cache cache2;
            serializable2 = null;
            int n2 = Integer.MIN_VALUE;
            int n3 = MIcon.getSmallSize();
            if (n == n3 && (serializable = DefaultIconLoader.findIcon(this.stockName, n3)) != null) {
                n2 = ((MIcon)serializable).getIconWidth();
                if (n2 == n3) {
                    Cache cache3 = cache;
                    synchronized (cache3) {
                        cache.put(string, serializable);
                    }
                    super.setImage(((MIcon)serializable).getImage());
                    return;
                }
                serializable2 = serializable;
            }
            if (serializable2 == null) {
                cache2 = cache;
                synchronized (cache2) {
                    serializable2 = (MIcon)cache.get(this.stockName);
                }
            }
            if (serializable2 == null) {
                serializable2 = DefaultIconLoader.findIcon(this.stockName, -1);
                if (serializable2 == null) {
                    return;
                }
                n2 = ((MIcon)serializable2).getIconWidth();
                if (n2 < 1) {
                    MLogger.error("core", "Could not load icon: \"%s\"", this.stockName);
                    return;
                }
                cache2 = cache;
                synchronized (cache2) {
                    cache.put(this.stockName, serializable2);
                }
            } else if (n2 == Integer.MIN_VALUE) {
                n2 = ((MIcon)serializable2).getIconWidth();
            }
            serializable = n != -1 && n != n2 ? ((MIcon)serializable2).scale(n, n, UI.Quality.HIGH) : serializable2;
            cache2 = cache;
            synchronized (cache2) {
                cache.put(string, serializable);
            }
        }
        super.setImage(((MIcon)serializable).getImage());
    }

    public static interface Name {
        public String getIconName();

        public void setIconName(String var1);
    }

    public static final class Cache
    extends HashMap<String, MIcon> {
        private static final Cache _instance = new Cache();

        public static Cache getInstance() {
            return _instance;
        }

        private Cache() {
        }
    }

    public static enum Size {
        DEFAULT,
        SMALL,
        MEDIUM;

    }
}

