/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.makagiga.commons.Config;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MList;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MNotification;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSettingsPage;
import org.makagiga.commons.Mnemonic;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.fx.ImageTransition;

public class MSettingsDialog<T extends MSettingsPage>
extends MDialog {
    private boolean autoResizeWindow;
    private boolean needRestart;
    private int defaultWidth;
    private final int pageListPosition;
    private ListSelectionListener listHandler;
    private final MArrayList<Class<? extends MSettingsPage>> advancedPages = MArrayList.create();
    private MButton advancedButton;
    private MList<T> pageList;
    private MPanel pagePanel;
    private String id;

    public MSettingsDialog(Window window, String string) {
        this(window, string, 1);
    }

    public MSettingsDialog(Window window, String string, int n) {
        this(window, UI._("Settings"), "ui/configure", 7, string, n);
    }

    public MSettingsDialog(Window window, String string, String string2, String string3, int n) {
        this(window, string, string2, 7, string3, n);
    }

    public MSettingsDialog(Window window, String string, String string2, int n, String string3, int n2) {
        this(window, string, MIcon.stock(string2), n, string3, n2);
    }

    public MSettingsDialog(Window window, String string, Icon icon, int n, String string2, int n2) {
        super(window, string, icon, n);
        this.pageListPosition = n2;
        this.getMainPanel().setContentMargin();
        this.setSize(UI.WindowSize.LARGE);
        if (string2 != null) {
            this.id = TK.validateID(string2);
        }
        this.pageList = new MList();
        this.pageList.setCursor(Cursor.getPredefinedCursor(12));
        this.pageList.setSingleSelectionMode();
        this.listHandler = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    MSettingsDialog.this.updateView();
                }
            }
        };
        this.pageList.getSelectionModel().addListSelectionListener(this.listHandler);
        MRenderer mRenderer = new MRenderer(2);
        mRenderer.setUseAlternateRowColor(false);
        MLabel mLabel = mRenderer.getLabel();
        mLabel.setHorizontalAlignment(0);
        mLabel.setHorizontalTextPosition(0);
        mLabel.setVerticalTextPosition(3);
        this.pageList.setCellRenderer(mRenderer);
        if (n2 == 1) {
            this.pageList.setLayoutOrientation(2);
            this.getTitlePanel().addCenter(this.pageList);
        } else if (n2 == 2) {
            this.addWest(new MScrollPane(this.pageList));
        } else {
            throw new IllegalArgumentException("\"pageListPosition\" must be \"TOP\" or \"LEFT\"");
        }
        this.pagePanel = new MPanel();
        this.addCenter(this.pagePanel);
        this.advancedButton = new MButton(MActionInfo.ADVANCED);
        if (!((Boolean)UI.buttonIcons.get()).booleanValue()) {
            this.advancedButton.setIcon(null);
        }
        this.advancedButton.onClick(this, "advanced");
        this.advancedButton.setVisible(false);
        this.getButtonsPanel().add(this.advancedButton);
    }

    public void addAdvancedPage(Class<? extends MSettingsPage> clazz) {
        this.advancedPages.add(clazz);
        this.advancedButton.setVisible(true);
    }

    public void addPage(T t) {
        this.pageList.addItem(t);
        ((MSettingsPage)t).setParentWindow(this);
        if (this.pageListPosition == 1 && this.pageList.getLayoutOrientation() == 2) {
            MLabel mLabel;
            ListCellRenderer listCellRenderer;
            int n = (int)Math.ceil((float)this.pageList.getItemCount() / 3.0f);
            this.pageList.setVisibleRowCount(Math.max(1, n));
            if (this.pageList.getVisibleRowCount() > 1 && (listCellRenderer = this.pageList.getCellRenderer()) instanceof MRenderer && (mLabel = ((MRenderer)MRenderer.class.cast(listCellRenderer)).getLabel()) != null) {
                mLabel.setHorizontalAlignment(10);
                mLabel.setHorizontalTextPosition(11);
                mLabel.setVerticalTextPosition(0);
            }
        }
    }

    public void advanced() {
        String string = this.id == null ? null : this.id + "-advanced";
        MSettingsDialog<MSettingsPage> mSettingsDialog = new MSettingsDialog<MSettingsPage>(this, UI._("Advanced"), MActionInfo.ADVANCED.getIconName(), string, 1);
        mSettingsDialog.autoResizeWindow = this.autoResizeWindow;
        try {
            for (Class clazz : this.advancedPages) {
                MSettingsPage mSettingsPage = (MSettingsPage)clazz.newInstance();
                mSettingsDialog.addPage(mSettingsPage);
            }
            mSettingsDialog.exec();
        }
        catch (Exception exception) {
            MMessage.error((Window)this, exception);
        }
    }

    @Override
    public boolean exec() {
        return this.exec(this.pageList);
    }

    @Override
    public boolean exec(JComponent jComponent) {
        Config config = this.getConfigPrivileged();
        if (this.pageList.isEmpty()) {
            this.pageList.setEnabled(false);
            this.pageList.setText(UI._("No Items"));
        } else {
            if (this.id != null) {
                this.pageList.setSelectedIndex(config.readInt("Settings.tab." + this.id, 0, this.pageList), true);
            }
            if (this.pageList.isSelectionEmpty()) {
                this.pageList.setSelectedIndex(0, true);
            }
        }
        if (this.autoResizeWindow) {
            this.pack();
        }
        this.defaultWidth = UI.WindowSize.MEDIUM.getDimension().width;
        this.defaultWidth = Math.max(this.getWidth(), this.defaultWidth);
        this.setWidth(this.defaultWidth);
        boolean bl = super.exec(jComponent);
        for (MSettingsPage mSettingsPage : this.pageList) {
            mSettingsPage.setParentWindow(null);
        }
        if (this.id != null) {
            config.write("Settings.tab." + this.id, this.pageList.getSelectedIndex());
        }
        this.pageList.clear();
        this.pageList = null;
        return bl;
    }

    @Deprecated
    public static boolean execPage(Window window, MSettingsPage mSettingsPage) {
        return MSettingsDialog.execPage(window, mSettingsPage, null);
    }

    static boolean execPage(Window window, MSettingsPage mSettingsPage, JComponent jComponent) {
        if (mSettingsPage == null) {
            return false;
        }
        MSettingsDialog<MSettingsPage> mSettingsDialog = new MSettingsDialog<MSettingsPage>(window, mSettingsPage.getText(), mSettingsPage.getIcon(), mSettingsPage.getDialogFlags(), null, 1);
        MPanel mPanel = mSettingsDialog.getMainPanel();
        int n = mPanel.getContentMargin();
        int n2 = UI.isSubstance() ? n : 0;
        mPanel.setMargin(n2, n, n, n);
        mSettingsDialog.setAutoResizeWindow(true);
        MScrollPane mScrollPane = MScrollPane.getScrollPane(mSettingsDialog.getPageList());
        if (mScrollPane != null) {
            mScrollPane.setVisible(false);
        }
        mSettingsDialog.addPage(mSettingsPage);
        return mSettingsDialog.exec(jComponent);
    }

    public boolean getAutoResizeWindow() {
        return this.autoResizeWindow;
    }

    public void setAutoResizeWindow(boolean bl) {
        this.autoResizeWindow = bl;
    }

    public MList<T> getPageList() {
        return this.pageList;
    }

    public T getSelectedPage() {
        return (T)((MSettingsPage)this.pageList.getSelectedItem());
    }

    public void setSelectedPage(T t) {
        this.pageList.setSelectedItem(t, true);
    }

    @Deprecated
    public ImageTransition.Effect getTransitionEffect() {
        return null;
    }

    @Deprecated
    public void setTransitionEffect(ImageTransition.Effect effect) {
    }

    public boolean isPageListVisible() {
        return MScrollPane.getScrollPane(this.pageList).isVisible();
    }

    public void setPageListVisible(boolean bl) {
        MScrollPane.getScrollPane(this.pageList).setVisible(bl);
    }

    public void setNeedRestart(boolean bl) {
        this.needRestart = bl;
    }

    public static void showRestartInfo() {
        MNotification.Message message = new MNotification.Message(MActionInfo.OK.getText(), UI._("OK. Restart application to apply changes."), "ui/refresh");
        message.setTimeout(10000);
        MNotification.showMessage(message);
    }

    protected void apply() {
        for (MSettingsPage mSettingsPage : this.pageList) {
            if (mSettingsPage.initDone) {
                if (!mSettingsPage.getAutoUpdateModel()) {
                    mSettingsPage.updateModel();
                }
                mSettingsPage.onOK();
            }
            if (!mSettingsPage.getNeedRestart()) continue;
            this.needRestart = true;
        }
        Config.getDefault().sync();
        if (this.needRestart) {
            MSettingsDialog.showRestartInfo();
        }
    }

    @Override
    protected boolean onAccept() {
        this.apply();
        return true;
    }

    @Override
    protected final void onClose() {
        for (MSettingsPage mSettingsPage : this.pageList) {
            mSettingsPage.onClose();
        }
        if (this.listHandler != null) {
            this.pageList.getSelectionModel().removeListSelectionListener(this.listHandler);
            this.listHandler = null;
        }
        super.onClose();
    }

    protected void onPageChange() {
    }

    protected void updatePagePanel(MPanel mPanel, T t) {
        mPanel.removeAll();
        mPanel.addNorth((JComponent)t);
        mPanel.validate();
    }

    private Config getConfigPrivileged() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return Config.getDefault();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Config>(){

            @Override
            public Config run() {
                return Config.getDefault();
            }
        });
    }

    private void updateView() {
        Serializable serializable;
        T t = this.getSelectedPage();
        if (t != null) {
            if (!((MSettingsPage)t).initDone) {
                ((MSettingsPage)t).initOnDemand();
                if (MApplication.forceRTL) {
                    ((Container)t).applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                }
                serializable = new Mnemonic();
                ((Mnemonic)serializable).exclude(this.mnemonic);
                ((Mnemonic)serializable).apply((Container)t);
            }
            this.updatePagePanel(this.pagePanel, t);
        }
        this.onPageChange();
        if (this.autoResizeWindow) {
            serializable = this.getPreferredSize();
            ((Dimension)serializable).width = this.defaultWidth;
            this.setSize((Dimension)serializable);
        }
    }
}

