/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.makagiga.commons.ImageBorder;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MSettingsDialog;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.UI;
import org.makagiga.form.PropertyPanel;

public class MSettingsPage
extends PropertyPanel
implements MRenderer.Renderable {
    boolean initDone;
    private boolean needRestart;
    private Icon icon;
    private ImageBorder previewBorder;
    private int dialogFlags = 7;
    private String text;
    private MTimer previewTimer;
    private WeakReference<Window> parentWindowRef;

    public MSettingsPage() {
        this(UI._("Settings"), MIcon.stock("ui/configure"));
    }

    public MSettingsPage(String string) {
        this(string, (Icon)null);
    }

    public MSettingsPage(String string, Icon icon) {
        super(10);
        this.setAutoUpdateModel(false);
        this.text = string;
        this.icon = icon == null ? MIcon.stock("ui/configure") : icon;
    }

    public MSettingsPage(String string, String string2) {
        this(string, MIcon.stock(string2));
    }

    @Deprecated
    public void addAdvancedButton(final Class<? extends MSettingsPage> clazz) {
        this.add(new MButton(MActionInfo.ADVANCED){

            @Override
            protected void onClick() {
                try {
                    MSettingsPage mSettingsPage = (MSettingsPage)clazz.newInstance();
                    mSettingsPage.exec(MSettingsPage.this.getParentWindow());
                }
                catch (Exception exception) {
                    MMessage.error(MSettingsPage.this.getParentWindow(), exception);
                }
            }
        });
    }

    public boolean exec(Window window) {
        return MSettingsDialog.execPage(window, this, null);
    }

    public boolean exec(Window window, JComponent jComponent) {
        return MSettingsDialog.execPage(window, this, jComponent);
    }

    public int getDialogFlags() {
        return this.dialogFlags;
    }

    public void setDialogFlags(int n) {
        this.dialogFlags = n;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean getNeedRestart() {
        return this.needRestart;
    }

    public void setNeedRestart(boolean bl) {
        this.needRestart = bl;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.previewBorder != null) {
            this.previewBorder.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public String toString() {
        return this.text;
    }

    @Override
    public void setupRenderer(MRenderer<?> mRenderer) {
        mRenderer.setIcon(this.getIcon());
        mRenderer.setText(this.getText());
    }

    protected Window getParentWindow() {
        return this.parentWindowRef == null ? null : (Window)this.parentWindowRef.get();
    }

    protected void setParentWindow(Window window) {
        this.parentWindowRef = window == null ? null : new WeakReference<Window>(window);
    }

    protected void onClose() {
    }

    protected void onInit() {
    }

    protected void onOK() {
    }

    protected void setImagePreview(final int n, String string) {
        if (n == -1) {
            if (this.previewTimer != null) {
                this.previewTimer.stop();
                this.previewTimer = null;
            }
        } else {
            if (this.previewTimer == null) {
                this.previewTimer = new MTimer(MTimer.Format.SECONDS, 2){

                    @Override
                    protected boolean onTimeout() {
                        MSettingsPage.this.setPreviewVisible(false, n);
                        return false;
                    }
                };
            }
            this.previewTimer.restart();
            this.setPreviewVisible(true, n);
        }
    }

    private Rectangle getRepaintBounds() {
        Rectangle rectangle = this.previewBorder.getPaintBounds(this, 0, 0);
        rectangle.grow(2, 2);
        return rectangle;
    }

    private void setPreviewVisible(boolean bl, int n) {
        if (this.previewBorder != null) {
            this.repaint(this.getRepaintBounds());
        }
        if (this.previewBorder == null) {
            this.previewBorder = new ImageBorder(MIcon.getImage("duke.jpg"), ImageBorder.Position.CENTERED_USER_BOUNDS);
            this.previewBorder.setAlpha(0.5f);
            this.previewBorder.setOutlineColor(Color.BLACK);
        }
        this.previewBorder.setUserSize(n);
        this.previewBorder.setVisible(bl);
        this.repaint(this.getRepaintBounds());
    }

    void initOnDemand() {
        if (this.initDone) {
            return;
        }
        this.initDone = true;
        this.onInit();
        this.alignLabels();
        if (!this.getEditors().isEmpty()) {
            this.addGap();
            this.add(new MSmallButton(this.createDefaultsAction(), false));
        }
    }
}

