/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.makagiga.commons.AbstractIterator;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.ColumnManager;
import org.makagiga.commons.Config;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MCellTip;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MTableHeader;
import org.makagiga.commons.MV;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.style.StyleSupport;

public class MTable<M extends TableModel>
extends JTable
implements Iterable<Integer>,
MDisposable,
MouseWheelListener,
StyleSupport {
    private ColumnManager<M> columnManager;
    private static final FixScrollRectToVisible fixScrollRectToVisible = new FixScrollRectToVisible();

    public MTable() {
        this(new DefaultTableModel());
    }

    public MTable(M m) {
        super((TableModel)m);
        this.setFillsViewportHeight(true);
        this.setRowHeight(24);
        this.addAncestorListener(fixScrollRectToVisible);
        this.addMouseWheelListener(this);
        MCellTip.getInstance().install(this);
    }

    public boolean canCancelEdit(Window window, String string) {
        if (!this.isEditing()) {
            return true;
        }
        int n = this.getEditingColumn();
        int n2 = this.getEditingRow();
        if (n == -1 || n2 == -1) {
            return true;
        }
        return MMessage.customConfirm(window, MIcon.stock("ui/warning"), new MActionInfo(UI._("Stop Editing"), "ui/stop"), new MActionInfo(UI._("Continue Editing"), "ui/right"), UI.makeHTML(UI._("In order to perform this action<br>you must <b>stop cell editing</b>.")), new String[]{UI._("Action: {0}", string), UI._("Column: {0}", this.getColumnName(n)), UI._("Row: {0}", n2 + 1)});
    }

    public static boolean canStartEdit(EventObject eventObject, boolean bl) {
        InputEvent inputEvent;
        if (eventObject instanceof InputEvent && ((inputEvent = (InputEvent)eventObject).isAltDown() || inputEvent.isControlDown() || inputEvent.isShiftDown())) {
            return false;
        }
        if (eventObject instanceof KeyEvent) {
            inputEvent = (KeyEvent)eventObject;
            switch (((KeyEvent)inputEvent).getKeyCode()) {
                case 27: 
                case 112: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 155: 
                case 524: 
                case 525: {
                    return false;
                }
            }
            return true;
        }
        if (!bl && eventObject instanceof MouseEvent) {
            return MMouseAdapter.isDoubleClick((MouseEvent)eventObject);
        }
        return true;
    }

    public void deleteAll() {
        this.doneEdit();
        this.removeAllRows();
    }

    public void deleteSelected() {
        this.doneEdit();
        M m = this.getModel();
        if (m instanceof AbstractListTableModel && this.getSelectedRowCount() == m.getRowCount()) {
            ((AbstractListTableModel)AbstractListTableModel.class.cast(m)).clear();
        } else {
            int n = this.getSelectedRow();
            try {
                for (int i = m.getRowCount() - 1; i >= 0; --i) {
                    if (!this.isRowSelected(this.convertRowIndexToView(i))) continue;
                    this.removeRow(i);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                MLogger.exception(arrayIndexOutOfBoundsException);
            }
            this.selectRow(n);
        }
    }

    public boolean deleteSelected(Window window, String string, int n) {
        return this.deleteSelected(window, string, null, n);
    }

    public boolean deleteSelected(Window window, String string, Object[] objectArray) {
        return this.deleteSelected(window, string, objectArray, -1);
    }

    public boolean deleteSelected(Window window, String string, Object[] objectArray, int n) {
        if (objectArray == null && n != -1) {
            int[] nArray = this.getSelectedRows();
            objectArray = new Object[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.convertRowIndexToModel(nArray[i]);
                objectArray[i] = this.getModel().getValueAt(n2, n);
            }
        }
        if (!this.canCancelEdit(window, UI._("Delete Selected"))) {
            return false;
        }
        if (MMessage.customConfirm(window, MIcon.stock("ui/delete"), new MActionInfo(UI._("Delete Selected"), "ui/delete"), null, string == null ? MMessage.getSimpleConfirmMessage() : string, objectArray)) {
            this.deleteSelected();
            return true;
        }
        return false;
    }

    public void doneEdit() {
        if (!this.isEditing()) {
            return;
        }
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
            tableCellEditor.cancelCellEditing();
        }
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        if (!MTable.canStartEdit(eventObject, true)) {
            return false;
        }
        return super.editCellAt(n, n2, eventObject);
    }

    public ColumnManager<M> getColumnManager() {
        return this.columnManager;
    }

    public M getModel() {
        return (M)super.getModel();
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.columnManager = new ColumnManager(this);
    }

    public String getSelectionText() {
        return MTable.getSelectionText(this.getSelectedRowCount());
    }

    public static String getSelectionText(int n) {
        switch (n) {
            case 0: {
                return UI._("No selection");
            }
            case 1: {
                return UI._("One selected item");
            }
        }
        if (n < 0) {
            return UI._("No selection");
        }
        return UI._("Selected items: {0}", n);
    }

    public SortOrder getSortOrder() {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter == null) {
            return SortOrder.UNSORTED;
        }
        List<RowSorter.SortKey> list = rowSorter.getSortKeys();
        RowSorter.SortKey sortKey = list.isEmpty() ? null : list.get(0);
        return sortKey == null ? SortOrder.UNSORTED : sortKey.getSortOrder();
    }

    public boolean isCellTipEnabled(int n, int n2) {
        return true;
    }

    public boolean isEmpty(MV mV) {
        switch (mV) {
            case MODEL: {
                return this.getModel().getRowCount() == 0;
            }
            case VIEW: {
                return this.getRowCount() == 0;
            }
        }
        throw new WTFError(mV);
    }

    public boolean isGridVisible() {
        return this.getShowHorizontalLines() || this.getShowVerticalLines();
    }

    public void setGridVisible(boolean bl) {
        this.setIntercellSpacing(bl ? new Dimension(1, 1) : new Dimension());
        this.setShowGrid(bl);
    }

    public boolean isSelection() {
        return this.getSelectedRow() != -1;
    }

    public boolean isSortByColumn(int n) {
        return MTable.isSortByColumn(this, n);
    }

    public static boolean isSortByColumn(JTable jTable, int n) {
        RowSorter<? extends TableModel> rowSorter = jTable.getRowSorter();
        if (rowSorter == null) {
            return false;
        }
        List<RowSorter.SortKey> list = rowSorter.getSortKeys();
        return !list.isEmpty() && list.get(0).getColumn() == jTable.convertColumnIndexToModel(n);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.rowIterator(MV.MODEL);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        MScrollPane.mouseWheelScroll(this, mouseWheelEvent);
        mouseWheelEvent.consume();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    @Deprecated
    public boolean readColumnOrder(Config config, String string, String string2) {
        TableColumn tableColumn;
        String string3 = config.read(string, string2);
        if (TK.isEmpty(string3)) {
            return false;
        }
        Object[] objectArray = string3.split(" ");
        if (TK.isEmpty(objectArray)) {
            return false;
        }
        int n = this.columnModel.getColumnCount();
        HashMap<Object, TableColumn> hashMap = new HashMap<Object, TableColumn>(n);
        for (int i = n - 1; i >= 0; --i) {
            tableColumn = this.columnModel.getColumn(i);
            hashMap.put(tableColumn.getIdentifier(), tableColumn);
            this.columnModel.removeColumn(tableColumn);
        }
        for (Object object : objectArray) {
            tableColumn = (TableColumn)hashMap.get(object);
            if (tableColumn == null) continue;
            this.columnModel.addColumn(tableColumn);
        }
        return this.columnModel.getColumnCount() != 0;
    }

    @Deprecated
    public void readSortOrder(Config config, String string, String string2) {
        String string3 = config.read(string, null);
        String string4 = config.read(string2, null);
        if (TK.isEmpty(string3) || TK.isEmpty(string4)) {
            this.setDefaultSortOrder();
            return;
        }
        Object[] objectArray = string3.split(" ");
        if (TK.isEmpty(objectArray)) {
            this.setDefaultSortOrder();
            return;
        }
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt((String)objectArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                MLogger.exception(numberFormatException);
                this.setDefaultSortOrder();
                return;
            }
        }
        Object[] objectArray2 = string4.split(" ");
        if (TK.isEmpty(objectArray2)) {
            this.setDefaultSortOrder();
            return;
        }
        SortOrder[] sortOrderArray = new SortOrder[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            sortOrderArray[i] = EnumProperty.parse((String)objectArray2[i], SortOrder.UNSORTED);
        }
        if (nArray.length != sortOrderArray.length) {
            this.setDefaultSortOrder();
            return;
        }
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new RowSorter.SortKey(nArray[i], sortOrderArray[i]));
        }
        if (arrayList.isEmpty()) {
            this.setDefaultSortOrder();
        } else {
            try {
                RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
                if (rowSorter != null) {
                    rowSorter.setSortKeys(arrayList);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setDefaultSortOrder();
            }
        }
    }

    public void removeAllRows() {
        if (!(this.getModel() instanceof AbstractListTableModel)) {
            throw new UnsupportedOperationException("Table does not support this operation (hint: override \"removeAllRows\" method)");
        }
        ((AbstractListTableModel)AbstractListTableModel.class.cast(this.getModel())).clear();
    }

    public void removeRow(int n) {
        if (!(this.getModel() instanceof AbstractListTableModel)) {
            throw new UnsupportedOperationException("Table does not support this operation (hint: override \"removeRow\" method)");
        }
        ((AbstractListTableModel)AbstractListTableModel.class.cast(this.getModel())).removeRow(n);
    }

    public RowIterator rowIterator(MV mV) {
        return new RowIterator(mV);
    }

    public void scrollToRow(int n) {
        Rectangle rectangle = this.getCellRect(n, 0, true);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public void selectRow(int n) {
        if (this.isEmpty(MV.VIEW)) {
            return;
        }
        try {
            this.setRowSelectionInterval(n, n);
            this.scrollToRow(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setDefaultSortOrder() {
        this.sortBy(-1, false);
    }

    public static JPopupMenu showPopupMenu(JTable jTable, int n, int n2, MMenu mMenu) {
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        return mMenu.showPopup(jTable, rectangle.x, rectangle.y + rectangle.height);
    }

    public void sortBy(int n, boolean bl) {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter == null) {
            return;
        }
        if (n == -1) {
            rowSorter.setSortKeys(null);
        } else {
            SortOrder sortOrder = this.getSortOrder();
            boolean bl2 = sortOrder == SortOrder.ASCENDING || sortOrder == SortOrder.UNSORTED;
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(n, bl2 ? SortOrder.ASCENDING : SortOrder.DESCENDING));
            rowSorter.setSortKeys(arrayList);
            if (bl) {
                rowSorter.toggleSortOrder(n);
            }
        }
        this.doneEdit();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.onChange(tableModelEvent);
    }

    @Deprecated
    public void writeColumnOrder(Config config, String string) {
        Object[] objectArray = new String[this.columnModel.getColumnCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.columnModel.getColumn(i).getIdentifier().toString();
        }
        config.write(string, TK.join(objectArray, " "));
    }

    @Deprecated
    public void writeSortOrder(Config config, String string, String string2) {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        String string3 = null;
        String string4 = null;
        if (rowSorter != null) {
            List<RowSorter.SortKey> list = rowSorter.getSortKeys();
            for (RowSorter.SortKey sortKey : list) {
                string3 = string3 == null ? Integer.toString(sortKey.getColumn()) : string3 + " " + sortKey.getColumn();
                if (string4 == null) {
                    string4 = sortKey.getSortOrder().name();
                    continue;
                }
                string4 = string4 + " " + sortKey.getSortOrder().name();
            }
        }
        config.write(string, string3);
        config.write(string2, string4);
    }

    @Override
    public Object dispose(Object ... objectArray) {
        this.removeMouseWheelListener(this);
        MCellTip.getInstance().uninstall(this);
        MScrollPane mScrollPane = MScrollPane.getScrollPane(this);
        if (mScrollPane != null) {
            mScrollPane.setCorner("UPPER_TRAILING_CORNER", null);
        }
        return null;
    }

    @Override
    public void setStyle(String string) {
        UI.setStyle(string, this);
    }

    @Override
    protected void configureEnclosingScrollPane() {
        MScrollPane mScrollPane = MScrollPane.getScrollPane(this);
        if (this.columnManager != null && mScrollPane != null) {
            mScrollPane.setCorner("UPPER_TRAILING_CORNER", this.columnManager.createCornerComponent());
            mScrollPane.setVerticalScrollBarPolicy(22);
        }
        super.configureEnclosingScrollPane();
        if (UI.isMetal() && mScrollPane != null) {
            mScrollPane.setBorder(null);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new MTableHeader(this.getColumnModel());
    }

    protected void onChange(TableModelEvent tableModelEvent) {
    }

    private static final class FixScrollRectToVisible
    implements AncestorListener {
        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            MTable mTable = (MTable)ancestorEvent.getComponent();
            int[] nArray = mTable.getSelectedRows();
            if (nArray.length == 1) {
                mTable.removeAncestorListener(this);
                mTable.selectRow(nArray[0]);
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        private FixScrollRectToVisible() {
        }
    }

    public final class RowIterator
    extends AbstractIterator<Integer> {
        private final MV mv;

        public RowIterator(MV mV) {
            this.mv = mV;
        }

        @Override
        public Integer getObjectAt(int n) {
            return n;
        }

        @Override
        public int getObjectCount() {
            if (this.mv == MV.MODEL) {
                return MTable.this.getModel().getRowCount();
            }
            return MTable.this.getRowCount();
        }
    }
}

