/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.makagiga.commons.Config;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.FS;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.Net;
import org.makagiga.commons.OS;
import org.makagiga.commons.SimpleXMLReader;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public class MTip
extends CoolHeader {
    private static Database database;
    private CoolHeader.Direction oldDirection;
    private String context;
    private TipInfo currentTip;
    private Visible visible;

    public MTip(CoolHeader.Direction direction) {
        this(direction, "default", null);
    }

    public MTip(String string) {
        this(CoolHeader.Direction.TOP, string, null);
    }

    public MTip(String string, String string2) {
        this(CoolHeader.Direction.TOP, string, string2);
    }

    public MTip(CoolHeader.Direction direction, String string) {
        this(direction, string, null);
    }

    public MTip(CoolHeader.Direction direction, String string, String string2) {
        this.context = string;
        if (!TK.isEmpty(string2)) {
            this.context = this.context + "-" + string2;
        }
        this.setDirection(direction);
        StaticHandler staticHandler = new StaticHandler();
        this.addMouseListener(staticHandler);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        return new Dimension(0, dimension.height);
    }

    public static synchronized void load() {
        if (database == null) {
            database = new Database();
            Thread thread = new Thread((Runnable)database, "Tip Preloader");
            thread.setDaemon(true);
            thread.setPriority(1);
            thread.start();
        }
    }

    public void showNextTip() {
        this.showNextTip(Visible.ALWAYS);
    }

    public void showNextTip(Visible visible) {
        this.visible = visible;
        this.currentTip = this.getNextTip();
        if (this.currentTip == null) {
            this.setText(null);
            this.setVisible(false);
        } else {
            if (!this.canShow(visible)) {
                this.setText(null);
                this.setVisible(false);
                return;
            }
            if (this.currentTip.text.icon == null) {
                if (this.oldDirection != null) {
                    this.setDirection(this.oldDirection);
                }
            } else {
                MIcon mIcon = MIcon.small(this.currentTip.text.icon);
                if (mIcon == null) {
                    if (this.oldDirection != null) {
                        this.setDirection(this.oldDirection);
                    }
                } else {
                    CoolHeader.Direction direction = this.getDirection();
                    if (direction != CoolHeader.Direction.NONE) {
                        this.oldDirection = direction;
                        this.setDirection(CoolHeader.Direction.NONE);
                    }
                    this.setIcon(mIcon);
                }
            }
            this.setTipText(this.currentTip.text.value);
            if (this.currentTip.text.isHTTP()) {
                this.setCursor(12);
                this.setToolTipText(MURLButton.getLinkToolTipText(this.currentTip.text.more));
            } else {
                this.setCursor(0);
                this.setToolTipText(this.currentTip.text.value);
            }
        }
    }

    public void setTipText(String string) {
        if (TK.isEmpty(string)) {
            this.setText(null);
        } else {
            this.setText(UI._("Tip: {0}", string));
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setColor(UI.getDarker(UI.getColor("control"), MColor.WHITE), UI.getColor("controlText"));
    }

    private boolean canShow(Visible visible) {
        int n;
        if (visible == Visible.ALWAYS) {
            return true;
        }
        Config config = this.getConfigPrivileged();
        if (config.read("Tip.disabled." + this.context, false)) {
            return false;
        }
        long l = TimeUnit.HOURS.toMillis(1L);
        MDate mDate = MDate.now();
        String string = "Tip.lastVisible." + this.context;
        MDate mDate2 = config.readDate(string, 0L);
        if (mDate.getTime() < mDate2.getTime()) {
            return true;
        }
        int n2 = n = visible == Visible.OFTEN ? 2 : 7;
        if (mDate.getDayCount(mDate2.getTime()) >= (long)n) {
            config.writeDate(string, mDate.getTime() + l);
            return true;
        }
        return false;
    }

    private Config getConfigPrivileged() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return Config.getDefault();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Config>(){

            @Override
            public Config run() {
                return Config.getDefault();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TipInfo getNextTip() {
        Class<MTip> clazz = MTip.class;
        synchronized (MTip.class) {
            if (database == null) {
                database = new Database();
                database.run();
            } else {
                try {
                    Database database = MTip.database;
                    synchronized (database) {
                        while (!MTip.database.loaded) {
                            MTip.database.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    MLogger.exception(interruptedException);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MTip.database.getTipText(this.context);
        }
    }

    private static final class Tips {
        private final List<Text> texts = new ArrayList<Text>();
        private String context;

        private Tips() {
        }
    }

    private static final class TipInfo {
        private final Text text;

        private TipInfo(Text text) {
            this.text = text;
        }
    }

    private static final class Text {
        private String icon;
        private String more;
        private String value;

        private Text() {
        }

        private boolean isHTTP() {
            return this.more != null && Net.isHTTP(this.more);
        }
    }

    private static final class StaticHandler
    extends MMouseAdapter {
        private StaticHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (StaticHandler.isLeft(mouseEvent)) {
                MTip mTip = (MTip)mouseEvent.getSource();
                if (mTip.currentTip != null && mTip.currentTip.text.isHTTP()) {
                    MMainWindow.openURI(mTip.currentTip.text.more);
                }
                mouseEvent.consume();
            }
        }

        @Override
        public void popupTrigger(final MouseEvent mouseEvent) {
            MTip mTip = (MTip)mouseEvent.getSource();
            MMenu mMenu = new MMenu();
            MAction mAction = new MAction(UI._("Do not show this message again"), "ui/close"){

                @Override
                public void onAction() {
                    MTip mTip = (MTip)mouseEvent.getSource();
                    mTip.setVisible(false);
                    Config config = Config.getDefault();
                    config.write("Tip.disabled." + mTip.context, true);
                    config.sync();
                }
            };
            mAction.setEnabled(mTip.visible != Visible.ALWAYS);
            mMenu.add(mAction);
            mMenu.showPopup(mouseEvent);
        }
    }

    private static final class Database
    extends ArrayList<Tips>
    implements Runnable {
        private boolean loaded;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.load(OS.getLocale().getLanguage()) && !this.load("en")) {
                MLogger.warning("tip", "Tips database not found");
            }
            Database database = this;
            synchronized (database) {
                this.loaded = true;
                this.notifyAll();
            }
        }

        private Database() {
        }

        private TipInfo getTipText(String string) {
            if (this.isEmpty()) {
                return null;
            }
            Tips tips = null;
            for (Tips tips2 : this) {
                if (!tips2.context.equals(string)) continue;
                tips = tips2;
                break;
            }
            if (tips == null || TK.isEmpty(tips.texts)) {
                MLogger.warning("tip", "No tips for \"%s\"", string);
                return null;
            }
            Random random = new Random();
            return new TipInfo((Text)tips.texts.get(random.nextInt(tips.texts.size())));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean load(String string) {
            this.clear();
            InputStream inputStream = null;
            try {
                final String string2 = "/" + MApplication.getResourcesPath() + "/tips/" + string + ".xml";
                MLogger.info("tip", "Loading tips: \"%s\"", string2);
                inputStream = this.getClass().getResourceAsStream(string2);
                if (inputStream == null) {
                    boolean bl = false;
                    FS.close(inputStream);
                    return bl;
                }
                SimpleXMLReader simpleXMLReader = new SimpleXMLReader(){
                    private Tips tips;

                    @Override
                    protected void onEnd(String string) {
                        if (this.tips != null && "tips".equals(string)) {
                            if (TK.isEmpty(this.tips.texts)) {
                                MLogger.warning("tip", "No tips for \"%s\" context", this.tips.context);
                                this.tips = null;
                            } else {
                                MLogger.debug("tip", "Adding tips for \"%s\" context (%d)", this.tips.context, this.tips.texts.size());
                                Database.this.add(this.tips);
                                this.tips = null;
                            }
                        }
                    }

                    @Override
                    protected void onStart(String string) {
                        if (this.tips != null && "text".equals(string)) {
                            Text text = new Text();
                            text.icon = this.getStringAttribute("icon");
                            text.more = this.getStringAttribute("more");
                            text.value = this.getValue();
                            if (TK.isEmpty(text.value)) {
                                MLogger.warning("tip", "Empty tip for \"%s\" context", this.tips.context);
                            } else {
                                this.tips.texts.add(text);
                            }
                        } else if (this.tips == null && "tips".equals(string)) {
                            this.tips = new Tips();
                            this.tips.context = this.getStringAttribute("context");
                            if (TK.isEmpty(this.tips.context)) {
                                MLogger.error("tip", "Empty context in \"%s\"", string2);
                                this.cancel();
                            }
                        }
                    }
                };
                simpleXMLReader.read(inputStream);
                boolean bl = true;
                FS.close(inputStream);
                return bl;
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
                boolean bl = false;
                return bl;
            }
            finally {
                FS.close(inputStream);
            }
        }
    }

    public static enum Visible {
        ALWAYS,
        OFTEN,
        SELDOM;

    }
}

