/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import org.makagiga.commons.ContainerScanner;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.TK;

public final class Mnemonic
implements Serializable {
    private char[] defaultMnemonics;
    private char[] mnemonics = new char[36];
    private static final int MAX = 36;
    private static final int[] TAB_KEYS = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
    private static final String BAD_MNEMONICS = "gijlpqrtyIJQ";
    private static final String EXCLUDED_PROPERTY = "org.makagiga.commons.Mnemonic.excluded";

    public Mnemonic() {
        this(null);
    }

    public Mnemonic(Container container) {
        int n;
        int n2 = 0;
        for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
            this.mnemonics[n2] = n;
            ++n2;
        }
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            this.mnemonics[n2] = n;
            ++n2;
        }
        this.defaultMnemonics = (char[])this.mnemonics.clone();
        this.apply(container);
    }

    public void apply(Container container) {
        if (container == null) {
            return;
        }
        if (container instanceof JComponent && Mnemonic.isExcluded((JComponent)container)) {
            return;
        }
        new ContainerScanner(container){

            @Override
            public void processComponent(Container container, Component component) {
                Mnemonic.this.doProcess(component);
            }

            @Override
            protected boolean shouldScan(Container container) {
                return !(container instanceof JComponent) || !Mnemonic.isExcluded((JComponent)container);
            }
        };
    }

    public String apply(AbstractButton abstractButton, String string) {
        char c = Mnemonic.parse(string);
        if (c != '\u0000') {
            abstractButton.setMnemonic(c);
            for (int i = 0; i < 36; ++i) {
                if (this.mnemonics[i] != c) continue;
                this.mnemonics[i] = '\u0000';
                break;
            }
            return Mnemonic.remove(string);
        }
        return string;
    }

    public void exclude(Mnemonic mnemonic) {
        for (int i = 0; i < 36; ++i) {
            if (mnemonic.mnemonics[i] != '\u0000') continue;
            this.mnemonics[i] = '\u0000';
        }
    }

    public static int[] getTabKeys() {
        return (int[])TAB_KEYS.clone();
    }

    public static boolean isExcluded(JComponent jComponent) {
        return Boolean.TRUE.equals(jComponent.getClientProperty(EXCLUDED_PROPERTY));
    }

    public static void setExcluded(JComponent jComponent, boolean bl) {
        jComponent.putClientProperty(EXCLUDED_PROPERTY, bl ? Boolean.valueOf(true) : null);
    }

    public static char parse(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n = string.length();
        if (n < 2) {
            return '\u0000';
        }
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                if (n2 != -1) {
                    n2 = -1;
                    continue;
                }
                n2 = i;
                continue;
            }
            if (n2 == -1) continue;
            if (c != ' ') {
                return c;
            }
            n2 = -1;
        }
        return '\u0000';
    }

    public static String set(AbstractButton abstractButton, String string) {
        if (abstractButton != null && Mnemonic.isExcluded(abstractButton)) {
            return string;
        }
        char c = Mnemonic.parse(string);
        if (c != '\u0000') {
            abstractButton.setMnemonic(c);
            return Mnemonic.remove(string);
        }
        return string;
    }

    @Deprecated
    public static String set(MLabel mLabel, String string) {
        char c = Mnemonic.parse(string);
        if (c != '\u0000') {
            mLabel.setDisplayedMnemonic(c);
            return Mnemonic.remove(string);
        }
        return string;
    }

    public void update(AbstractButton abstractButton) {
        if (Mnemonic.isExcluded(abstractButton)) {
            return;
        }
        int n = abstractButton.getMnemonic();
        if (n != 0) {
            for (int i = 0; i < 36; ++i) {
                if (this.defaultMnemonics[i] != n) continue;
                this.mnemonics[i] = (char)n;
                break;
            }
            abstractButton.setMnemonic(0);
        }
        this.processButton(abstractButton);
    }

    private boolean doProcess(Component component) {
        if (component instanceof AbstractButton) {
            this.processButton((AbstractButton)component);
            return true;
        }
        if (component instanceof JLabel) {
            this.processLabel((JLabel)component);
            return true;
        }
        if (component instanceof JTabbedPane) {
            this.processTabs((JTabbedPane)component);
            return true;
        }
        return false;
    }

    private char findMnemonicFor(String string) {
        if (TK.isEmpty(string)) {
            return '\u0000';
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (BAD_MNEMONICS.indexOf(c) != -1) continue;
            for (int j = 0; j < 36; ++j) {
                if (this.mnemonics[j] == '\u0000' || Character.toUpperCase(c) != this.mnemonics[j]) continue;
                char c2 = this.mnemonics[j];
                this.mnemonics[j] = '\u0000';
                return c2;
            }
        }
        return '\u0000';
    }

    private void processButton(AbstractButton abstractButton) {
        if (Mnemonic.isExcluded(abstractButton)) {
            return;
        }
        if (abstractButton.getMnemonic() != 0) {
            return;
        }
        char c = this.findMnemonicFor(abstractButton.getText());
        if (c != '\u0000') {
            abstractButton.setMnemonic(c);
        }
    }

    private void processLabel(JLabel jLabel) {
        if (Mnemonic.isExcluded(jLabel)) {
            return;
        }
        if (jLabel.getLabelFor() == null || jLabel.getDisplayedMnemonic() != 0) {
            return;
        }
        char c = this.findMnemonicFor(jLabel.getText());
        if (c != '\u0000') {
            jLabel.setDisplayedMnemonic(c);
        }
    }

    private void processTabs(JTabbedPane jTabbedPane) {
        if (Mnemonic.isExcluded(jTabbedPane)) {
            return;
        }
        int n = jTabbedPane.getTabCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (i <= TAB_KEYS.length - 1) {
                jTabbedPane.setMnemonicAt(i, TAB_KEYS[i]);
                continue;
            }
            jTabbedPane.setMnemonicAt(i, -1);
        }
    }

    private static String remove(String string) {
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + string.substring(n + 1);
    }
}

