/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.MenuSelectionManager;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MFrame;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public class MouseGestures
implements AWTEventListener {
    private boolean initDone;
    private Map<String, Gesture> gestures = new TreeMap<String, Gesture>();
    private Point oldPoint;
    private String moves;
    private WeakReference<Window> parentRef;

    public MouseGestures() {
        this(null);
    }

    public MouseGestures(Window window) {
        this.setParent(window);
        this.reset();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 48L);
    }

    public void add(Action action) {
        String string = MAction.getValue(action, "org.makagiga.commons.MAction.MOUSE_GESTURE_KEY", null);
        TK.checkNullOrEmpty(string);
        this.registerGesture(string, null, action);
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (((long)aWTEvent.getID() & 0x10L) != 0L) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            switch (mouseEvent.getID()) {
                case 500: 
                case 502: {
                    if (TK.isEmpty(this.moves)) break;
                    if (this.canShowMessage()) {
                        MStatusBar.ready();
                    }
                    if (this.canProcess()) {
                        Gesture gesture = this.findGesture(mouseEvent);
                        if (gesture != null) {
                            Window window = (Window)this.parentRef.get();
                            MAction.fire(gesture.action, window instanceof MFrame ? ((MFrame)MFrame.class.cast(window)).getJMenuBar() : null);
                        }
                        this.onGestureEnd();
                        mouseEvent.consume();
                    }
                    this.reset();
                    break;
                }
                case 506: {
                    if (!this.isGestureTrigger(mouseEvent) || !this.recognizeGesture(mouseEvent)) break;
                    if (this.moves.length() == 1) {
                        this.initOnDemand();
                        this.onGestureStart();
                    }
                    if (this.gestures.isEmpty()) {
                        return;
                    }
                    Gesture gesture = this.findGesture(mouseEvent);
                    String string = this.getGesturePath(this.moves, false);
                    if (this.canShowMessage()) {
                        if (gesture == null) {
                            MStatusBar.error(UI._("Unknown Mouse Gesture (see Help): {0}", string));
                        } else if (gesture.action.isEnabled()) {
                            MStatusBar.info(UI._("Mouse Gesture: {0}", String.format("%s [%s]", string, gesture.getDescription())));
                        } else {
                            MStatusBar.warning(String.format("[%s] %s [%s]", UI._("Action Not Available"), string, gesture.getDescription()));
                        }
                    }
                    this.onGesture();
                    mouseEvent.consume();
                    break;
                }
                case 501: {
                    this.reset();
                }
            }
        }
    }

    public String getGesturePath(String string, boolean bl) {
        int n = 0;
        char[] cArray = new char[]{'\u2190', '\u2192', '\u2191', '\u2193'};
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("  ");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'c': {
                    if (!bl) break;
                    n |= 2;
                    break;
                }
                case 's': {
                    if (!bl) break;
                    n |= 1;
                    break;
                }
                case 'L': {
                    stringBuilder.append(cArray[0]);
                    break;
                }
                case 'R': {
                    stringBuilder.append(cArray[1]);
                    break;
                }
                case 'U': {
                    stringBuilder.append(cArray[2]);
                    break;
                }
                case 'D': {
                    stringBuilder.append(cArray[3]);
                    break;
                }
                default: {
                    MLogger.error("gesture", "Unknown element \"%s\" in gesture \"%s\"", Character.valueOf(c), string);
                }
            }
            stringBuilder.append("  ");
        }
        if (bl && n != 0) {
            stringBuilder.insert(0, "  " + MouseEvent.getMouseModifiersText(n));
        }
        return stringBuilder.toString();
    }

    public Map<String, Gesture> getGestures() {
        return this.gestures;
    }

    public void initOnDemand() {
        if (this.initDone) {
            return;
        }
        this.initDone = true;
        Window window = (Window)this.parentRef.get();
        if (window instanceof MMainWindow) {
            ((MMainWindow)MMainWindow.class.cast(window)).onDynamicInit(this);
        }
    }

    public Gesture registerGesture(String string, Action action) {
        return this.registerGesture(string, null, action);
    }

    public Gesture registerGesture(String string, String string2, Action action) {
        return this.gestures.put(string, new Gesture(string2, action));
    }

    public void setParent(Window window) {
        this.parentRef = new WeakReference<Window>(window);
    }

    protected boolean canShowMessage() {
        return true;
    }

    protected void onGesture() {
    }

    protected void onGestureEnd() {
    }

    protected void onGestureStart() {
    }

    private void appendMove(char c) {
        if (this.moves.isEmpty()) {
            this.moves = this.moves + c;
        } else if (this.moves.charAt(this.moves.length() - 1) != c) {
            this.moves = this.moves + c;
        }
    }

    private boolean canProcess() {
        if (!((Boolean)UI.mouseGestures.get()).booleanValue()) {
            return false;
        }
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return false;
        }
        Window window = (Window)this.parentRef.get();
        return window != null && window.isActive();
    }

    private Gesture findGesture(MouseEvent mouseEvent) {
        Gesture gesture;
        String string = "";
        if (mouseEvent.isControlDown()) {
            string = string + "c";
        }
        if (mouseEvent.isShiftDown()) {
            string = string + "s";
        }
        if ((gesture = this.gestures.get(this.moves + string)) == null && !string.isEmpty()) {
            gesture = this.gestures.get(this.moves);
        }
        return gesture;
    }

    private boolean isGestureTrigger(MouseEvent mouseEvent) {
        return MMouseAdapter.isMiddle(mouseEvent) || MMouseAdapter.isRight(mouseEvent);
    }

    private boolean recognizeGesture(MouseEvent mouseEvent) {
        if (this.oldPoint == null) {
            this.oldPoint = mouseEvent.getLocationOnScreen();
            return false;
        }
        if (!this.canProcess()) {
            return false;
        }
        int n = 32;
        if (Math.abs(mouseEvent.getXOnScreen() - this.oldPoint.x) >= n) {
            if (mouseEvent.getXOnScreen() < this.oldPoint.x) {
                this.appendMove('L');
            } else {
                this.appendMove('R');
            }
            this.oldPoint = mouseEvent.getLocationOnScreen();
            return true;
        }
        if (Math.abs(mouseEvent.getYOnScreen() - this.oldPoint.y) >= n) {
            if (mouseEvent.getYOnScreen() < this.oldPoint.y) {
                this.appendMove('U');
            } else {
                this.appendMove('D');
            }
            this.oldPoint = mouseEvent.getLocationOnScreen();
            return true;
        }
        return false;
    }

    private void reset() {
        this.oldPoint = null;
        this.moves = "";
    }

    public static final class Gesture {
        private Action action;
        private String description;

        public Gesture(String string, Action action) {
            this.description = string;
            this.action = action;
        }

        public String getDescription() {
            if (this.description == null) {
                return MAction.getValue(this.action, "Name", this.action.toString());
            }
            return this.description;
        }
    }
}

