/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.autocompletion;

import java.io.File;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.makagiga.commons.FS;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.XMLHelper;
import org.makagiga.commons.autocompletion.AutoCompletion;

@XmlRootElement(name="autocompletion")
public final class AutoCompletionData {
    @XmlElement(name="item")
    private List<Item> list;
    private String id;
    @XmlTransient
    int max = 100;

    public AutoCompletionData() {
    }

    public AutoCompletionData(String string) {
        this.list = new ArrayList<Item>();
        this.id = string;
    }

    public void add(String string) {
        if (TK.isEmpty(string)) {
            return;
        }
        if (this.list == null) {
            this.list = new ArrayList<Item>();
        }
        this.list.add(new Item(string));
    }

    public List<Item> getList() {
        return this.list;
    }

    public int indexOf(String string) {
        if (TK.isEmpty(this.list)) {
            return -1;
        }
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            if (!this.list.get(i).toString().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static AutoCompletionData load(String string) {
        if (!((Boolean)Kiosk.textAutoCompletion.get()).booleanValue() || FS.isRestricted()) {
            return null;
        }
        try {
            final File file = AutoCompletionData.createFile(string, false);
            SecurityManager securityManager = System.getSecurityManager();
            AutoCompletionData autoCompletionData = securityManager == null ? XMLHelper.unmarshal(AutoCompletionData.class, file) : AccessController.doPrivileged(new PrivilegedExceptionAction<AutoCompletionData>(){

                @Override
                public AutoCompletionData run() throws Exception {
                    return XMLHelper.unmarshal(AutoCompletionData.class, file);
                }
            });
            autoCompletionData.id = string;
            return autoCompletionData;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (JAXBException jAXBException) {
            MLogger.exception(jAXBException);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getCause() instanceof JAXBException) {
                MLogger.exception(privilegedActionException);
            }
            return null;
        }
    }

    public void save() {
        if (!((Boolean)Kiosk.textAutoCompletion.get()).booleanValue() || FS.isRestricted()) {
            return;
        }
        try {
            this.cleanUp();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                XMLHelper.marshal((Object)this, AutoCompletionData.createFile(this.id, true));
            } else {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        XMLHelper.marshal((Object)AutoCompletionData.this, AutoCompletionData.createFile(AutoCompletionData.this.id, true));
                        return null;
                    }
                });
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MLogger.exception(fileNotFoundException);
        }
        catch (JAXBException jAXBException) {
            MLogger.exception(jAXBException);
        }
        catch (PrivilegedActionException privilegedActionException) {
            MLogger.exception(privilegedActionException.getCause());
        }
    }

    private void cleanUp() {
        if (TK.isEmpty(this.list)) {
            return;
        }
        if (this.list.size() <= this.max) {
            return;
        }
        Collections.sort(this.list);
        int n = this.max / 2;
        while (this.list.size() > n) {
            this.list.remove(this.list.size() - 1);
        }
    }

    private static File createFile(String string, boolean bl) {
        String string2 = FS.makeConfigPath("autocompletion", bl ? 1 : 0);
        return new File(string2, string + ".xml");
    }

    public static final class Item
    implements Comparable<Item> {
        @XmlAttribute
        protected int usage = 1;
        @XmlAttribute
        protected String text;
        private String textUpperCase;

        public Item() {
        }

        public Item(String string) {
            this.text = string;
        }

        public boolean matches(String string, boolean bl, AutoCompletion.Mode mode) {
            String string2;
            if (bl) {
                string2 = this.text == null ? "" : this.text;
            } else {
                string = string.toUpperCase();
                if (this.textUpperCase == null) {
                    this.textUpperCase = this.text == null ? "" : this.text.toUpperCase();
                }
                string2 = this.textUpperCase;
            }
            if (mode == AutoCompletion.Mode.ANY_TEXT) {
                return string2.contains(string);
            }
            return string2.startsWith(string) && string2.length() > string.length();
        }

        public String toString() {
            return this.text == null ? "" : this.text;
        }

        @Override
        public int compareTo(Item item) {
            int n = TK.compare(this.usage, item.usage) * -1;
            return n == 0 ? this.toString().compareTo(item.toString()) : n;
        }
    }
}

