/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.category;

import java.lang.ref.WeakReference;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.category.Category;
import org.makagiga.commons.category.CategoryAction;
import org.makagiga.commons.category.CategoryList;
import org.makagiga.commons.category.CategoryManager;

public class CategoryMenu
extends MMenu {
    private CategoryList categoryList;
    private CategoryManager categoryManager;

    public CategoryMenu(CategoryManager categoryManager, String string) {
        super(UI._("Category"));
        this.categoryManager = TK.checkNull(categoryManager, "categoryManager");
        this.categoryList = new CategoryList(categoryManager, string);
        CategoryList categoryList = new CategoryList();
        categoryList.addAll(this.categoryList);
        categoryList.addAll(categoryManager.getCategorySet());
        for (Category category : categoryList) {
            boolean bl = this.categoryList.contains(category);
            boolean bl2 = !bl;
            this.addCheckBox(new Action(this, category, bl2), bl);
        }
        if (categoryManager.isEditable()) {
            if (!this.isEmpty()) {
                this.addSeparator();
            }
            this.add(new MAction(UI._("Edit Categories...")){

                @Override
                public void onAction() {
                    CategoryMenu.this.categoryManager.showDialog(this.getSourceWindow());
                }
            });
        }
    }

    public CategoryList getCategoryList() {
        return this.categoryList;
    }

    public CategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    protected void onCategoryChange(Category category) {
    }

    private static final class Action
    extends CategoryAction {
        private boolean add;
        private WeakReference<CategoryMenu> menuRef;

        @Override
        public void onAction() {
            CategoryMenu categoryMenu = (CategoryMenu)this.menuRef.get();
            if (categoryMenu == null) {
                return;
            }
            Category category = (Category)this.getData();
            if (this.add) {
                categoryMenu.categoryList.add(category);
            } else {
                categoryMenu.categoryList.remove(category);
            }
            categoryMenu.onCategoryChange(category);
        }

        private Action(CategoryMenu categoryMenu, Category category, boolean bl) {
            super(category);
            this.menuRef = TK.newWeakRef(categoryMenu);
            this.add = bl;
        }
    }
}

