/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.fx;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.fx.AbstractTransition;

public class ImageTransition
extends AbstractTransition {
    protected Effect effect;
    protected View destination;
    protected View source;

    public ImageTransition(Component component, Image image, Image image2, Effect effect) {
        super(component, effect.getDuration(component), effect.getFrames(component));
        this.source = new View(image);
        this.destination = new View(image2);
        this.effect = effect;
    }

    public Effect getEffect() {
        return this.effect;
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    @Override
    public void paintTransition(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.source.paint(graphics2D);
        this.destination.paint(graphics2D);
    }

    @Override
    public void startTransition(Component component) {
        if (this.effect != null) {
            this.effect.resetView(component, this.source, this.destination);
        }
        super.startTransition(component);
    }

    @Override
    public boolean updateTransitionFrame(Component component) {
        if (this.effect == null) {
            MLogger.debug("transition", "No transition effect");
            return false;
        }
        return this.effect.updateView(component, this.source, this.destination);
    }

    public static final class View {
        protected boolean useAlpha;
        protected boolean visible = true;
        protected Dimension size = new Dimension();
        protected float alpha = 1.0f;
        protected Image image;
        protected Point location = new Point();

        protected View(Image image) {
            this.image = image;
            if (image != null) {
                this.size.setSize(image.getWidth(null), image.getHeight(null));
            }
        }

        protected void paint(Graphics2D graphics2D) {
            if (this.image == null) {
                return;
            }
            if (!this.visible) {
                return;
            }
            Composite composite = graphics2D.getComposite();
            if (this.useAlpha) {
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(this.alpha));
            }
            graphics2D.drawImage(this.image, this.location.x, this.location.y, null);
            graphics2D.setComposite(composite);
        }

        protected void setLocation(int n, int n2) {
            this.location.setLocation(n, n2);
        }
    }

    public static class PushEffect
    extends MoveEffect {
        public PushEffect(MoveEffect.Direction direction) {
            super(direction);
        }

        @Override
        public boolean updateView(Component component, View view, View view2) {
            int n = this.getFrames(component);
            switch (this.direction) {
                case UP: {
                    return this.translate(false, view, view2, -n);
                }
                case DOWN: {
                    return this.translate(false, view, view2, n);
                }
                case LEFT: {
                    return this.translate(true, view, view2, -n);
                }
                case RIGHT: {
                    return this.translate(true, view, view2, n);
                }
            }
            throw new WTFError(this.direction);
        }

        private boolean translate(boolean bl, View view, View view2, int n) {
            int n2 = bl ? (view2.location.x += n) : (view2.location.y += n);
            if (n < 0 && n2 < 0 || n > 0 && n2 > 0) {
                view.visible = false;
                view2.location.setLocation(0, 0);
                return false;
            }
            if (bl) {
                view.location.x += n;
            } else {
                view.location.y += n;
            }
            return true;
        }
    }

    public static abstract class MoveEffect
    extends Effect {
        protected Direction direction;

        public MoveEffect(Direction direction) {
            this.direction = TK.checkNull(direction, "direction");
        }

        @Override
        public int getDuration(Component component) {
            return 500;
        }

        @Override
        public int getFrames(Component component) {
            switch (this.direction) {
                case UP: 
                case DOWN: {
                    return component.getHeight() / 10;
                }
                case LEFT: 
                case RIGHT: {
                    return component.getWidth() / 10;
                }
            }
            throw new WTFError(this.direction);
        }

        @Override
        public void resetView(Component component, View view, View view2) {
            view.setLocation(0, 0);
            view.visible = true;
            switch (this.direction) {
                case UP: {
                    view2.setLocation(0, view.size.height);
                    break;
                }
                case DOWN: {
                    view2.setLocation(0, -view2.size.height);
                    break;
                }
                case LEFT: {
                    view2.setLocation(view.size.width, 0);
                    break;
                }
                case RIGHT: {
                    view2.setLocation(-view2.size.width, 0);
                    break;
                }
                default: {
                    throw new WTFError(this.direction);
                }
            }
        }

        public static enum Direction {
            UP,
            DOWN,
            LEFT,
            RIGHT;

        }
    }

    public static class FadeEffect
    extends Effect {
        @Override
        public int getDuration(Component component) {
            return 500;
        }

        @Override
        public int getFrames(Component component) {
            return 9;
        }

        @Override
        public void resetView(Component component, View view, View view2) {
            view.useAlpha = true;
            view.alpha = 1.0f;
            view2.useAlpha = true;
            view2.alpha = 0.0f;
        }

        @Override
        public boolean updateView(Component component, View view, View view2) {
            view.alpha -= 0.1f;
            if (view.alpha < 0.0f) {
                view.alpha = 0.0f;
                view2.alpha = 1.0f;
                return false;
            }
            view2.alpha += 0.1f;
            return true;
        }
    }

    public static abstract class Effect {
        public abstract int getDuration(Component var1);

        public abstract int getFrames(Component var1);

        public abstract void resetView(Component var1, View var2, View var3);

        public abstract boolean updateView(Component var1, View var2, View var3);
    }
}

