/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.console;

import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.event.DocumentEvent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import org.makagiga.commons.Config;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDocumentAdapter;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.autocompletion.AutoCompletion;
import org.makagiga.commons.autocompletion.AutoCompletionData;
import org.makagiga.console.Console;
import org.makagiga.console.ConsoleCommand;

final class ConsoleCommandLine
extends MPanel {
    MLabel prompt;
    MSmallButton executeCommandButton;
    MTextField commandLine;
    private StringList suggestions;
    private final WeakReference<Console> consoleRef;

    ConsoleCommandLine(Console console) {
        super(5, 0);
        this.consoleRef = new WeakReference<Console>(console);
        this.commandLine = new MTextField(){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                ConsoleCommandLine.this.executeCommandButton.setEnabled(!this.isEmpty());
            }
        };
        MHighlighter.install(this.commandLine, new MHighlighter.UserHighlight<MTextField>(){

            @Override
            public void highlight(MHighlighter<MTextField> mHighlighter, MTextField mTextField, String string) {
                List<String> list;
                Console console = ConsoleCommandLine.this.getConsole();
                if (console.exclusiveCommand != null) {
                    console.exclusiveCommand.onHighlight(mHighlighter, string, null);
                    return;
                }
                try {
                    list = TK.parseArguments(string);
                }
                catch (ParseException parseException) {
                    mHighlighter.addHighlight(0, string.length(), MHighlighter.WARNING_COLOR);
                    return;
                }
                if (list.isEmpty()) {
                    return;
                }
                String string2 = list.get(0);
                ConsoleCommand consoleCommand = console.getCommand(string2);
                int n = string.indexOf(string2);
                if (consoleCommand != null) {
                    if (!consoleCommand.onHighlight(mHighlighter, string, list)) {
                        int n2 = n + string2.length();
                        mHighlighter.addHighlight(n, n2, MHighlighter.OK_COLOR);
                        boolean bl = false;
                        boolean bl2 = false;
                        int n3 = string.length();
                        block9: for (int i = n2; i < n3; ++i) {
                            char c = string.charAt(i);
                            switch (c) {
                                case '\\': {
                                    if (!bl2) continue block9;
                                    if (bl) {
                                        mHighlighter.addHighlight(i - 1, i + 1, MHighlighter.WARNING_COLOR, true);
                                        bl = false;
                                        continue block9;
                                    }
                                    bl = true;
                                    continue block9;
                                }
                                case '\"': {
                                    bl2 = true;
                                    if (!bl) continue block9;
                                    mHighlighter.addHighlight(i - 1, i + 1, MHighlighter.WARNING_COLOR, true);
                                    bl = false;
                                    continue block9;
                                }
                                default: {
                                    if (!bl) continue block9;
                                    switch (c) {
                                        case 'n': 
                                        case 't': {
                                            mHighlighter.addHighlight(i - 1, i + 1, MHighlighter.WARNING_COLOR, true);
                                        }
                                    }
                                    bl = false;
                                }
                            }
                        }
                    }
                } else if (list.size() >= 1) {
                    if (Config.getDefault().getRegisteredProperties().containsKey(string2)) {
                        mHighlighter.addHighlight(n, n + string2.length(), MHighlighter.OK_COLOR);
                    } else if (!TK.startsWith(string2, '=')) {
                        mHighlighter.addHighlight(n, n + string2.length(), MHighlighter.ERROR_COLOR);
                    }
                }
            }
        });
        this.commandLine.setAutoCompletion("console");
        this.commandLine.getDocument().addDocumentListener(new MDocumentAdapter<MTextField>(){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                ConsoleCommandLine.this.initSuggestions();
            }
        });
        this.commandLine.setEnterPressAction(new MAction(){

            @Override
            public void onAction() {
                ConsoleCommandLine.this.doExecute();
            }
        });
        this.commandLine.setToolTipText(UI._("Enter a command"));
        AutoCompletion autoCompletion = this.commandLine.getAutoCompletion();
        autoCompletion.setRenderer(new StaticAutoCompletionRenderer(console));
        autoCompletion.caseSensitive.yes();
        autoCompletion.limit.set(500);
        for (Iterator iterator : console) {
            autoCompletion.addItem(((ConsoleCommand)((Object)iterator)).getName());
        }
        Map<String, PropertyAccess<?>> map = TK.sortByKey(Config.getDefault().getRegisteredProperties(), null);
        for (String string : map.keySet()) {
            autoCompletion.addItem(string);
        }
        for (String string : map.keySet()) {
            autoCompletion.addItem("reset " + string);
        }
        this.commandLine.clear();
        this.prompt = MLabel.createFor(this.commandLine, null);
        this.executeCommandButton = new MSmallButton(MIcon.small("ui/ok"), UI._("Execute command")){

            @Override
            protected void onClick() {
                ConsoleCommandLine.this.doExecute();
            }
        };
        this.executeCommandButton.setEnabled(false);
        this.addWest(this.prompt);
        this.addCenter(this.commandLine);
        this.addEast(this.executeCommandButton);
    }

    private void doExecute() {
        String string = this.commandLine.getText();
        String string2 = this.prompt.getText();
        if (!string2.isEmpty()) {
            string2 = string2 + " ";
        }
        MutableAttributeSet mutableAttributeSet = Console.createColorAttr(MColor.BLACK);
        StyleConstants.setBackground(mutableAttributeSet, MColor.getDarker(MColor.WHITE));
        Console console = this.getConsole();
        console.getIO().printLine(mutableAttributeSet, string2 + string);
        console.executeCommand(string);
    }

    private Console getConsole() {
        return (Console)this.consoleRef.get();
    }

    private void initSuggestions() {
        if (this.suggestions == null) {
            this.suggestions = new StringList();
            for (Object object : this.getConsole()) {
                for (String string : ((ConsoleCommand)object).getAutoCompletionList()) {
                    this.suggestions.add(((ConsoleCommand)object).getName() + " " + string);
                }
            }
            AutoCompletion autoCompletion = this.commandLine.getAutoCompletion();
            if (autoCompletion != null) {
                for (Object object : this.suggestions) {
                    autoCompletion.addItem((String)object);
                }
            }
        }
    }

    private static final class StaticAutoCompletionRenderer
    implements AutoCompletion.Renderer {
        private final WeakReference<Console> consoleRef;

        @Override
        public void onRender(MRenderer<AutoCompletionData.Item> mRenderer, AutoCompletionData.Item item) {
            Console console = (Console)this.consoleRef.get();
            Icon icon = null;
            if (console != null) {
                try {
                    ConsoleCommand consoleCommand;
                    String string = item.toString().trim();
                    List<String> list = TK.parseArguments(string);
                    if (!list.isEmpty() && (consoleCommand = console.getCommand(list.get(0))) != null) {
                        icon = consoleCommand.getSmallIcon();
                        if (consoleCommand.getName().equals(string)) {
                            mRenderer.setText(string + " - " + consoleCommand.getDescription());
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            mRenderer.setIcon(icon);
        }

        private StaticAutoCompletionRenderer(Console console) {
            this.consoleRef = TK.newWeakRef(console);
        }
    }
}

