/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.db;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Timestamp;
import java.util.Map;
import javax.swing.JComponent;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.DateProperty;
import org.makagiga.commons.DoubleProperty;
import org.makagiga.commons.FloatProperty;
import org.makagiga.commons.IntegerProperty;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MDateSpinner;
import org.makagiga.commons.MEditorPane;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MSeparator;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MText;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.NumberProperty;
import org.makagiga.commons.Property;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.StringProperty;
import org.makagiga.commons.TK;
import org.makagiga.commons.swing.Input;
import org.makagiga.db.DBException;
import org.makagiga.db.DBRecord;
import org.makagiga.db.DBTableModel;
import org.makagiga.db.DBView;
import org.makagiga.form.PropertyPanel;

public class DBRecordPanel<M extends DBTableModel>
extends PropertyPanel
implements DBView.ModelView<M> {
    private DBRecord record;
    private M model;
    private final Map<Integer, PropertyAccess<?>> columnMap = TK.newLinkedHashMap();

    public DBRecordPanel() {
        super(10);
        this.setAutoUpdateModel(false);
        this.setHighlightFocusedEditor(true);
    }

    public DBRecord updatedRecord() {
        boolean bl;
        if (this.columnMap.isEmpty()) {
            return null;
        }
        if (this.record == null) {
            this.record = new DBRecord((DBTableModel)this.model);
            bl = false;
        } else {
            bl = true;
        }
        this.updateModel();
        for (Map.Entry<Integer, PropertyAccess<?>> entry : this.columnMap.entrySet()) {
            Serializable serializable;
            Property property;
            int n = entry.getKey();
            PropertyAccess<?> propertyAccess = entry.getValue();
            if (n == ((DBTableModel)this.model).getIdIndex() && !bl) continue;
            if (propertyAccess instanceof BlobProperty) {
                property = (BlobProperty)propertyAccess;
                if (!((BlobProperty)property).isValid()) continue;
                serializable = (File)property.get();
                MLogger.XXX("UPDATE BLOB RECORD: " + serializable);
                this.record.setObject(n, serializable);
                continue;
            }
            if (propertyAccess instanceof ClobProperty) {
                property = (ClobProperty)propertyAccess;
                serializable = (ClobScrollPane)this.getEditorView(propertyAccess);
                DBRecord.LargeText largeText = (DBRecord.LargeText)property.get();
                MLogger.XXX("UPDATE CLOB RECORD: " + largeText);
                this.record.setObject(n, largeText.isEmpty() ? null : largeText);
                continue;
            }
            if (propertyAccess instanceof DateProperty) {
                property = (DateProperty)propertyAccess;
                this.record.setObject(n, new Timestamp(((MDate)property.get()).getTime()));
                continue;
            }
            this.record.setObject(n, propertyAccess.get());
        }
        return this.record;
    }

    @Override
    public DBRecord getCurrentRecord() {
        return this.record;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public void setModel(M m, DBRecord dBRecord) {
        this.columnMap.clear();
        this.removeAll();
        this.record = dBRecord;
        this.model = (DBTableModel)TK.checkNull(m, "model");
        DBRecord dBRecord2 = dBRecord == null ? new DBRecord((DBTableModel)m) : dBRecord;
        int n = ((AbstractListTableModel)m).getColumnCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Class<?> clazz = ((AbstractListTableModel)m).getColumnClass(i);
            Object object3 = null;
            if (clazz == BigDecimal.class) {
                object3 = new NumberProperty<BigDecimal>(dBRecord2.isNull(i) ? BigDecimal.ZERO : dBRecord2.getBigDecimal(i));
            } else if (clazz == Blob.class) {
                object3 = new BlobProperty();
            } else if (clazz == Boolean.class) {
                object3 = new BooleanProperty(dBRecord2.isNull(i) ? false : dBRecord2.getBoolean(i));
            } else if (clazz == Clob.class) {
                if (dBRecord != null) {
                    try {
                        object2 = ((DBTableModel)m).getLargeText(dBRecord2, i);
                        object3 = new ClobProperty((String)(object2 == null ? "" : object2));
                    }
                    catch (DBException dBException) {
                        MLogger.exception(dBException);
                        object3 = new ClobProperty();
                    }
                } else {
                    object3 = new ClobProperty();
                }
            } else if (clazz == Double.class) {
                object3 = new DoubleProperty(dBRecord2.isNull(i) ? 0.0 : dBRecord2.getNumber(i).doubleValue());
            } else if (clazz == Float.class) {
                object3 = new FloatProperty(dBRecord2.isNull(i) ? 0.0f : dBRecord2.getNumber(i).floatValue());
            } else if (clazz == Integer.class) {
                object3 = new IntegerProperty(dBRecord2.isNull(i) ? 0 : dBRecord2.getNumber(i).intValue());
            } else if (clazz == String.class) {
                object3 = new StringProperty(dBRecord2.isNull(i) ? "" : dBRecord2.getString(i));
            } else if (clazz == Timestamp.class) {
                object2 = new DateProperty();
                ((DateProperty)object2).setTime(dBRecord2.isNull(i) ? 0L : dBRecord2.getTimestamp(i).getTime());
                object3 = object2;
            } else {
                MLogger.error("db", "Unknown column class: %s", clazz);
            }
            if (object3 == null) continue;
            object2 = ((AbstractListTableModel)m).getColumnName(i);
            JComponent jComponent = this.bind((PropertyAccess<?>)object3, (String)object2);
            Object t = DBRecordPanel.getWrappedView(jComponent);
            if (t instanceof MText.TextFieldExtensions) {
                object = "db-" + TK.toLowerCase(((DBTableModel)m).getColumnID(i));
                ((MText.TextFieldExtensions)MText.TextFieldExtensions.class.cast(t)).setAutoCompletion((String)object);
            }
            if (i == ((DBTableModel)m).getIdIndex()) {
                ((JComponent)t).setEnabled(false);
                this.addGap();
                this.add(MSeparator.createHorizontal());
            }
            if (object3 instanceof DateProperty) {
                object = (MDateSpinner)t;
                ((MDateSpinner)object).setSimpleFormat("yyyy-MM-dd HH:mm:ss");
            }
            this.columnMap.put(i, (PropertyAccess<?>)object3);
        }
    }

    @Override
    public void readConfig(Config config, Config config2, Config.GlobalEntry globalEntry) {
    }

    @Override
    public void writeConfig(Config config, Config config2, Config.GlobalEntry globalEntry) {
    }

    @Override
    protected JComponent createCustomEditor(PropertyAccess<?> propertyAccess, String string, Class<? extends JComponent> clazz) {
        if (propertyAccess instanceof BlobProperty) {
            return new BlobEditor(string);
        }
        if (propertyAccess instanceof ClobProperty) {
            return new ClobEditor(((Object)propertyAccess).toString(), string);
        }
        return null;
    }

    @Override
    protected boolean updateCustomModel(PropertyAccess<?> propertyAccess, JComponent jComponent) {
        if (propertyAccess instanceof BlobProperty) {
            MLogger.XXX("UPDATE BLOB MODEL: " + propertyAccess.get());
            BlobProperty blobProperty = (BlobProperty)propertyAccess;
            MTextField mTextField = (MTextField)jComponent;
            File file = new File(mTextField.getText());
            boolean bl = file.exists();
            blobProperty.set(bl ? file : null);
            blobProperty.setValid(bl);
            return true;
        }
        if (propertyAccess instanceof ClobProperty) {
            MLogger.XXX("UPDATE CLOB MODEL: " + propertyAccess.get());
            ClobProperty clobProperty = (ClobProperty)propertyAccess;
            ClobScrollPane clobScrollPane = (ClobScrollPane)jComponent;
            clobProperty.set(new DBRecord.LargeText(clobScrollPane.getEditorPane().getText()));
            return true;
        }
        return false;
    }

    @Override
    protected boolean updateCustomView(PropertyAccess<?> propertyAccess, JComponent jComponent) {
        if (propertyAccess instanceof BlobProperty) {
            MTextField mTextField = (MTextField)jComponent;
            mTextField.setText(((Object)propertyAccess).toString());
            return true;
        }
        if (propertyAccess instanceof ClobProperty) {
            ClobScrollPane clobScrollPane = (ClobScrollPane)jComponent;
            clobScrollPane.getEditorPane().setText(((Object)propertyAccess).toString());
            clobScrollPane.getEditorPane().setModified(false, null);
            return true;
        }
        return false;
    }

    void saveAutoCompletion() {
        for (Component component : this.getComponents()) {
            Object t;
            if (!(component instanceof JComponent) || !((t = DBRecordPanel.getWrappedView((JComponent)component)) instanceof MText.TextFieldExtensions)) continue;
            ((MText.TextFieldExtensions)MText.TextFieldExtensions.class.cast(t)).saveAutoCompletion();
        }
    }

    private static final class ClobProperty
    extends Property<DBRecord.LargeText> {
        @Override
        public Class<DBRecord.LargeText> getType() {
            return DBRecord.LargeText.class;
        }

        private ClobProperty() {
            super(new DBRecord.LargeText(""));
        }

        private ClobProperty(String string) {
            super(new DBRecord.LargeText(string));
        }
    }

    private static final class ClobScrollPane
    extends MScrollPane {
        @Override
        public Dimension getMaximumSize() {
            Dimension dimension = super.getMaximumSize();
            return new Dimension(dimension.width, 200);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width, 100);
        }

        @Override
        public boolean requestFocusInWindow() {
            Component component = this.getViewport().getView();
            if (component != null) {
                return component.requestFocusInWindow();
            }
            return super.requestFocusInWindow();
        }

        private ClobScrollPane(String string) {
            MEditorPane mEditorPane = MEditorPane.newPlainText(string, true);
            this.setViewportView(mEditorPane);
        }

        private MEditorPane getEditorPane() {
            return (MEditorPane)this.getViewport().getView();
        }
    }

    private static final class ClobEditor
    extends PropertyPanel.VerticalWrapper<ClobScrollPane> {
        private ClobEditor(String string, String string2) {
            super(new ClobScrollPane(string), string2);
        }
    }

    private static final class BlobProperty
    extends Property<File> {
        private boolean valid;

        @Override
        public Class<File> getType() {
            return File.class;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean bl) {
            this.valid = bl;
        }

        private BlobProperty() {
        }
    }

    private static final class BlobEditor
    extends PropertyPanel.HorizontalWrapper<MTextField> {
        private BlobEditor(String string) {
            super(new MTextField(), string, true);
            this.addEast(new MSmallButton(MActionInfo.OPEN){

                @Override
                protected void onClick() {
                    BlobEditor.this.selectFile();
                }
            });
        }

        private void selectFile() {
            File file = Input.getImageFile(this.getWindowAncestor());
            if (file != null) {
                ((MTextField)this.getView()).setText(file.getPath());
            }
        }
    }
}

