/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.ConfigEntry;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.FS;
import org.makagiga.commons.FloatProperty;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.ImageBorder;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDesktopPane;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.PlatformConfig;
import org.makagiga.commons.SafeMode;
import org.makagiga.commons.StringProperty;
import org.makagiga.commons.TK;
import org.makagiga.commons.TriBoolean;
import org.makagiga.commons.UI;
import org.makagiga.commons.fx.Blend;
import org.makagiga.desktop.DesktopSettings;
import org.makagiga.desktop.Pager;
import org.makagiga.desktop.Widget;
import org.makagiga.desktop.WidgetInternalFrame;
import org.makagiga.desktop.WidgetPlugin;
import org.makagiga.desktop.ui.WidgetDesktopPaneUI;
import org.makagiga.plugins.PluginAction;
import org.makagiga.plugins.PluginDownloader;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginType;

public final class Desktop
extends MDesktopPane<WidgetInternalFrame>
implements Focusable,
MApplication.ShutDownListener {
    @ConfigEntry(value="Desktop.backgroundColor")
    public static final ColorProperty backgroundColor = new ColorProperty(MColor.SKY_BLUE);
    @ConfigEntry(value="Desktop.backgroundImage")
    @PlatformConfig
    public static final StringProperty backgroundImage = new StringProperty();
    @Deprecated
    public static final FloatProperty backgroundImageAlpha = new FloatProperty(1.0f);
    @ConfigEntry(value="Desktop.backgroundImagePosition")
    @PlatformConfig
    public static final EnumProperty<ImageBorder.Position> backgroundImagePosition = EnumProperty.create(ImageBorder.Position.CENTERED, ImageBorder.Position.class);
    @ConfigEntry(value="Widgets.painterType")
    public static final EnumProperty<WidgetDesktopPaneUI.PainterType> widgetsPainterType = EnumProperty.create(WidgetDesktopPaneUI.PainterType.GLASS, WidgetDesktopPaneUI.PainterType.class);
    public static final String LOCKED_PROPERTY = "locked";
    private static Desktop _instance;
    private final ImageBorder imageBorder = new ImageBorder((Image)null, (ImageBorder.Position)((Object)backgroundImagePosition.getDefaultValue()));
    private PropertyChangeListener propertyChangeListener;
    private String desktopText;
    private volatile WallpaperUpdater wallpaperUpdater;

    public Desktop() {
        MDesktopPane.MDesktopManager mDesktopManager = (MDesktopPane.MDesktopManager)this.getDesktopManager();
        mDesktopManager.setSnapEnabled(true);
        this.updateBackground(false, null);
        this.addMouseListener(new MMouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (1.isLeft(mouseEvent) && 1.isDoubleClick(mouseEvent) && !Desktop.this.isLocked()) {
                    TriBoolean triBoolean = TriBoolean.UNDEFINED;
                    int n = Pager.getInstance().getCurrent();
                    for (WidgetInternalFrame widgetInternalFrame : Desktop.this) {
                        try {
                            Widget widget = widgetInternalFrame.getWidget();
                            if (widget != null && widget.getDesktopNumber() != n) continue;
                            if (triBoolean.isUndefined()) {
                                triBoolean = TriBoolean.from(!widgetInternalFrame.isIcon());
                            }
                            widgetInternalFrame.setIcon(triBoolean.isTrue());
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                    mouseEvent.consume();
                }
            }

            @Override
            public void popupTrigger(MouseEvent mouseEvent) {
                MMenu mMenu = new MMenu();
                mMenu.setSplitMenu(true);
                MMenu mMenu2 = new MMenu(UI._("Add Widget"), "ui/newfile");
                if (Desktop.this.isLocked()) {
                    mMenu2.setEnabled(false);
                } else {
                    Desktop.this.createNewWidgetMenu(mMenu2, mouseEvent.getPoint());
                }
                mMenu.add(mMenu2);
                PluginManager.updateMenu(mMenu, "DESKTOP_MENU", true);
                Desktop.this.updateViewMenu(mMenu, true);
                mMenu.showPopup(mouseEvent);
            }
        });
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                if (Desktop.this.isLocked()) {
                    return false;
                }
                return this.findHandler(transferSupport) != null;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                WidgetPlugin widgetPlugin = this.findHandler(transferSupport);
                boolean bl = false;
                if (widgetPlugin != null && !(bl = widgetPlugin.importData(transferSupport))) {
                    MStatusBar.error(UI._("Import failed"));
                }
                return bl;
            }

            private WidgetPlugin findHandler(TransferHandler.TransferSupport transferSupport) {
                for (PluginInfo pluginInfo : PluginType.WIDGET.get()) {
                    WidgetPlugin widgetPlugin = (WidgetPlugin)pluginInfo.getPluggable();
                    if (!widgetPlugin.canImport(transferSupport)) continue;
                    return widgetPlugin;
                }
                return null;
            }
        });
        MApplication.addShutDownListener(this);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ((propertyChangeEvent.getSource() == backgroundColor || propertyChangeEvent.getSource() == widgetsPainterType) && propertyChangeEvent.getPropertyName().equals("value")) {
                    for (WidgetInternalFrame widgetInternalFrame : Desktop.this) {
                        Widget widget = widgetInternalFrame.getWidget();
                        if (widget == null) continue;
                        widget.updateWidgetUI();
                    }
                }
            }
        };
        backgroundColor.addPropertyChangeListener(this.propertyChangeListener);
        widgetsPainterType.addPropertyChangeListener(this.propertyChangeListener);
    }

    public Widget addWidget(String string, Point point) {
        return this.addWidget(string, point, true);
    }

    public Widget addWidget(String string, Point point, boolean bl) {
        String string2 = string + "-";
        Widget widget = null;
        for (int i = 0; i < 1000; ++i) {
            if (!this.isSessionFree(string2 + i)) continue;
            widget = this.createWidget(string, string2 + i, point, bl);
            if (widget == null) break;
            widget.setDesktopNumber(Pager.getInstance().getCurrent());
            Config config = widget.getConfig();
            widget.saveComponentState(config);
            config.sync();
            break;
        }
        return widget;
    }

    public void createNewWidgetMenu(MMenu mMenu, Point point) {
        mMenu.setSplitMenu(true);
        PluginManager.Table table = PluginType.WIDGET.get();
        if (table.isEmpty()) {
            mMenu.addTitle(UI._("No Widgets"));
        } else {
            for (PluginInfo pluginInfo : table) {
                mMenu.add(new NewWidgetAction(this, pluginInfo, point));
            }
        }
        mMenu.addSeparator();
        PluginManager.updateMenu(mMenu, "WIDGETS_MENU", true);
        MAction mAction = new MAction(UI._("Get More Widgets..."), "ui/download"){

            @Override
            public void onAction() {
                PluginDownloader.getMorePlugins(this.getSourceWindow(), PluginType.WIDGET);
            }
        };
        mMenu.add(mAction);
    }

    public String getDesktopText() {
        return this.desktopText;
    }

    public void setDesktopText(String string) {
        this.desktopText = string;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(UI.createEmptyBorder(0), string, 3, 4, new Font("Dialog", 0, UI.getDefaultFontSize() - 1), MColor.getContrast((Color)backgroundColor.get()));
        this.setBorder(BorderFactory.createCompoundBorder(titledBorder, this.imageBorder));
    }

    @Deprecated
    public static synchronized Desktop getInstance() {
        if (_instance == null) {
            _instance = new Desktop();
        }
        return _instance;
    }

    public Widget getSelectedWidget() {
        WidgetInternalFrame widgetInternalFrame = (WidgetInternalFrame)this.getSelectedFrame();
        return widgetInternalFrame == null ? null : widgetInternalFrame.getWidget();
    }

    @SafeMode
    public void restoreSession() {
        File file = FS.makeConfigFile("desktop");
        for (File file2 : FS.listFiles(file)) {
            String string = file2.getName();
            try {
                MLogger.debug("desktop", "Creating widget: %s", string);
                this.createWidget(string.substring(0, string.lastIndexOf(125) + 1), string, null, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MLogger.exception(illegalArgumentException);
                MLogger.error("desktop", "Invalid plugin ID: \"%s\"", new File(file, string));
            }
        }
        Config config = Config.getDefault();
        Pager.getInstance().readConfig(config);
        this.setLocked(config.read("Desktop.locked", false));
    }

    public void saveSession() {
        for (WidgetInternalFrame widgetInternalFrame : this) {
            Widget widget = widgetInternalFrame.getWidget();
            widget.saveSession();
        }
        Config config = Config.getDefault();
        Pager.getInstance().writeConfig(config);
        config.write("Desktop.locked", this.isLocked());
    }

    @Override
    public void setLocked(boolean bl) {
        boolean bl2 = this.isLocked();
        super.setLocked(bl);
        for (WidgetInternalFrame widgetInternalFrame : this) {
            widgetInternalFrame.setClosable(!bl);
            widgetInternalFrame.setIconifiable(!bl);
        }
        this.firePropertyChange(LOCKED_PROPERTY, bl2, bl);
    }

    public void shutDown() {
        if (this.propertyChangeListener != null) {
            backgroundColor.removePropertyChangeListener(this.propertyChangeListener);
            widgetsPainterType.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        for (WidgetInternalFrame widgetInternalFrame : this) {
            Widget widget = widgetInternalFrame.getWidget();
            widget.onShutDown();
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new WidgetDesktopPaneUI(this));
    }

    public void updateViewMenu(MMenu mMenu, boolean bl) {
        if (((Boolean)Kiosk.actionSettings.get()).booleanValue()) {
            if (bl) {
                mMenu.addSeparator();
            }
            mMenu.add(new LockAction(this));
            mMenu.add(new DesktopSettings.Action(this));
        }
    }

    @Override
    public void focus() {
        this.requestFocusInWindow();
        Widget widget = this.getSelectedWidget();
        if (widget != null) {
            widget.select();
        }
    }

    @Override
    public void shutDown(MApplication.ShutDownEvent shutDownEvent) {
        this.shutDown();
    }

    @Override
    protected void onEndDraggingFrame(JComponent jComponent) {
        Widget widget = this.getWidget(jComponent);
        if (widget != null) {
            Config config = widget.getConfig();
            widget.saveComponentState(config);
            config.sync();
        }
    }

    @Override
    protected void onEndResizingFrame(JComponent jComponent) {
        Widget widget = this.getWidget(jComponent);
        if (widget != null) {
            Config config = widget.getConfig();
            widget.saveComponentState(config);
            config.sync();
        }
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        MDesktopPane.MDesktopManager mDesktopManager = (MDesktopPane.MDesktopManager)this.getDesktopManager();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        mDesktopManager.paintBackground(this, graphics2D);
        graphics2D.dispose();
        super.paintChildren(graphics);
    }

    private Widget createWidget(String string, String string2, Point point, boolean bl) {
        try {
            Widget widget = (Widget)WidgetPlugin.createByID(string, PluginType.WIDGET);
            if (widget != null) {
                widget.setSessionID(string2);
                WidgetInternalFrame widgetInternalFrame = (WidgetInternalFrame)widget.getWidgetPeer();
                widgetInternalFrame.setClosable(!this.isLocked());
                this.add(widgetInternalFrame);
                if (point == null) {
                    int n = ((MDesktopPane.MDesktopManager)MDesktopPane.MDesktopManager.class.cast(this.getDesktopManager())).getSnapSize();
                    point = new Point(n, n);
                    HashSet<Point> hashSet = new HashSet<Point>();
                    for (WidgetInternalFrame widgetInternalFrame2 : this) {
                        if (widgetInternalFrame2.isIcon()) continue;
                        hashSet.add(widgetInternalFrame2.getLocation());
                    }
                    while (hashSet.contains(point)) {
                        point.translate(20, 20);
                    }
                }
                widget.setDefaultLocation(point);
                if (bl) {
                    widget.restoreSession();
                }
            }
            return widget;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            PluginInfo pluginInfo = PluginManager.getInstance().getByID(string);
            MMessage.error(null, throwable, UI._("Could not create widget: {0}", pluginInfo));
            return null;
        }
    }

    private Widget getWidget(JComponent jComponent) {
        JInternalFrame.JDesktopIcon jDesktopIcon;
        if (jComponent instanceof WidgetInternalFrame) {
            return ((WidgetInternalFrame)WidgetInternalFrame.class.cast(jComponent)).getWidget();
        }
        if (jComponent instanceof JInternalFrame.JDesktopIcon && (jDesktopIcon = (JInternalFrame.JDesktopIcon)jComponent).getInternalFrame() instanceof WidgetInternalFrame) {
            return ((WidgetInternalFrame)WidgetInternalFrame.class.cast(jDesktopIcon.getInternalFrame())).getWidget();
        }
        return null;
    }

    private boolean isSessionFree(String string) {
        for (WidgetInternalFrame widgetInternalFrame : this) {
            Widget widget = widgetInternalFrame.getWidget();
            if (!widget.getSessionID().equals(string)) continue;
            return false;
        }
        return true;
    }

    void updateBackground(boolean bl, Window window) {
        if (backgroundImage.isEmpty()) {
            this.imageBorder.setImage(null);
        } else {
            if (this.wallpaperUpdater != null) {
                this.wallpaperUpdater.cancel(true);
            }
            this.wallpaperUpdater = new WallpaperUpdater(window);
            this.wallpaperUpdater.execute();
        }
        if (bl && backgroundImage.isEmpty()) {
            Blend.animateBackground(this, null, (Color)backgroundColor.get());
        } else {
            this.setBackground((Color)backgroundColor.get());
        }
        this.setDesktopText(this.desktopText);
    }

    private final class WallpaperUpdater
    extends SwingWorker<BufferedImage, Object> {
        private final WeakReference<Window> windowRef;

        @Override
        protected BufferedImage doInBackground() throws Exception {
            BufferedImage bufferedImage;
            if (backgroundImage.isEmpty()) {
                return null;
            }
            File file = new File((String)backgroundImage.get());
            if (!file.isAbsolute()) {
                file = new File(FS.getPlatformConfigPath(file.getPath()));
            }
            if ((bufferedImage = ImageIO.read(file)) == null || this.isCancelled()) {
                return null;
            }
            BufferedImage bufferedImage2 = UI.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), true);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            Desktop.this.imageBorder.setImage(bufferedImage2);
            Desktop.this.imageBorder.setPosition((ImageBorder.Position)((Object)backgroundImagePosition.get()));
            return bufferedImage2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            this.updateComponents(true);
            Desktop.this.wallpaperUpdater = null;
            if (this.isCancelled()) {
                return;
            }
            try {
                BufferedImage bufferedImage = (BufferedImage)this.get();
                if (bufferedImage == null) {
                    this.clearWallpaper();
                }
            }
            catch (ExecutionException executionException) {
                MLogger.exception(executionException);
                this.clearWallpaper();
            }
            catch (InterruptedException interruptedException) {
                MLogger.exception(interruptedException);
            }
            finally {
                Desktop.this.repaint();
            }
        }

        private WallpaperUpdater(Window window) {
            this.windowRef = TK.newWeakRef(window);
            this.updateComponents(false);
        }

        private void clearWallpaper() {
            backgroundImage.set(null);
        }

        private void updateComponents(boolean bl) {
            Window window = (Window)this.windowRef.get();
            if (window instanceof MDialog) {
                MButton mButton;
                MDialog mDialog = (MDialog)window;
                MButton mButton2 = mDialog.getOKButton();
                if (mButton2 != null) {
                    mButton2.setEnabled(bl);
                }
                if ((mButton = mDialog.getApplyButton()) != null) {
                    mButton.setEnabled(bl);
                }
            }
        }
    }

    private static final class NewWidgetAction
    extends PluginAction {
        private final Point widgetLocation;
        private final WeakReference<Desktop> desktopRef;

        @Override
        public void onAction() {
            PluginInfo pluginInfo;
            Desktop desktop = (Desktop)this.desktopRef.get();
            Widget widget = desktop.addWidget((pluginInfo = (PluginInfo)this.getData()).getID(), this.widgetLocation);
            if (widget == null) {
                MStatusBar.error(UI._("Could not create widget: {0}", pluginInfo));
            } else {
                widget.getWidgetPeer().select();
            }
        }

        private NewWidgetAction(Desktop desktop, PluginInfo pluginInfo, Point point) {
            super(pluginInfo);
            this.desktopRef = new WeakReference<Desktop>(desktop);
            this.widgetLocation = point;
        }
    }

    private static final class LockAction
    extends MDataAction.Weak<Desktop> {
        @Override
        public void onAction() {
            Desktop desktop;
            desktop.setLocked(!(desktop = (Desktop)this.get()).isLocked());
        }

        private LockAction(Desktop desktop) {
            super(desktop, MActionInfo.LOCK.getText());
            this.updateProperties();
            desktop.addPropertyChangeListener(Desktop.LOCKED_PROPERTY, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LockAction.this.updateProperties();
                }
            });
        }

        private void updateProperties() {
            this.setActionInfo(((Desktop)this.get()).isLocked() ? MActionInfo.UNLOCK : MActionInfo.LOCK);
        }
    }
}

