/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.io.File;
import javax.swing.Icon;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MInternalFrame;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.UI;
import org.makagiga.desktop.SessionEvent;
import org.makagiga.desktop.SessionListener;
import org.makagiga.desktop.WidgetInternalFrame;
import org.makagiga.desktop.WidgetPeer;
import org.makagiga.plugins.PluginInfo;

public class Widget
extends MPanel
implements WidgetPeer {
    private boolean confirmClose = true;
    private boolean packed;
    private boolean toolBarEnabled;
    private Config _config;
    private Dimension defaultSize = new Dimension(256, 256);
    private File workingDirectory;
    private int desktopNumber;
    private MToolBar toolBar;
    private PluginInfo pluginInfo;
    private final Point defaultLocation = new Point();
    private String sessionID;
    private WidgetPeer widgetPeer;

    public Widget() {
        this(null, (Icon)null);
    }

    public Widget(Icon icon) {
        this(null, icon);
    }

    public Widget(String string) {
        this(string, (Icon)null);
    }

    public Widget(String string, Icon icon) {
        this.widgetPeer = new WidgetInternalFrame(this, string, icon);
    }

    public Widget(String string, String string2) {
        this(string, MIcon.stock(string2, 16));
    }

    public Widget(PluginInfo pluginInfo) {
        this(pluginInfo.toString(), pluginInfo.getIcon());
        this.pluginInfo = pluginInfo;
    }

    public final void addSessionListener(SessionListener sessionListener) {
        this.listenerList.add(SessionListener.class, sessionListener);
    }

    public final SessionListener[] getSessionListeners() {
        return (SessionListener[])this.listenerList.getListeners(SessionListener.class);
    }

    public final void removeSessionListener(SessionListener sessionListener) {
        this.listenerList.remove(SessionListener.class, sessionListener);
    }

    @Override
    public final void close() {
        this.widgetPeer.close();
    }

    @Override
    public final void doDefaultCloseAction() {
        this.widgetPeer.doDefaultCloseAction();
    }

    public final boolean getConfirmClose() {
        return this.confirmClose;
    }

    public final void setConfirmClose(boolean bl) {
        this.confirmClose = bl;
    }

    public final Dimension getDefaultSize() {
        return this.defaultSize;
    }

    public final void setDefaultSize(Dimension dimension) {
        this.defaultSize = dimension;
    }

    public final void setDefaultSize(int n, int n2) {
        this.defaultSize = new Dimension(n, n2);
    }

    public final int getDesktopNumber() {
        return this.desktopNumber;
    }

    public void setDesktopNumber(int n) {
        if (n != this.desktopNumber) {
            this.desktopNumber = n;
            if (this.widgetPeer instanceof WidgetInternalFrame) {
                ((WidgetInternalFrame)WidgetInternalFrame.class.cast(this.widgetPeer)).updateVirtualDesktop();
            }
        }
    }

    @Override
    public final Icon getIcon() {
        return this.widgetPeer.getIcon();
    }

    @Override
    public final void setIcon(Icon icon) {
        this.widgetPeer.setIcon(icon);
    }

    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    public final String getSessionID() {
        return this.sessionID;
    }

    public final void setSessionID(String string) {
        this.sessionID = string;
    }

    @Override
    @Deprecated
    public final Dimension getSize() {
        if (this.widgetPeer == null) {
            return super.getSize();
        }
        return this.widgetPeer.getSize();
    }

    @Override
    @Deprecated
    public final void setSize(Dimension dimension) {
        if (this.widgetPeer == null) {
            super.setSize(dimension);
            return;
        }
        this.widgetPeer.setSize(dimension);
        this.packed = false;
    }

    @Override
    @Deprecated
    public final void setSize(int n, int n2) {
        if (this.widgetPeer == null) {
            super.setSize(n, n2);
            return;
        }
        this.widgetPeer.setSize(n, n2);
        this.packed = false;
    }

    @Override
    @Deprecated
    public final Point getLocation() {
        if (this.widgetPeer == null) {
            return super.getLocation();
        }
        return this.widgetPeer.getLocation();
    }

    @Override
    @Deprecated
    public final void setLocation(Point point) {
        if (this.widgetPeer == null) {
            super.setLocation(point);
        } else {
            this.widgetPeer.setLocation(point);
        }
    }

    @Override
    @Deprecated
    public final void setLocation(int n, int n2) {
        if (this.widgetPeer == null) {
            super.setLocation(n, n2);
        } else {
            this.widgetPeer.setLocation(n, n2);
        }
    }

    @Override
    public final String getTitle() {
        return this.widgetPeer.getTitle();
    }

    @Override
    public final void setTitle(String string) {
        this.widgetPeer.setTitle(string);
    }

    public WidgetPeer getWidgetPeer() {
        return this.widgetPeer;
    }

    public void setWidgetPeer(WidgetPeer widgetPeer) {
        if (widgetPeer != null && this.widgetPeer != null) {
            widgetPeer.setBackgroundDraggable(this.widgetPeer.isBackgroundDraggable());
            widgetPeer.setIcon(this.widgetPeer.getIcon());
            widgetPeer.setLocation(this.widgetPeer.getLocation());
            widgetPeer.setResizable(this.widgetPeer.isResizable());
            widgetPeer.setSettingsActionVisible(this.widgetPeer.isSettingsActionVisible());
            widgetPeer.setShaped(this.widgetPeer.isShaped());
            widgetPeer.setSize(this.widgetPeer.getSize());
            widgetPeer.setTitle(this.widgetPeer.getTitle());
            widgetPeer.setVisible(this.widgetPeer.isVisible());
        }
        this.widgetPeer = widgetPeer;
    }

    @Override
    @Deprecated
    public final int getWidth() {
        if (this.widgetPeer == null) {
            return super.getWidth();
        }
        return this.widgetPeer.getWidth();
    }

    @Override
    @Deprecated
    public final int getHeight() {
        if (this.widgetPeer == null) {
            return super.getHeight();
        }
        return this.widgetPeer.getHeight();
    }

    public final synchronized Config getConfig() {
        if (this._config == null) {
            if (this.sessionID == null) {
                return null;
            }
            this._config = new Config(FS.makePath(this.getWorkingDirectory().getPath(), ".properties"));
        }
        return this._config;
    }

    public final synchronized File getWorkingDirectory() {
        if (this.workingDirectory == null) {
            String string = FS.makeConfigPath("desktop");
            this.workingDirectory = new File(string, this.getSessionID());
            this.workingDirectory.mkdirs();
        }
        return this.workingDirectory;
    }

    @Override
    public final boolean isBackgroundDraggable() {
        return this.widgetPeer.isBackgroundDraggable();
    }

    @Override
    public final void setBackgroundDraggable(boolean bl) {
        this.widgetPeer.setBackgroundDraggable(bl);
    }

    public boolean isDropShadowSupported() {
        return !this.isShaped();
    }

    @Override
    public final boolean isResizable() {
        return this.widgetPeer.isResizable();
    }

    @Override
    public final void setResizable(boolean bl) {
        this.widgetPeer.setResizable(bl);
    }

    @Override
    public boolean isSettingsActionVisible() {
        return this.widgetPeer.isSettingsActionVisible();
    }

    @Override
    public void setSettingsActionVisible(boolean bl) {
        this.widgetPeer.setSettingsActionVisible(bl);
    }

    @Override
    public final boolean isShaped() {
        return this.widgetPeer.isShaped();
    }

    @Override
    public final void setShaped(boolean bl) {
        this.setOpaque(!bl);
        this.widgetPeer.setShaped(bl);
    }

    public boolean isToolBarEnabled() {
        return this.toolBarEnabled;
    }

    public void setToolBarEnabled(boolean bl) {
        this.toolBarEnabled = bl;
    }

    @Override
    public final void pack() {
        this.widgetPeer.pack();
        this.packed = true;
    }

    @Override
    public final void select() {
        this.widgetPeer.select();
        if (this instanceof Focusable) {
            ((Focusable)Focusable.class.cast(this)).focus();
        }
    }

    @Override
    public void restoreSession(Config config) {
    }

    @Override
    public void saveSession(Config config) {
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
    }

    protected void onActivate() {
    }

    @Deprecated
    protected void onClose() {
    }

    protected void onDeactivate() {
    }

    protected void onDelete() {
    }

    protected void onInit() throws Exception {
    }

    protected void onMinimize() {
    }

    protected void onRestoreSession() throws Exception {
    }

    protected void onSaveSession() throws Exception {
    }

    protected void onSettings(Window window) {
    }

    protected void onShutDown() {
    }

    protected boolean onUpdateSettingsMenu(MMenu mMenu) {
        return false;
    }

    protected final void restoreSession() {
        Config config = this.getConfig();
        this.setDesktopNumber(config.readInt("Widget.desktopNumber", 0));
        this.widgetPeer.setLocation(config.readPoint("Widget", this.defaultLocation));
        try {
            this.onInit();
            this.initSession();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            MLabel mLabel = new MLabel(UI._("Error"), "ui/error");
            mLabel.makeLargeMessage();
            this.addCenter(mLabel);
            this.addSouth(new MButton(UI._("Details...")){

                @Override
                protected void onClick() {
                    MMessage.errorDetails(null, throwable);
                }
            });
            MLogger.exception(throwable);
        }
        if (!this.packed) {
            Dimension dimension = this.defaultSize;
            if (dimension == null) {
                dimension = this.widgetPeer.getSize();
            }
            this.widgetPeer.setSize(Math.max(config.readInt("Widget.width", dimension.width), 32), Math.max(config.readInt("Widget.height", dimension.height), 32));
        }
        if (this.widgetPeer.getWidth() == 0 || this.widgetPeer.getHeight() == 0) {
            this.widgetPeer.setSize(256, 256);
        }
        this.widgetPeer.restoreSession(config);
        this.widgetPeer.setVisible(true);
    }

    protected final void saveSession() {
        Config config = this.getConfig();
        this.saveComponentState(config);
        try {
            SessionListener[] sessionListenerArray = this.getSessionListeners();
            if (sessionListenerArray.length > 0) {
                SessionEvent sessionEvent = new SessionEvent(this);
                for (SessionListener sessionListener : sessionListenerArray) {
                    sessionListener.saveSession(sessionEvent);
                }
            }
            this.onSaveSession();
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
        config.sync();
    }

    protected void setDefaultLocation(Point point) {
        if (point == null) {
            this.defaultLocation.setLocation(0, 0);
        } else {
            this.defaultLocation.setLocation(point);
        }
    }

    protected void setMouseAdapter(Component component, MouseAdapter mouseAdapter) {
        block1: {
            component.addMouseListener(mouseAdapter);
            component.addMouseMotionListener(mouseAdapter);
            component.addMouseWheelListener(mouseAdapter);
            Container container = this.getParent();
            if (!(container instanceof MInternalFrame.ContentPane)) break block1;
            do {
                if ((container = container.getParent()) != null) continue;
                return;
            } while (!(container instanceof WidgetInternalFrame));
            container.addMouseListener(mouseAdapter);
            container.addMouseMotionListener(mouseAdapter);
            container.addMouseWheelListener(mouseAdapter);
        }
    }

    protected void setPluginInfo(PluginInfo pluginInfo) {
        this.pluginInfo = pluginInfo;
    }

    protected void updateToolBar(MToolBar mToolBar) {
    }

    protected void updateWidgetUI() {
    }

    private void initSession() throws Exception {
        SessionListener[] sessionListenerArray = this.getSessionListeners();
        if (sessionListenerArray.length > 0) {
            SessionEvent sessionEvent = new SessionEvent(this);
            for (SessionListener sessionListener : sessionListenerArray) {
                sessionListener.restoreSession(sessionEvent);
            }
        }
        this.onRestoreSession();
    }

    void delete() {
        this.onDelete();
        File file = this.getWorkingDirectory();
        FS.deleteFiles(file, null);
        file.delete();
    }

    void hideToolBar() {
        if (this.toolBar != null) {
            this.toolBar.setVisible(false);
        }
    }

    void initToolBar() {
        if (this.toolBarEnabled) {
            if (this.toolBar == null) {
                this.toolBar = new MToolBar(MIcon.Size.MEDIUM);
                this.toolBar.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
                this.updateToolBar(this.toolBar);
                this.addSouth(this.toolBar);
                this.validate();
            }
            this.toolBar.setVisible(true);
        }
    }

    void saveComponentState(Config config) {
        config.write("Widget.desktopNumber", this.desktopNumber);
        config.write("Widget", this.widgetPeer.getLocation());
        config.write("Widget", this.widgetPeer.getSize());
        this.widgetPeer.saveSession(config);
    }
}

