/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MDesktopPane;
import org.makagiga.commons.MInternalFrame;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.desktop.ui.WidgetDesktopPaneUI;

public final class WidgetDesktopIconUI
extends BasicDesktopIconUI
implements PropertyChangeListener {
    private FocusListener focusListener;
    private MButton displayButton;
    private MInternalFrame.DragAdapter dragAdapter;
    private MSmallButton closeButton;
    MPanel contentPanel;

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("closable")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.closeButton.setEnabled(bl);
            this.closeButton.setVisible(bl);
        } else if (propertyChangeEvent.getPropertyName().equals("frameIcon")) {
            this.displayButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("title")) {
            String string = (String)propertyChangeEvent.getNewValue();
            this.displayButton.setText(string);
            this.displayButton.setToolTipText(TK.centerSqueeze(string));
        }
    }

    @Override
    protected void installComponents() {
        this.contentPanel = new MPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = WidgetDesktopPaneUI.setComposite(graphics2D, WidgetDesktopIconUI.this.frame == null ? false : WidgetDesktopIconUI.this.frame.isSelected());
                super.paintComponent(graphics2D);
                if (composite != null) {
                    graphics2D.setComposite(composite);
                }
            }
        };
        this.contentPanel.setPainter(WidgetDesktopPaneUI.getSharedPainter(false));
        this.desktopIcon.setBorder(WidgetDesktopPaneUI.createBorder());
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.setOpaque(false);
        this.desktopIcon.add((Component)this.contentPanel, "Center");
        MLabel mLabel = new MLabel();
        UI.setFixedSize(mLabel, 32, 32);
        this.contentPanel.addWest(mLabel);
        this.displayButton = new MButton(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(200, super.getPreferredSize().height);
            }

            @Override
            protected void onClick() {
                if (MDesktopPane.isLocked(WidgetDesktopIconUI.this.desktopIcon)) {
                    WidgetDesktopIconUI.this.desktopIcon.requestFocusInWindow();
                } else {
                    WidgetDesktopIconUI.this.deiconize();
                }
            }
        };
        this.displayButton.setHorizontalAlignment(10);
        this.displayButton.setStyle("padding: 2px");
        this.displayButton.setIcon(this.frame.getFrameIcon());
        this.displayButton.setText(this.frame.getTitle());
        this.displayButton.setToolTipText(this.displayButton.getText());
        this.iconPane = this.displayButton;
        this.contentPanel.addCenter(this.iconPane);
        this.closeButton = new MSmallButton(MActionInfo.CLOSE_NO_KEY_STROKE);
        this.closeButton.onClick(this.frame, "doDefaultCloseAction");
        this.contentPanel.addEast(this.closeButton);
    }

    @Override
    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.contentPanel);
        this.contentPanel.removeAll();
        this.iconPane = null;
        this.displayButton = null;
        this.closeButton = null;
        this.contentPanel = null;
    }

    @Override
    protected void installListeners() {
        this.dragAdapter = new MInternalFrame.DragAdapter();
        this.dragAdapter.install(this.desktopIcon);
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                WidgetDesktopIconUI.this.desktopIcon.setBorder(WidgetDesktopPaneUI.createBorder());
                WidgetDesktopIconUI.this.contentPanel.setPainter(WidgetDesktopPaneUI.getSharedPainter(true));
                if (UI.isWindows()) {
                    WidgetDesktopIconUI.this.desktopIcon.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WidgetDesktopIconUI.this.desktopIcon.setBorder(WidgetDesktopPaneUI.createBorder());
                WidgetDesktopIconUI.this.contentPanel.setPainter(WidgetDesktopPaneUI.getSharedPainter(false));
                if (UI.isWindows()) {
                    WidgetDesktopIconUI.this.desktopIcon.repaint();
                }
            }
        };
        this.desktopIcon.addFocusListener(this.focusListener);
        this.frame.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.dragAdapter.uninstall(this.desktopIcon);
        this.dragAdapter = null;
        if (this.focusListener != null) {
            this.desktopIcon.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        this.frame.removePropertyChangeListener(this);
    }
}

