/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import java.util.List;
import org.makagiga.Tabs;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MV;
import org.makagiga.commons.UI;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorNavigation;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tree.Tree;

public final class NavigationUtils {
    private static Filter anyFileFilter = new AnyFileFilter();
    private static PreviousAction previousAction = new PreviousAction();
    private static NextAction nextAction = new NextAction();

    public static NextAction getNextAction() {
        return nextAction;
    }

    public static MetaInfo getNextFile(MetaInfo metaInfo) {
        return NavigationUtils.getNextFile(metaInfo, anyFileFilter);
    }

    public static MetaInfo getNextFile(MetaInfo metaInfo, Filter filter) {
        List<MetaInfo> list = NavigationUtils.getList(metaInfo);
        if (list == null) {
            return null;
        }
        boolean bl = false;
        for (MetaInfo metaInfo2 : list) {
            if (bl && filter.matches(metaInfo2)) {
                return metaInfo2;
            }
            if (bl || metaInfo2 != metaInfo) continue;
            bl = true;
        }
        return null;
    }

    public static PreviousAction getPreviousAction() {
        return previousAction;
    }

    public static MetaInfo getPreviousFile(MetaInfo metaInfo) {
        return NavigationUtils.getPreviousFile(metaInfo, anyFileFilter);
    }

    public static MetaInfo getPreviousFile(MetaInfo metaInfo, Filter filter) {
        List<MetaInfo> list = NavigationUtils.getList(metaInfo);
        if (list == null) {
            return null;
        }
        boolean bl = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            MetaInfo metaInfo2 = list.get(i);
            if (bl && filter.matches(metaInfo2)) {
                return metaInfo2;
            }
            if (bl || metaInfo2 != metaInfo) continue;
            bl = true;
        }
        return null;
    }

    public static void goToFile(boolean bl) {
        MetaInfo metaInfo;
        Tabs tabs = Tabs.getInstance();
        Editor editor = (Editor)tabs.getSelectedTab();
        if (editor == null) {
            return;
        }
        if (editor instanceof EditorNavigation) {
            ((EditorNavigation)EditorNavigation.class.cast(editor)).navigateTo(bl ? 4 : 2);
            return;
        }
        MetaInfo metaInfo2 = editor.getMetaInfo();
        MetaInfo metaInfo3 = metaInfo = bl ? NavigationUtils.getNextFile(metaInfo2) : NavigationUtils.getPreviousFile(metaInfo2);
        if (metaInfo != null) {
            int n = tabs.findEditor(metaInfo2);
            tabs.closeEditorAt(n, 3);
            Tree.getInstance().open(metaInfo);
        }
    }

    public static void updateActions(Editor<?> editor, MetaInfo metaInfo) {
        if (editor != null) {
            if (editor instanceof EditorNavigation) {
                int n = ((EditorNavigation)EditorNavigation.class.cast(editor)).getNavigationCapabilities();
                previousAction.setEnabled((n & 2) != 0);
                nextAction.setEnabled((n & 4) != 0);
            } else {
                previousAction.setEnabled(NavigationUtils.getPreviousFile(metaInfo) != null);
                nextAction.setEnabled(NavigationUtils.getNextFile(metaInfo) != null);
            }
        } else {
            previousAction.setEnabled(false);
            nextAction.setEnabled(false);
        }
    }

    private NavigationUtils() {
    }

    private static List<MetaInfo> getList(MetaInfo metaInfo) {
        MetaInfo metaInfo2 = (MetaInfo)metaInfo.getParentItem();
        if (metaInfo2 == null) {
            return null;
        }
        List<MetaInfo> list = metaInfo2.list(MV.VIEW);
        if (list.size() < 2) {
            return null;
        }
        return list;
    }

    private static final class AnyFileFilter
    extends Filter {
        private AnyFileFilter() {
        }

        @Override
        public boolean matches(MetaInfo metaInfo) {
            return metaInfo.isAnyFile();
        }
    }

    public static final class PreviousAction
    extends MAction {
        public PreviousAction() {
            super(MActionInfo.PREVIOUS);
            this.setAcceleratorKey(37, 8);
            this.setHTMLHelp(UI._("Opens the previous item in the current folder/document."));
        }

        @Override
        public void onAction() {
            NavigationUtils.goToFile(false);
        }
    }

    public static final class NextAction
    extends MAction {
        public NextAction() {
            super(MActionInfo.NEXT);
            this.setAcceleratorKey(39, 8);
            this.setHTMLHelp(UI._("Opens the next item in the current folder/document."));
        }

        @Override
        public void onAction() {
            NavigationUtils.goToFile(true);
        }
    }

    public static abstract class Filter {
        public abstract boolean matches(MetaInfo var1);
    }
}

