/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.Config;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MColorIcon;
import org.makagiga.commons.MColorPicker;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSlider;
import org.makagiga.commons.MToggleButton;
import org.makagiga.commons.MTogglePanel;
import org.makagiga.commons.UI;
import org.makagiga.editors.Designer;
import org.makagiga.editors.Editor;
import org.makagiga.editors.image.ImageEditorCore;
import org.makagiga.editors.image.ImageInfo;
import org.makagiga.editors.image.tools.BrushTool;
import org.makagiga.editors.image.tools.EraserTool;
import org.makagiga.editors.image.tools.Tool;
import org.makagiga.editors.image.tools.ToolPanel;

public final class ImageEditorDesigner
extends Designer {
    private static ImageEditorDesigner _instance;
    private MColorPicker brushColor;
    private MLabel brushPreview;
    private MLabel opacityLabel;
    private MSlider brushSize;
    private MSlider opacity;
    MToggleButton circleBrushType;
    MToggleButton squareBrushType;
    MTogglePanel imageInfoTogglePanel;

    @Deprecated
    public static synchronized void freeInstance() {
        _instance = null;
    }

    public static synchronized ImageEditorDesigner getInstance() {
        if (_instance == null) {
            _instance = new ImageEditorDesigner();
        }
        return _instance;
    }

    @Override
    public void setLocked(boolean bl) {
        super.setLocked(bl);
        this.brushSize.setEnabled(!bl);
        this.brushColor.setEnabled(!bl);
        this.opacity.setEnabled(!bl);
    }

    public void update(ImageEditorCore imageEditorCore, boolean bl) {
        JComponent jComponent = this.imageInfoTogglePanel.getComponent();
        if (jComponent instanceof ImageInfo) {
            ((ImageInfo)ImageInfo.class.cast(jComponent)).update(imageEditorCore.getEditor().getMetaInfo(), imageEditorCore.getCanvas());
        }
        BrushTool brushTool = BrushTool.getInstance();
        Tool tool = imageEditorCore.getToolManager().getCurrent();
        BrushTool brushTool2 = tool instanceof BrushTool ? (BrushTool)tool : brushTool;
        this.brushColor.setColor(brushTool2.getColor());
        this.brushSize.setValue(brushTool.getSize(), true);
        this.opacity.setValue(brushTool.getOpacity(), true);
        if (bl) {
            imageEditorCore.updateCursor();
        }
        if (brushTool2 instanceof EraserTool) {
            brushTool2.setSize(brushTool.getSize());
            brushTool2.setType(brushTool.getType());
        }
        this.brushPreview.setImage(brushTool2.getPreview());
        this.brushPreview.setNumber(brushTool.getSize());
        this.opacityLabel.setNumber(this.opacity.getValue());
        switch (brushTool.getType()) {
            case CIRCLE: {
                this.circleBrushType.setSelected(true);
                break;
            }
            default: {
                this.squareBrushType.setSelected(true);
            }
        }
        Component component = this.getComponentCount() > 0 ? this.getComponent(this.getComponentCount() - 1) : null;
        UI.replaceComponent(this, component instanceof ToolPanel ? component : null, tool.getToolPanel(), null, false);
    }

    private ImageEditorDesigner() {
        this.setDisplayText(UI._("Tools"));
        this.imageInfoTogglePanel = new MTogglePanel(UI._("Image Info"), MIcon.small("ui/info"), null, "image-info", true);
        this.add(this.imageInfoTogglePanel);
        this.add(this.createColorPanel());
        this.add(this.createBrushPanel());
    }

    private MTogglePanel createBrushPanel() {
        this.circleBrushType = new MToggleButton(new BrushTypeAction(BrushTool.Type.CIRCLE, UI._("Circle")));
        this.circleBrushType.setMargin(UI.createInsets(0));
        this.circleBrushType.setRequestFocusEnabled(false);
        this.squareBrushType = new MToggleButton(new BrushTypeAction(BrushTool.Type.SQUARE, UI._("Square")));
        this.squareBrushType.setMargin(UI.createInsets(0));
        this.squareBrushType.setRequestFocusEnabled(false);
        UI.group(this.circleBrushType, this.squareBrushType);
        this.brushSize = new MSlider(){

            @Override
            protected void onChange() {
                ImageEditorCore imageEditorCore = Editor.getCurrentCore(ImageEditorCore.class);
                if (imageEditorCore != null) {
                    BrushTool.getInstance().setSize(this.getValue());
                    imageEditorCore.doUpdateDesigner(!this.getValueIsAdjusting());
                }
            }
        };
        this.brushSize.setMinimum(1);
        this.brushSize.setMaximum(50);
        this.brushSize.setValue(3);
        this.brushSize.setEventsEnabled(true);
        this.brushSize.setRequestFocusEnabled(false);
        this.brushPreview = MLabel.createSmall(null, null);
        this.brushPreview.setHorizontalAlignment(0);
        this.brushPreview.setToolTipText(UI._("Preview"));
        UI.setFixedSize(this.brushPreview, 100, 52);
        MPanel mPanel = MPanel.createGroupPanel(true);
        mPanel.getGroupLayout().beginRows().beginColumns().addComponent((Component)MLabel.createFor(this.brushSize, UI._("Size:")), true).addComponent((Component)this.brushSize, true).end().addComponent(this.brushPreview).end();
        return new MTogglePanel(UI._("Brush"), mPanel, "brush-properties", true);
    }

    private MTogglePanel createColorPanel() {
        MPanel mPanel = MPanel.createGroupPanel(true);
        this.brushColor = new MColorPicker();
        this.brushColor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ImageEditorCore imageEditorCore = Editor.getCurrentCore(ImageEditorCore.class);
                if (imageEditorCore != null) {
                    MColorPicker mColorPicker = (MColorPicker)changeEvent.getSource();
                    BrushTool.getInstance().setColor(mColorPicker.getColor());
                    imageEditorCore.doUpdateDesigner(true);
                }
            }
        });
        this.opacity = new MSlider(){

            @Override
            protected void onChange() {
                ImageEditorCore imageEditorCore = Editor.getCurrentCore(ImageEditorCore.class);
                if (imageEditorCore != null) {
                    BrushTool.getInstance().setOpacity(this.getValue());
                    imageEditorCore.doUpdateDesigner(!this.getValueIsAdjusting());
                }
            }
        };
        this.opacity.setToolTipText(UI._("Opacity"));
        this.opacity.setMinimum(0);
        this.opacity.setMaximum(255);
        this.opacity.setValue(255);
        this.opacity.setEventsEnabled(true);
        this.opacity.setRequestFocusEnabled(false);
        this.opacityLabel = MLabel.createSmall(null, null);
        this.opacityLabel.setLabelFor(this.opacity);
        this.opacityLabel.setToolTipText(this.opacity.getToolTipText());
        mPanel.getGroupLayout().beginRows().addComponent(this.brushColor).beginColumns().addComponent((Component)this.opacity, true).addComponent((Component)this.opacityLabel, true).end().end();
        return new MTogglePanel(UI._("Color"), mPanel, "brush-color", true);
    }

    static synchronized boolean isInstance() {
        return _instance != null;
    }

    void readConfig(Config.GlobalEntry globalEntry) {
        Config config = Config.getDefault();
        this.brushColor.readConfig(config, globalEntry.getGlobalEntry("Designer"));
    }

    void writeConfig(Config.GlobalEntry globalEntry) {
        Config config = Config.getDefault();
        this.brushColor.writeConfig(config, globalEntry.getGlobalEntry("Designer"));
    }

    private static final class BrushTypeAction
    extends MDataAction<BrushTool.Type> {
        @Override
        public void onAction() {
            ImageEditorCore imageEditorCore = Editor.getCurrentCore(ImageEditorCore.class);
            if (imageEditorCore != null) {
                BrushTool.getInstance().setType((BrushTool.Type)((Object)this.getData()));
                imageEditorCore.doUpdateDesigner(true);
            }
        }

        private BrushTypeAction(BrushTool.Type type, String string) {
            super(type, (String)null);
            MColorIcon mColorIcon;
            this.setShortDescription(UI._("Brush Type: {0}", string));
            Dimension dimension = new Dimension(17, 17);
            switch (type) {
                case CIRCLE: {
                    mColorIcon = new MColorIcon(MColor.DARK_GREEN, dimension);
                    mColorIcon.setType(MColorIcon.Type.OVAL);
                    break;
                }
                default: {
                    mColorIcon = new MColorIcon(MColor.DARK_RED, dimension);
                    mColorIcon.setType(MColorIcon.Type.RECTANGLE);
                }
            }
            this.setSmallIcon(mColorIcon);
        }
    }
}

