/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image;

import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import org.makagiga.commons.Config;
import org.makagiga.commons.MDataTransfer;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.image.ImageEditor;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginInfo;

public final class ImageEditorPlugin
extends EditorPlugin {
    public ImageEditorPlugin() {
        this.setEncryption(EditorPlugin.Encryption.MEMORY);
    }

    @Override
    public void importData(Object object, DataFlavor dataFlavor, Map<DataFlavor, Object> map, File file) throws Exception {
        BufferedImage bufferedImage = (BufferedImage)MDataTransfer.getImage(object, dataFlavor);
        if (bufferedImage == null) {
            throw new IOException();
        }
        String string = dataFlavor.getSubType();
        if (!TK.newHashSet(ImageIO.getWriterFormatNames()).contains(string)) {
            string = "png";
        }
        ImageIO.write((RenderedImage)bufferedImage, string, file);
    }

    @Override
    public boolean isDataFlavorSupported(Object object, DataFlavor dataFlavor, Map<DataFlavor, Object> map) {
        if (dataFlavor.equals(DataFlavor.imageFlavor)) {
            return true;
        }
        PluginInfo pluginInfo = ImageEditorPlugin.findPluginForMime(MDataTransfer.getSimpleMimeType(dataFlavor));
        return pluginInfo != null && pluginInfo.getPlugin() instanceof ImageEditorPlugin;
    }

    @Override
    public Editor<?> create() {
        return new ImageEditor();
    }

    @Override
    public void onInit(Config config, PluginInfo pluginInfo) throws PluginException {
        super.onInit(config, pluginInfo);
        String[] stringArray = new String[]{"jpg", "JPG"};
        EditorPlugin.FileType[] fileTypeArray = new EditorPlugin.FileType[]{new EditorPlugin.FileType("png", UI._("PNG Image"), "image/png"), new EditorPlugin.FileType("jpeg", UI._("JPEG Image"), "image/jpeg", stringArray), new EditorPlugin.FileType("gif", UI._("GIF Image"), "image/gif"), new EditorPlugin.FileType("bmp", UI._("Bitmap Image"))};
        this.setFileTypes(fileTypeArray);
        this.setImportTypes(fileTypeArray);
        this.setExportTypes(fileTypeArray);
    }
}

