/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image;

import java.awt.image.BufferedImage;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.FS;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.HTMLSelection;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MFormat;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.UI;
import org.makagiga.fs.MetaInfo;

public final class ImageInfo
extends MToolBar {
    @Deprecated
    public static final String TITLE = "Image Info";
    private int imageHeight;
    private int imageWidth;
    private MetaInfo metaInfo;
    private final MButton info;

    public ImageInfo() {
        this.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        this.info = new MButton(){

            @Override
            protected MMenu onPopupMenu() {
                return ImageInfo.this.createInfoMenu();
            }
        };
        this.info.setPopupMenuEnabled(true);
        this.info.setToolTipText(UI._(TITLE));
        this.addButton(this.info, 1);
        this.addGap();
        this.readConfig("editor-image-info");
    }

    @Deprecated
    public void hideProgressBar() {
    }

    public void update(MetaInfo metaInfo, BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            this.metaInfo = metaInfo;
            this.imageWidth = bufferedImage.getWidth();
            this.imageHeight = bufferedImage.getHeight();
            this.info.setEnabled(true);
            this.info.setText(this.formatTextImageInfo());
        } else {
            this.info.setEnabled(false);
            this.info.setText(null);
        }
    }

    @Deprecated
    public void updateProgressBar(int n) {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(null);
        this.setBorderPainted(false);
    }

    private MMenu createInfoMenu() {
        MMenu mMenu = new MMenu();
        MAction mAction = new MAction(MActionInfo.COPY){

            @Override
            public void onAction() {
                try {
                    MClipboard.setString(ImageInfo.this.formatTextImageInfo());
                }
                catch (ClipboardException clipboardException) {
                    MMessage.error(null, clipboardException);
                }
            }
        };
        mAction.setAcceleratorKey(null);
        mMenu.add(mAction);
        mMenu.add(new MAction(MActionInfo.COPY_AS_HTML){

            @Override
            public void onAction() {
                try {
                    HTMLSelection hTMLSelection = new HTMLSelection(ImageInfo.this.formatHTMLImageInfo());
                    MClipboard.setContents(hTMLSelection);
                }
                catch (ClipboardException clipboardException) {
                    MMessage.error(null, clipboardException);
                }
            }
        });
        return mMenu;
    }

    private String formatHTMLImageInfo() {
        String string = this.metaInfo.toString();
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.appendLine(hTMLBuilder.createImage(null, FS.toURL(this.metaInfo.getFile()).toString(), string, string, this.imageWidth, this.imageHeight));
        return hTMLBuilder.toString();
    }

    private String formatTextImageInfo() {
        return String.format("%d x %d (%s)", this.imageWidth, this.imageHeight, MFormat.toAutoSize(this.metaInfo.getFile().length()));
    }
}

