/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image;

import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.SwingWorker;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MTimer;
import org.makagiga.fs.MetaInfo;

public final class ImagePreloader
extends SwingWorker<Data, Object> {
    private static ImagePreloader _instance;
    private final MetaInfo metaInfo;
    private MTimer freeTimer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delayedFree() {
        Class<ImagePreloader> clazz = ImagePreloader.class;
        synchronized (ImagePreloader.class) {
            if (_instance == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (ImagePreloader._instance.freeTimer == null) {
                ImagePreloader._instance.freeTimer = new MTimer(MTimer.Format.MINUTES, 1){

                    @Override
                    protected boolean onTimeout() {
                        MLogger.debug("image", "Delayed free");
                        ImagePreloader.stop();
                        return false;
                    }
                };
                ImagePreloader._instance.freeTimer.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Data getData() {
        Class<ImagePreloader> clazz = ImagePreloader.class;
        synchronized (ImagePreloader.class) {
            if (_instance == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            if (!_instance.isDone() || _instance.isCancelled()) {
                ImagePreloader.stop();
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            try {
                Data data = (Data)_instance.get();
                if (data == null) {
                    Data data2 = null;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return data2;
                }
                if (data.image == null) {
                    Data data3 = null;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return data3;
                }
                Data data4 = data;
                // ** MonitorExit[var0] (shouldn't be in output)
                return data4;
            }
            catch (Exception exception) {
                MLogger.exception(exception);
                Data data = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return data;
            }
            finally {
                ImagePreloader.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMetaInfo(MetaInfo metaInfo) {
        Class<ImagePreloader> clazz = ImagePreloader.class;
        synchronized (ImagePreloader.class) {
            if (_instance == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ImagePreloader._instance.metaInfo == metaInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void start(MetaInfo metaInfo) {
        ImagePreloader.stop();
        if (metaInfo == null) return;
        Class<ImagePreloader> clazz = ImagePreloader.class;
        synchronized (ImagePreloader.class) {
            _instance = new ImagePreloader(metaInfo);
            _instance.execute();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Class<ImagePreloader> clazz = ImagePreloader.class;
        synchronized (ImagePreloader.class) {
            if (_instance != null) {
                MLogger.debug("image", "Stop preloader");
                if (ImagePreloader._instance.freeTimer != null) {
                    ImagePreloader._instance.freeTimer.stop();
                }
                _instance.cancel(true);
                _instance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected Data doInBackground() throws Exception {
        Thread thread = Thread.currentThread();
        thread.setPriority(3);
        return new Data(ImageIO.read(this.metaInfo.getFile()));
    }

    @Override
    protected void done() {
        if (!this.isCancelled()) {
            MLogger.debug("image", "Image preloaded");
            ImagePreloader.delayedFree();
        }
    }

    private ImagePreloader(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public static final class Data {
        private final BufferedImage image;

        public BufferedImage getImage() {
            return this.image;
        }

        private Data(BufferedImage bufferedImage) {
            this.image = bufferedImage;
        }
    }
}

