/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image.tools;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.ImageSelection;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.UI;
import org.makagiga.editors.image.tools.AbstractRectangleTool;

public final class SelectionTool
extends AbstractRectangleTool {
    public SelectionTool() {
        super(UI._("Selection"), "selection");
        this.setKeyStroke(82);
        this.setLocked(true);
        this.setUseBrushTool(false);
        this.setVisiblePanel("selection", true);
    }

    public boolean copy(BufferedImage bufferedImage) {
        try {
            MClipboard.setContents(new ImageSelection(this.getImage(bufferedImage), this.core.getBackground()));
            return true;
        }
        catch (ClipboardException clipboardException) {
            MLogger.exception(clipboardException);
            return false;
        }
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2) {
        if (!this.isSelection()) {
            return;
        }
        Shape shape = graphics2D.getClip();
        Area area = new Area(new Rectangle(0, 0, n, n2));
        area.exclusiveOr(new Area(this.bounds));
        graphics2D.clip(area);
        graphics2D.setColor(UI.TRANSPARENT_GRAY);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setClip(shape);
        graphics2D.setColor(UI.TRANSPARENT_WHITE);
        graphics2D.drawRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public BufferedImage getImage(BufferedImage bufferedImage) {
        if (this.isSelection()) {
            return bufferedImage.getSubimage(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
        return bufferedImage;
    }

    public boolean isSelection() {
        return !this.bounds.isEmpty();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (this.isSelection()) {
            this.editor.showSelectionMenu(mouseEvent, this);
        }
    }

    public String toString() {
        return this.bounds.width + " x " + this.bounds.height;
    }
}

