/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.link;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.makagiga.commons.Config;
import org.makagiga.commons.MDataTransfer;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.Net;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.XMLHelper;
import org.makagiga.commons.preview.AbstractPreview;
import org.makagiga.commons.preview.DefaultPreview;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.link.Link;
import org.makagiga.editors.link.LinkEditor;
import org.makagiga.fs.FSException;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.tree.TreeFS;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.tree.ImportExport;
import org.makagiga.tree.Tree;

public final class LinkEditorPlugin
extends EditorPlugin {
    public LinkEditorPlugin() {
        this.setEncryption(EditorPlugin.Encryption.MEMORY);
    }

    @Override
    public void importData(Object object, DataFlavor dataFlavor, Map<DataFlavor, Object> map, File file) throws Exception {
        String string = MDataTransfer.getString(object);
        Link link = new Link(string, null);
        XMLHelper.marshal((Object)link, file);
    }

    @Override
    public boolean isDataFlavorSupported(Object object, DataFlavor dataFlavor, Map<DataFlavor, Object> map) {
        for (DataFlavor dataFlavor2 : MDataTransfer.getAvailableDataFlavors(object)) {
            if (!"image".equals(dataFlavor2.getPrimaryType())) continue;
            return false;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            URL uRL = (URL)map.get(MDataTransfer.URL_DATA_FLAVOR);
            return uRL != null && !MDataTransfer.isImage(uRL);
        }
        return false;
    }

    @Override
    public Editor<?> create() {
        return new LinkEditor();
    }

    @Override
    public void onInit(Config config, PluginInfo pluginInfo) throws PluginException {
        super.onInit(config, pluginInfo);
        this.setFileTypes(new EditorPlugin.FileType("mglink"));
        this.setImportTypes(new EditorPlugin.FileType("mglink", this.getName()));
        this.setExportTypes(new EditorPlugin.FileType("mglink", this.getName()), new EditorPlugin.FileType("desktop", UI._("Link ({0} file)", ".desktop")), new EditorPlugin.FileType("webapp", "Web Application (Mozilla Prism)"), new EditorPlugin.FileType("ied", "Incollector"), new EditorPlugin.FileType("url", UI._("Link ({0} file)", ".url")));
        DefaultPreview.getInstance().addHandler("mglink", new AbstractPreview(false){

            @Override
            public Image getImage(File file, int n, MProperties mProperties) throws Exception {
                Link link = XMLHelper.unmarshal(Link.class, file);
                String string = link.getDescription();
                String string2 = link.getURL();
                mProperties.setPropertyValue("comment-property", string);
                mProperties.setPropertyValue("url-property", string2);
                if (string2 != null && Net.isLocal(string2)) {
                    Icon icon;
                    File file2;
                    File file3 = file2 = string2.startsWith("file:/") ? new File(new URI(string2)) : new File(string2);
                    if (file2.exists() && (icon = FileSystemView.getFileSystemView().getSystemIcon(file2)) != null) {
                        mProperties.setObject("icon-property", icon);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void onPostInit() throws PluginException {
        super.onPostInit();
        MURLButton.addLinkAction(new MURLButton.LinkAction(UI._("Save Link Address")){

            @Override
            public void onAction(String string, String string2) {
                String string3 = TK.isEmpty(string2) ? string : string2;
                try {
                    MetaInfo metaInfo = ImportExport.createLinkFile(TreeFS.getInstance().getRoot(), string3, string2, string);
                    Tree.getInstance().selectItem(metaInfo, true);
                }
                catch (FSException fSException) {
                    MMessage.error(null, fSException);
                }
                catch (IOException iOException) {
                    MMessage.error(null, iOException);
                }
            }
        });
    }
}

