/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.feeds;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.makagiga.commons.FS;
import org.makagiga.commons.FileCache;
import org.makagiga.commons.HTMLAutodiscovery;
import org.makagiga.commons.HTMLEntities;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.Net;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.feeds.AbstractChannel;
import org.makagiga.feeds.AbstractItem;
import org.makagiga.feeds.FeedException;
import org.makagiga.feeds.FeedListException;
import org.makagiga.feeds.atom0x.Atom0xChannel;
import org.makagiga.feeds.atom10.Atom10Channel;
import org.makagiga.feeds.rdf.RDFChannel;
import org.makagiga.feeds.rss.RSSChannel;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Feed {
    private Info info;
    private InputStream input;
    private final MLogger log = MLogger.get("feed");
    private String contentType;
    private URL source;
    private URLConnection connection;

    public synchronized void cancelDownload() {
        FS.close(this.input);
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)HttpURLConnection.class.cast(this.connection)).disconnect();
            this.connection = null;
        }
    }

    public AbstractChannel<? extends AbstractItem> download(String string) throws FeedException, FeedListException {
        return this.download(string, null);
    }

    /*
     * Exception decompiling
     */
    public synchronized AbstractChannel<? extends AbstractItem> download(String var1_1, Class<AbstractChannel<? extends AbstractItem>> var2_2) throws FeedException, FeedListException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized List<Link> getLinks() {
        return this.info.links;
    }

    public synchronized URL getSource() {
        return this.source;
    }

    @Deprecated
    public static synchronized boolean isAd(AbstractChannel<?> abstractChannel, AbstractItem abstractItem) {
        if (!Feed.isSameHost(abstractChannel, abstractItem)) {
            return true;
        }
        if (abstractItem.isTitlePresent()) {
            List<String> list;
            List<String> list2 = TK.fastSplit(UI._("advertisement sponsored advertising ad").toUpperCase(), ' ');
            return !Collections.disjoint(list2, list = TK.fastSplit(abstractItem.getTitle().toUpperCase(), ' '));
        }
        return false;
    }

    private void doParse(XMLReader xMLReader, InputStream inputStream, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        if (bl || bl2 || bl3 || bl4) {
            StringBuilder stringBuilder = FS.readLines(inputStream, this.info.getEncoding(), true);
            if (bl4) {
                TK.fastReplace(stringBuilder, " & ", " &amp; ");
            }
            if (bl) {
                TK.fastReplace(stringBuilder, "\u0000\u001b", "?");
                TK.fastReplace(stringBuilder, "\u0010", "?");
            }
            if (bl3) {
                for (Map.Entry<String, String> entry : HTMLEntities.getMap().entrySet()) {
                    TK.fastReplace(stringBuilder, "&" + entry.getKey() + ";", entry.getValue());
                }
            }
            xMLReader.parse(new InputSource(new StringReader(stringBuilder.toString())));
        } else {
            xMLReader.parse(new InputSource(inputStream));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL downloadToFile(String string) throws IOException {
        URL uRL = null;
        this.contentType = null;
        try {
            String string2 = Net.unescapeHTML(string);
            if (string2.startsWith("feed:")) {
                string2 = string2.startsWith("feed://") ? string2.replaceFirst("feed", "http") : string2.substring("feed:".length());
            }
            if (!string2.startsWith("http://") && !string2.startsWith("https://")) {
                string2 = "http://" + string2;
            }
            this.source = new URL(string2);
            this.connection = this.source.openConnection();
            Net.setupConnection(this.connection, 4);
            if ("digg.com".equals(this.source.getHost())) {
                this.connection.setRequestProperty("User-Agent", "Firefox");
            }
            this.connection = Net.checkTemporaryRedirect(this.connection, 4);
            long l = this.connection.getLastModified();
            uRL = this.connection.getURL();
            FileCache fileCache = FileCache.getInstance();
            File file = fileCache.getFile(uRL, l);
            if (file != null && file.length() != 0L) {
                this.log.debugFormat("Using file from cache: %s", file);
                this.info.data = file;
                URL uRL2 = uRL;
                return uRL2;
            }
            if (l != 0L) {
                this.info.cache = fileCache.createFile(uRL, l, "feed");
                this.log.debugFormat("Creating new cache entry: %s", this.info.cache);
            }
            this.input = new BufferedInputStream(Net.getInputStream(this.connection));
            this.contentType = this.connection.getContentType();
            this.info.data = new ByteArrayOutputStream(65536);
            FS.copyStream(this.input, (OutputStream)this.info.data);
        }
        finally {
            this.cancelDownload();
        }
        return uRL;
    }

    private Class<? extends AbstractChannel<?>> getHandlerByContentType() {
        if (this.contentType == null) {
            return null;
        }
        if (this.contentType.startsWith("text/")) {
            return null;
        }
        if (this.contentType.startsWith("application/atom+xml")) {
            return Atom10Channel.class;
        }
        if (this.contentType.startsWith("application/rdf+xml")) {
            return RDFChannel.class;
        }
        return RSSChannel.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInfo() throws FeedListException, FileNotFoundException {
        FS.TextReader textReader = null;
        try {
            textReader = this.info.data instanceof File ? FS.getUTF8Reader((File)this.info.data) : FS.getUTF8Reader(this.info.getInputStream());
            boolean bl = false;
            Scanner scanner = new Scanner(textReader);
            scanner.useDelimiter("\\<");
            while (scanner.hasNext()) {
                String string = scanner.next().trim();
                String string2 = TK.toUpperCase(string);
                if (string2.startsWith("HTML")) {
                    FS.close(textReader);
                    textReader = this.info.data instanceof File ? FS.getUTF8Reader((File)this.info.data) : FS.getUTF8Reader(this.info.getInputStream());
                    HTMLAutodiscovery hTMLAutodiscovery = new HTMLAutodiscovery();
                    StringBuilder stringBuilder = new StringBuilder();
                    URL uRL = this.getSource();
                    stringBuilder.append(uRL.getProtocol()).append("://").append(uRL.getHost());
                    hTMLAutodiscovery.setBaseURL(stringBuilder.toString());
                    for (HTMLAutodiscovery.Link link : hTMLAutodiscovery.findLinks(textReader)) {
                        if (!link.isFeed()) continue;
                        if (this.info.links == null) {
                            this.info.links = new MArrayList();
                        }
                        this.info.links.add(new Link(link));
                    }
                    break;
                }
                if (string.startsWith("feed")) {
                    if (string.contains("http://www.w3.org/2005/Atom")) {
                        this.info.handler = Atom10Channel.class;
                        break;
                    }
                    if (!string.contains("http://purl.org/atom/ns#")) break;
                    this.info.handler = Atom0xChannel.class;
                    break;
                }
                if (string.startsWith("rdf:RDF")) {
                    this.info.handler = RDFChannel.class;
                    break;
                }
                if (string.startsWith("rss")) {
                    this.info.handler = RSSChannel.class;
                    break;
                }
                if (bl || !string.startsWith("?xml")) continue;
                bl = true;
                if (!string.contains("encoding")) continue;
                this.info.setEncoding(HTMLAutodiscovery.getAttribute(string, "encoding"));
            }
            if (this.info.links != null) {
                throw new FeedListException(this);
            }
        }
        catch (Throwable throwable) {
            FS.close(textReader);
            throw throwable;
        }
        FS.close(textReader);
    }

    private static boolean isSameHost(AbstractChannel<?> abstractChannel, AbstractItem abstractItem) {
        if (!abstractChannel.isLinkPresent()) {
            return true;
        }
        if (!abstractItem.isLinkPresent()) {
            return true;
        }
        try {
            String string = new URL(abstractChannel.getLink()).getHost();
            String string2 = new URL(abstractItem.getLink()).getHost();
            if (string == null) {
                return true;
            }
            if (string2 == null) {
                return true;
            }
            if (string.startsWith("www.")) {
                string = string.substring(4);
            }
            if (string2.startsWith("www.")) {
                string2 = string2.substring(4);
            }
            return string.equalsIgnoreCase(string2);
        }
        catch (MalformedURLException malformedURLException) {
            return true;
        }
    }

    synchronized void setSource(URL uRL) {
        this.source = uRL;
    }

    private static final class Info {
        private Class<? extends AbstractChannel<?>> handler;
        private File cache;
        private List<Link> links;
        private Object data;
        private String encoding = "UTF-8";

        private Info() {
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String string) {
            if (string == null) {
                this.encoding = "UTF-8";
            } else {
                try {
                    if (!Charset.isSupported(string)) {
                        MLogger.warning("feed", "Unsupported encoding: \"%s\"", string);
                        this.encoding = "UTF-8";
                    } else {
                        this.encoding = string;
                    }
                }
                catch (Exception exception) {
                    MLogger.exception(exception);
                    this.encoding = "UTF-8";
                }
            }
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(((ByteArrayOutputStream)ByteArrayOutputStream.class.cast(this.data)).toByteArray());
        }

        static /* synthetic */ Class access$200(Info info) {
            return info.handler;
        }
    }

    public static final class Link {
        private String href;
        private String rel;
        private String title;
        private String type;

        public Link() {
        }

        public String getHref() {
            return this.href;
        }

        public String getRel() {
            return this.rel;
        }

        public String getTitle() {
            return this.title;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return TK.isEmpty(this.title) ? this.href : this.title;
        }

        private Link(HTMLAutodiscovery.Link link) {
            this.href = link.getHref();
            this.rel = link.getRel();
            this.title = link.getTitle();
            this.type = link.getType();
        }
    }
}

