/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.feeds.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.XMLHelper;
import org.makagiga.feeds.AbstractChannel;
import org.makagiga.feeds.AbstractItem;
import org.makagiga.feeds.archive.Archive;
import org.makagiga.feeds.archive.ArchiveException;
import org.makagiga.feeds.archive.ArchiveItem;

@XmlRootElement(name="archive")
public final class ArchiveChannel
extends AbstractChannel<ArchiveItem> {
    private List<ArchiveItem> items;
    @XmlElement(name="x")
    private List<Expired> expired;
    private String dateFormat;
    private String link;

    public ArchiveChannel() {
    }

    public ArchiveChannel(String string, AbstractChannel<?> abstractChannel) {
        List<?> list;
        List<?> list2 = list = abstractChannel == null ? null : abstractChannel.getItems();
        if (list != null) {
            this.items = new ArrayList<ArchiveItem>(list.size());
            this.dateFormat = abstractChannel.getDateStandard();
            for (AbstractItem abstractItem : list) {
                this.items.add(new ArchiveItem(abstractItem, true));
            }
        } else {
            this.items = new ArrayList<ArchiveItem>();
        }
        this.link = string;
        if (abstractChannel != null) {
            this.setBase(abstractChannel.getBase());
            this.setTitle(abstractChannel.getTitle());
        }
    }

    @Deprecated
    public void addItems(List<AbstractItem> list, int n) {
        this.addItems(list, n, Archive.Policy.REMOVE, 10);
    }

    @Deprecated
    public void addItems(List<? extends AbstractItem> list, int n, Archive.Policy policy, int n2) {
        this.add(list, n, policy, n2);
    }

    public boolean add(List<? extends AbstractItem> list, int n, Archive.Policy policy, int n2) {
        if (TK.isEmpty(list)) {
            return false;
        }
        boolean bl = false;
        if (this.expired != null && this.expired.size() > 1000) {
            this.expired.subList(0, this.expired.size() - 1000).clear();
            bl = true;
        }
        ArrayList<ArchiveItem> arrayList = new ArrayList<ArchiveItem>(list.size());
        for (AbstractItem object : list) {
            if (this.isExpired(object) || this.exists(object, n)) continue;
            arrayList.add(new ArchiveItem(object, true));
            bl = true;
        }
        if (this.items == null) {
            this.items = new ArrayList<ArchiveItem>(list.size());
            if (this.items.addAll(arrayList)) {
                bl = true;
            }
        } else if (this.items.addAll(0, arrayList)) {
            bl = true;
        }
        if (!(this.items.isEmpty() || policy != Archive.Policy.REMOVE && policy != Archive.Policy.USE_GLOBAL_SETTINGS)) {
            Calendar calendar = MDate.now().getCalendar();
            calendar.add(5, -n2);
            int n3 = this.items.size() - 1;
            while (n3 >= 0) {
                MDate mDate;
                ArchiveItem archiveItem = this.items.get(n3);
                if (archiveItem.getCategory() != null || archiveItem.getColor() != null || archiveItem.getIcon() != null || archiveItem.getRating() != null || archiveItem.getTags() != null) {
                    --n3;
                    continue;
                }
                if ((archiveItem.isIdPresent() || archiveItem.isLinkPresent()) && (mDate = archiveItem.getDownloadDateAsDate()) != null) {
                    if (!mDate.before(calendar.getTime())) break;
                    if (this.expired == null) {
                        this.expired = new ArrayList<Expired>();
                    }
                    this.expired.add(new Expired(archiveItem));
                    this.items.remove(archiveItem);
                    bl = true;
                }
                --n3;
            }
        }
        return bl;
    }

    @XmlAttribute(name="dateFormat")
    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
    }

    public List<ArchiveItem> getFreshItems() {
        if (TK.isEmpty(this.items)) {
            return this.items;
        }
        ArrayList<ArchiveItem> arrayList = new ArrayList<ArchiveItem>(this.items.size());
        for (ArchiveItem archiveItem : this.items) {
            if (this.isExpired(archiveItem)) continue;
            arrayList.add(archiveItem);
        }
        return arrayList;
    }

    @Override
    @XmlElement(name="item")
    public List<ArchiveItem> getItems() {
        return this.items;
    }

    public void setItems(List<ArchiveItem> list) {
        this.items = list;
    }

    @Override
    @XmlElement(name="link")
    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public void removeExpiredInfo() {
        if (this.expired != null) {
            this.expired.clear();
        }
    }

    @Override
    protected void onFinish() {
        if (!TK.isEmpty(this.items)) {
            ArchiveItem.DateFormat dateFormat;
            if ("RFC3339".equals(this.dateFormat)) {
                dateFormat = ArchiveItem.DateFormat.RFC_3339;
            } else if ("RFC822".equals(this.dateFormat)) {
                dateFormat = ArchiveItem.DateFormat.RFC_822;
            } else {
                return;
            }
            for (ArchiveItem archiveItem : this.items) {
                archiveItem.setDateFormat(dateFormat);
            }
        }
    }

    private boolean exists(AbstractItem abstractItem, int n) {
        if (TK.isEmpty(this.items)) {
            return false;
        }
        for (ArchiveItem archiveItem : this.items) {
            if (!archiveItem.equals(abstractItem, n)) continue;
            return true;
        }
        return false;
    }

    private boolean isExpired(AbstractItem abstractItem) {
        if (!abstractItem.isIdPresent() && !abstractItem.isLinkPresent()) {
            return false;
        }
        if (this.expired == null) {
            return false;
        }
        Iterator<Expired> iterator = this.expired.iterator();
        String string = abstractItem.getUniqueID();
        while (iterator.hasNext()) {
            boolean bl;
            boolean bl2;
            Expired expired = iterator.next();
            if (!expired.id.equals(string)) continue;
            if (expired.updated == null) {
                bl2 = false;
                bl = false;
            } else {
                if (expired.cachedUpdated == null) {
                    expired.cachedUpdated = this.noTZ(expired.updated);
                }
                if (abstractItem.isUpdatedDatePresent()) {
                    bl2 = false;
                    bl = !expired.cachedUpdated.equals(this.noTZ(abstractItem.getUpdatedDate()));
                } else {
                    bl2 = abstractItem.isPublishedDatePresent() && !expired.cachedUpdated.equals(this.noTZ(abstractItem.getPublishedDate()));
                    bl = false;
                }
            }
            if (bl || bl2) {
                if (bl2) {
                    MLogger.debug("archive", "\"Published\" date changed: \"%s\" -> \"%s\"", expired.updated, abstractItem.getPublishedDate());
                }
                if (bl) {
                    MLogger.debug("archive", "\"Updated\" date changed: \"%s\" -> \"%s\"", expired.updated, abstractItem.getUpdatedDate());
                }
                iterator.remove();
                return false;
            }
            return true;
        }
        return false;
    }

    private String noTZ(String string) {
        if (string == null) {
            return "";
        }
        if ("RFC822".equals(this.dateFormat)) {
            char c;
            int n = string.lastIndexOf(32);
            if (n == -1) {
                return string.trim();
            }
            if (n < string.length() - 1 && ((c = string.charAt(n + 1)) == '+' || c == '-' || Character.isLetter(c))) {
                String string2 = string.substring(0, n);
                return string2.trim();
            }
        }
        return string.trim();
    }

    static ArchiveChannel loadFromXML(File file) throws FileNotFoundException, JAXBException {
        return XMLHelper.unmarshal(ArchiveChannel.class, file);
    }

    void saveToXML(File file) throws ArchiveException {
        try {
            XMLHelper.marshal((Object)this, file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ArchiveException(fileNotFoundException);
        }
        catch (JAXBException jAXBException) {
            throw new ArchiveException(jAXBException);
        }
    }

    private static final class Expired {
        @XmlTransient
        private String cachedUpdated;
        @XmlValue
        private String id;
        @XmlAttribute(name="updated")
        private String updated;

        private Expired() {
        }

        private Expired(ArchiveItem archiveItem) {
            this.id = archiveItem.getUniqueID();
            if (archiveItem.isUpdatedDatePresent()) {
                this.updated = archiveItem.getUpdatedDate();
            } else if (archiveItem.isPublishedDatePresent()) {
                this.updated = archiveItem.getPublishedDate();
            }
            if (this.updated != null) {
                this.updated = this.updated.trim();
            }
        }
    }
}

