/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs;

import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLayout;
import org.makagiga.commons.MList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MTextFieldPanel;
import org.makagiga.commons.MV;
import org.makagiga.commons.MainView;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.preview.DefaultPreview;
import org.makagiga.commons.validator.TextComponentValidator;
import org.makagiga.commons.validator.Validator;
import org.makagiga.editors.Editor;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSAction;
import org.makagiga.fs.FSDelete;
import org.makagiga.fs.FSException;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MetaInfoComparator;
import org.makagiga.fs.MountManager;
import org.makagiga.tags.Tags;
import org.makagiga.tree.AdvancedProperties;
import org.makagiga.tree.Tree;
import org.makagiga.tree.tracker.Tracker;
import org.makagiga.tree.tracker.TrackerEvent;
import org.makagiga.tree.version.VersionControl;
import org.makagiga.tree.version.VersionException;

public final class FSHelper {
    public static final int NO_UPDATE_COMPONENTS = 1;
    public static final int UPDATE_ID = 2;
    public static final int APPLY_PERMISSIONS = 4;

    public static void checkIfExists(String string) throws FSException {
        if (FS.exists(string)) {
            throw new FSException(UI._("File already exists"));
        }
    }

    public static void checkName(String string) throws FSException {
        if (TK.isEmpty(string)) {
            throw new FSException(UI._("Name cannot be empty"));
        }
        if (string.length() > 128) {
            throw new FSException(UI._("Name is too long"));
        }
    }

    public static void checkReadOnly() throws FSException {
        if (((Boolean)Vars.treeReadOnly.get()).booleanValue()) {
            throw new FSException(UI._("The \"Tree\" is in read only mode"));
        }
    }

    public static boolean copy(MetaInfo metaInfo, MetaInfo metaInfo2, boolean bl) throws FSException {
        return FSHelper.copy(metaInfo, metaInfo2, bl ? 4 : 0);
    }

    public static boolean copy(MetaInfo metaInfo, MetaInfo metaInfo2, int n) throws FSException {
        boolean bl;
        FSHelper.checkReadOnly();
        if (metaInfo == null) {
            return false;
        }
        if (metaInfo.isVirtualFile()) {
            return false;
        }
        if (metaInfo2 == null) {
            return false;
        }
        if (!metaInfo2.isAnyFolder() && !metaInfo2.isFSRoot()) {
            return false;
        }
        boolean bl2 = bl = (n & 4) != 0;
        if (metaInfo.isDynamicFolder()) {
            MetaInfo metaInfo3 = FSHelper.copyDynamicFolder(metaInfo, metaInfo2, n);
            if (bl) {
                AdvancedProperties.applyPermissions(metaInfo3, true);
            }
        } else if (metaInfo.isFile()) {
            MetaInfo metaInfo4 = FSHelper.copyFile(metaInfo, metaInfo2, n);
            if (bl) {
                AdvancedProperties.applyPermissions(metaInfo4, true);
            }
        } else if (metaInfo.isFolder()) {
            MetaInfo metaInfo5;
            if (metaInfo.isMount()) {
                MountManager.unmount(metaInfo);
                metaInfo5 = FSHelper.copyFolder(metaInfo, metaInfo2, n);
                MountManager.mount(metaInfo5);
                metaInfo5.getFS().scan(metaInfo5, metaInfo5.getMount());
                metaInfo5.reload();
            } else {
                metaInfo5 = FSHelper.copyFolder(metaInfo, metaInfo2, n);
                FSHelper.recursiveCopy(metaInfo, metaInfo5, n);
            }
            if (bl) {
                AdvancedProperties.applyPermissionsFromProperties(metaInfo5);
                AdvancedProperties.applyPermissions(metaInfo5, false);
            }
        }
        return true;
    }

    public static void deleteItems(boolean bl, MetaInfo ... metaInfoArray) throws FSException {
        FSHelper.deleteItems(bl, false, metaInfoArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteItems(boolean bl, boolean bl2, MetaInfo ... metaInfoArray) throws FSException {
        FSHelper.checkReadOnly();
        MArrayList<MetaInfo> mArrayList = new MArrayList<MetaInfo>();
        try {
            for (MetaInfo metaInfo : metaInfoArray) {
                FSHelper.deleteItem(mArrayList, metaInfo, bl, bl2);
            }
        }
        catch (Throwable throwable) {
            for (AbstractFS abstractFS : Tree.getInstance().getFileSystems().values()) {
                abstractFS.deleteNotify(mArrayList.toArray(MetaInfo.class));
            }
            throw throwable;
        }
        for (AbstractFS abstractFS : Tree.getInstance().getFileSystems().values()) {
            abstractFS.deleteNotify(mArrayList.toArray(MetaInfo.class));
        }
    }

    public static void deleteUI(MetaInfo ... metaInfoArray) {
        if (TK.isEmpty(metaInfoArray)) {
            return;
        }
        final MetaInfo[] metaInfoArray2 = (MetaInfo[])metaInfoArray.clone();
        Arrays.sort(metaInfoArray2, MetaInfoComparator.BY_PATH_FILES_FIRST);
        Tree tree = Tree.getInstance();
        final AbstractFS abstractFS = tree.getFS("trash");
        final BooleanProperty booleanProperty = new BooleanProperty(true);
        MDialog mDialog = new MDialog(MainView.getWindow(), UI._("Confirm"), 15){

            @Override
            protected void onUserClick() {
                if (abstractFS != null) {
                    try {
                        FSHelper.moveToTrash(abstractFS, metaInfoArray2);
                    }
                    catch (FSException fSException) {
                        MMessage.error(null, fSException);
                    }
                    this.reject();
                }
            }
        };
        mDialog.changeButton((AbstractButton)mDialog.getOKButton(), MActionInfo.DELETE);
        mDialog.getCenterPanel().setGroupLayout(true);
        MLayout mLayout = mDialog.getCenterPanel().getGroupLayout();
        StringList stringList = new StringList(metaInfoArray2.length);
        for (MetaInfo metaInfo : metaInfoArray2) {
            stringList.add(metaInfo.getNicePath());
        }
        MList<Object> mList = MMessage.createListView(MIcon.stock("ui/delete"), stringList.toArray());
        mList.setCellRenderer(MRenderer.getDefaultListCellRenderer());
        final MLabel mLabel = new MLabel();
        for (MetaInfo metaInfo : metaInfoArray2) {
            new Tree.Scanner(metaInfo){

                @Override
                public void processItem(MetaInfo metaInfo) {
                    if (abstractFS != null && ((Boolean)booleanProperty.get()).booleanValue() && metaInfo.isNodeAncestor(abstractFS.getRoot())) {
                        booleanProperty.no();
                    }
                    if (metaInfo.isMount() && TK.isEmpty(mLabel.getText())) {
                        mLabel.setText(UI._("Note: Content of the mounted directories will not be deleted"));
                    }
                }
            };
        }
        mLayout.beginRows().addScrollable((JComponent)mList, UI._("Delete selected item(s)?"));
        if (!TK.isEmpty(mLabel.getText())) {
            mLayout.addComponent(mLabel);
        }
        MCheckBox mCheckBox = new MCheckBox(UI._("Secure Delete (experimental)")){

            @Override
            protected void onClick() {
                MDialog mDialog = (MDialog)UI.windowFor(this);
                mDialog.getUserButton().setEnabled(!this.isSelected());
            }
        };
        mCheckBox.setToolTipText(UI.makeHTML(UI._("Overwrite file contents with random data before delete.") + "<br>" + UI._("Note: This feature is system-dependent<br>and may not work correctly on all platforms.")));
        mLayout.addComponent(mCheckBox);
        mLayout.end();
        if (abstractFS == null || !((Boolean)booleanProperty.get()).booleanValue()) {
            mDialog.getUserButton().setVisible(false);
        } else {
            mDialog.changeButton((AbstractButton)mDialog.getUserButton(), UI._("Move To Trash"), "fulltrashcan");
        }
        mDialog.pack();
        if (!mDialog.exec(mDialog.getCancelButton())) {
            return;
        }
        try {
            FSHelper.deleteItems(false, mCheckBox.isSelected(), metaInfoArray2);
        }
        catch (FSException fSException) {
            MMessage.error(null, fSException);
        }
    }

    public static String getUniqueName(String string, String string2) {
        return FSHelper.getUniqueName(string, string2, null);
    }

    public static String getUniqueName(String string, String string2, String string3) {
        int n = 1;
        while (true) {
            String string4 = n > 1 ? string2 + " " + n : string2;
            if (string3 != null) {
                string4 = string4 + "." + string3;
            }
            if (!FS.exists(FS.makePath(string, TK.escapeURL(string4)))) {
                return string4;
            }
            ++n;
        }
    }

    public static boolean isMakagigaFolder(String string) {
        return FS.exists(FS.makePath(string, ".properties"));
    }

    public static boolean isSameFS(List<MetaInfo> list) {
        if (list.size() == 1) {
            return true;
        }
        HashSet<AbstractFS> hashSet = new HashSet<AbstractFS>();
        for (MetaInfo metaInfo : list) {
            hashSet.add(metaInfo.getFS());
        }
        return hashSet.size() == 1;
    }

    public static String removePropertiesSuffix(String string) {
        int n = string.lastIndexOf(".properties");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static void rename(int n, MetaInfo metaInfo, String string) throws FSException {
        Object object;
        FSHelper.checkReadOnly();
        if (!metaInfo.isPermission(FSAction.RENAME)) {
            throw new FSException(UI._("No permissions to rename \"{0}\"", metaInfo.getNicePath()));
        }
        MetaInfo metaInfo2 = metaInfo.getParentFolder();
        if (metaInfo2 == null) {
            return;
        }
        String string2 = TK.escapeURL(string, 1);
        String string3 = TK.escapeURL(metaInfo.toString(), 1);
        String string4 = metaInfo.getFilePath();
        FSHelper.checkName(string2);
        if (string2.equals(string3)) {
            return;
        }
        if (metaInfo.isDynamicFolder()) {
            string2 = FS.makePath(metaInfo2.getTargetPath(), string2 + ".properties");
        } else if (metaInfo.isFile()) {
            string2 = FS.makePath(metaInfo2.getTargetPath(), string2 + "." + metaInfo.getExtension());
        } else if (metaInfo.isFolder()) {
            string2 = FS.makePath(metaInfo2.getTargetPath(), string2);
        }
        if (FS.exists(string2)) {
            throw new FSException(UI._("Item with this name already exists"));
        }
        try {
            VersionControl.rename(metaInfo, string2);
        }
        catch (VersionException versionException) {
            throw new FSException(UI._("Could not rename\n\"{0}\"\nto \"{1}\"", metaInfo.getNicePath(), string2), versionException);
        }
        if (!FS.rename(metaInfo.getFilePath(), string2)) {
            throw new FSException(UI._("Could not rename\n\"{0}\"\nto \"{1}\"", metaInfo.getNicePath(), string2));
        }
        if (metaInfo.isDynamicFolder()) {
            metaInfo.setFilePath(string2);
        } else if (metaInfo.isFile()) {
            FS.rename(metaInfo.getFilePath() + ".properties", string2 + ".properties");
            metaInfo.setFilePath(string2);
        } else if (metaInfo.isFolder()) {
            object = metaInfo.getFilePath();
            String string5 = string2;
            metaInfo.setFilePath(string2);
            new Tree.Scanner(metaInfo, false, (String)object, string5){
                final /* synthetic */ String val$OLD_PATH;
                final /* synthetic */ String val$NEW_PATH;
                {
                    this.val$OLD_PATH = string;
                    this.val$NEW_PATH = string2;
                    super(metaInfo, bl);
                }

                @Override
                public void processItem(MetaInfo metaInfo) {
                    String string = metaInfo.getFilePath();
                    if (string.startsWith(this.val$OLD_PATH + File.separator)) {
                        String string2 = this.val$NEW_PATH + string.substring(this.val$OLD_PATH.length());
                        metaInfo.setFilePath(string2);
                    }
                }
            };
        }
        Tracker.add(metaInfo, TrackerEvent.ID.ITEM_RENAMED, string4);
        object = new Flags(n);
        if (((Flags)object).isClear(1L)) {
            MainWindow.getInstance().updateComponents(metaInfo);
        }
    }

    public static void renameUI(int n, MetaInfo metaInfo, String string) {
        try {
            FSHelper.rename(n, metaInfo, string);
        }
        catch (FSException fSException) {
            MMessage.error(null, fSException);
        }
    }

    public static void renameUI(Window window, MetaInfo metaInfo) {
        if (!metaInfo.isPermission(FSAction.RENAME)) {
            return;
        }
        MMessage<MTextFieldPanel> mMessage = MMessage.createInputMessage(window, metaInfo.toString(), UI._("New Name:"), UI._("Rename"), null, "rename");
        MTextField mTextField = mMessage.getView().getTextField();
        mMessage.getValidatorSupport().add(0, new NameValidator(mTextField));
        mMessage.installValidatorMessage();
        if (mMessage.exec(mTextField)) {
            FSHelper.renameUI(0, metaInfo, mTextField.getText());
        }
    }

    private FSHelper() {
    }

    private static MetaInfo copyDynamicFolder(MetaInfo metaInfo, MetaInfo metaInfo2, int n) throws FSException {
        metaInfo.sync();
        String string = metaInfo.getFilePath();
        String string2 = new File(string).getName();
        String string3 = FSHelper.removePropertiesSuffix(string2);
        String string4 = FS.makePath(metaInfo2.getTargetPath(), TK.escapeURL(FSHelper.getUniqueName(metaInfo2.getTargetPath(), TK.unescapeURL(string3), "properties")));
        MLogger.debug("vfs", "COPY DYNAMIC FOLDER: source=\"%s\" destination=\"%s\"", string, string4);
        try {
            FS.copyFile(string, string4);
            FSHelper.updateID(string4, n);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            FSHelper.copyException(metaInfo, metaInfo2);
        }
        MetaInfo metaInfo3 = MetaInfo.createDynamicFolder(metaInfo2.getFS(), string4);
        Tree.getInstance().addItem(metaInfo2, metaInfo3);
        metaInfo3.setFS(metaInfo.getFS());
        return metaInfo3;
    }

    private static void copyException(MetaInfo metaInfo, MetaInfo metaInfo2) throws FSException {
        throw new FSException(UI._("Could not copy \"{0}\" to \"{1}\"", metaInfo.getNicePath(), metaInfo2.getNicePath()));
    }

    private static MetaInfo copyFile(MetaInfo metaInfo, MetaInfo metaInfo2, int n) throws FSException {
        Tabs tabs = Tabs.getInstance();
        int n2 = tabs.findEditor(metaInfo);
        if (n2 != -1 && !tabs.saveEditor((Editor)tabs.getTabAt(n2), 1)) {
            FSHelper.copyException(metaInfo, metaInfo2);
        }
        metaInfo.sync();
        String string = metaInfo.getFilePath();
        String string2 = FS.getExtension(string);
        String string3 = new File(string).getName();
        String string4 = FS.getBaseName(string3);
        String string5 = TK.escapeURL(FSHelper.getUniqueName(metaInfo2.getTargetPath(), TK.unescapeURL(string4), string2));
        String string6 = FS.makePath(metaInfo2.getTargetPath(), string5);
        MLogger.debug("vfs", "COPY FILE: source=\"%s\" destination=\"%s\"", string, string6);
        try {
            FS.copyFile(string, string6);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            FSHelper.copyException(metaInfo, metaInfo2);
        }
        try {
            FS.copyFile(metaInfo.getFilePath() + ".properties", string6 + ".properties");
            FSHelper.updateID(string6 + ".properties", n);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
        try {
            VersionControl.copy(metaInfo, metaInfo2.getTargetPath(), string5);
        }
        catch (VersionException versionException) {
            FSHelper.copyException(metaInfo, metaInfo2);
        }
        MetaInfo metaInfo3 = MetaInfo.createFile(metaInfo2.getFS(), string6, string2);
        Tree.getInstance().addItem(metaInfo2, metaInfo3);
        metaInfo3.setFS(metaInfo.getFS());
        return metaInfo3;
    }

    private static MetaInfo copyFolder(MetaInfo metaInfo, MetaInfo metaInfo2, int n) throws FSException {
        metaInfo.sync();
        String string = metaInfo.getFilePath();
        String string2 = new File(string).getName();
        String string3 = FSHelper.getUniqueName(metaInfo2.getTargetPath(), TK.unescapeURL(string2));
        String string4 = FS.makePath(metaInfo2.getTargetPath(), TK.escapeURL(string3));
        MLogger.debug("vfs", "COPY FOLDER: source=\"%s\" destination=\"%s\"", string, string4);
        if (!FS.mkdirs(string4)) {
            FSHelper.copyException(metaInfo, metaInfo2);
        }
        string = FS.makePath(string, ".properties");
        string4 = FS.makePath(string4, ".properties");
        MLogger.debug("vfs", "COPY FOLDER PROPERTIES: source=\"%s\" destination=\"%s\"", string, string4);
        try {
            FS.copyFile(string, string4);
            FSHelper.updateID(string4, n);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
        MetaInfo metaInfo3 = metaInfo2.getFS().createFolder(metaInfo2, string3, null, false);
        if (metaInfo3 == null) {
            FSHelper.copyException(metaInfo, metaInfo2);
        }
        metaInfo3.setFS(metaInfo.getFS());
        return metaInfo3;
    }

    private static void deleteException(MetaInfo metaInfo) throws FSException {
        throw new FSException(UI._("Could not delete \"{0}\"", metaInfo.getNicePath()));
    }

    private static void deleteFile(MetaInfo metaInfo, boolean bl) throws FSException {
        Tabs tabs = Tabs.getInstance();
        tabs.closeEditorAt(tabs.findEditor(metaInfo), 1);
        String string = metaInfo.getFilePath();
        String string2 = string + ".properties";
        MLogger.debug("vfs", "DELETE FILE: " + string);
        FSHelper.deleteFile(string2, bl);
        try {
            VersionControl.deleteAllVersions(metaInfo, false, bl);
        }
        catch (VersionException versionException) {
            MLogger.exception(versionException);
        }
        metaInfo.invalidatePreview(false);
        DefaultPreview.getInstance().removePreview(new File(string));
        if (!FSHelper.deleteFile(string, bl)) {
            FSHelper.deleteException(metaInfo);
        }
    }

    private static boolean deleteFile(String string, boolean bl) {
        if (bl) {
            MLogger.debug("vfs", "Secure delete: %s", string);
            try {
                FS.secureDelete(new File(string));
                return true;
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
                return FS.deleteFile(string);
            }
        }
        MLogger.debug("vfs", "Normal delete: %s", string);
        return FS.deleteFile(string);
    }

    private static void deleteFolder(MetaInfo metaInfo, boolean bl) throws FSException {
        String string = metaInfo.getFilePath();
        String string2 = FS.makePath(string, ".properties");
        MLogger.debug("vfs", "DELETE FOLDER: " + string);
        FSHelper.deleteFile(string2, bl);
        if (!FS.deleteFile(string)) {
            FSHelper.deleteException(metaInfo);
        }
    }

    private static void deleteItem(List<MetaInfo> list, MetaInfo metaInfo, boolean bl, boolean bl2) throws FSException {
        if (!metaInfo.isPermission(FSAction.DELETE)) {
            throw new FSException(UI._("No permissions to delete \"{0}\".\nPlease make sure that the selected item is unlocked.", metaInfo.getNicePath()));
        }
        Tree tree = Tree.getInstance();
        if (metaInfo.isLink()) {
            MetaInfo metaInfo2 = metaInfo.getLink();
            MLogger.debug("vfs", "DELETE LINK: " + metaInfo);
            if (metaInfo2 != metaInfo) {
                MLogger.debug("vfs", "DELETE LINK TARGET: " + metaInfo2);
                FSHelper.deleteItem(list, metaInfo2, bl, bl2);
            }
            tree.deleteItem(metaInfo);
            list.add(metaInfo2);
        } else if (metaInfo.isDynamicFolder()) {
            if (!FSHelper.deleteFile(metaInfo.getFilePath(), bl2)) {
                FSHelper.deleteException(metaInfo);
            }
            tree.deleteItem(metaInfo);
            list.add(metaInfo);
        } else if (metaInfo.isVirtualFile()) {
            tree.deleteItem(metaInfo);
            list.add(metaInfo);
        } else if (metaInfo.isFile()) {
            FSHelper.deleteFile(metaInfo, bl2);
            tree.deleteItem(metaInfo);
            list.add(metaInfo);
        } else if (metaInfo.isFolder()) {
            if (metaInfo.isMount()) {
                tree.removeAllChildren(metaInfo);
                MountManager.unmount(metaInfo);
            } else {
                FSHelper.recursiveDelete(list, metaInfo, bl, bl2);
            }
            FSHelper.deleteFolder(metaInfo, bl2);
            tree.deleteItem(metaInfo);
            list.add(metaInfo);
        } else {
            MLogger.warning("fs", "Cannot delete: %s", metaInfo);
        }
        if (metaInfo.getFS() instanceof FSDelete) {
            ((FSDelete)FSDelete.class.cast(metaInfo.getFS())).deleteItem(metaInfo, bl);
        }
        Tags.clearAll();
    }

    private static void moveToTrash(AbstractFS abstractFS, MetaInfo ... metaInfoArray) throws FSException {
        abstractFS.importMetaInfos(abstractFS.getRoot(), true, Arrays.asList(metaInfoArray));
    }

    private static void recursiveCopy(MetaInfo metaInfo, MetaInfo metaInfo2, int n) throws FSException {
        for (MetaInfo metaInfo3 : metaInfo.list(MV.MODEL)) {
            FSHelper.copy(metaInfo3, metaInfo2, n);
        }
    }

    private static void recursiveDelete(List<MetaInfo> list, MetaInfo metaInfo, boolean bl, boolean bl2) throws FSException {
        for (MetaInfo metaInfo2 : metaInfo.list(MV.MODEL)) {
            FSHelper.deleteItem(list, metaInfo2, bl, bl2);
        }
    }

    private static void updateID(String string, int n) {
        if ((n & 2) == 0) {
            return;
        }
        MLogger.debug("fs", "Updating properties ID: %s", string);
        Config config = new Config(string);
        if (!config.isError()) {
            config.write("id", TK.createRandomUUID());
            config.sync();
        }
    }

    public static class NameValidator
    extends TextComponentValidator {
        private static boolean egg = true;

        public NameValidator() {
        }

        public NameValidator(MTextField mTextField) {
            super(mTextField);
        }

        @Override
        protected boolean isValid() throws Exception {
            String string = this.getText();
            this.setMessageType(Validator.MessageType.ERROR);
            FSHelper.checkName(string);
            if (string.trim().isEmpty()) {
                throw new FSException(UI._("Name cannot be empty"));
            }
            if (egg && "JAVA".equalsIgnoreCase(string)) {
                egg = false;
                this.setMessageType(Validator.MessageType.INFO);
                throw new Exception("Damn good coffee!");
            }
            return true;
        }
    }
}

