/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.ghns;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.makagiga.commons.ItemStatus;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MRating;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public abstract class StuffRenderer<T>
extends MRenderer<T> {
    private final Dimension imageSize = new Dimension();
    private ItemStatus extra;
    private ItemStatus status;
    private MLabel image;
    private MLabel name;
    private MLabel summary;
    private MLabel version;
    private MRating rating;

    public StuffRenderer() {
        this(MIcon.getUISize());
    }

    public StuffRenderer(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public StuffRenderer(int n) {
        this(n, n);
    }

    @Deprecated
    public StuffRenderer(int n, int n2) {
        super(5, null);
        this.imageSize.setSize(n, n2);
        this.initView();
    }

    public MLabel getImageLabel() {
        return this.image;
    }

    public void setExtra(String string, Color color, String string2) {
        this.extra.setText(string, this.convertFG(color));
        UI.setStyle(string2, this.extra);
        this.extra.setVisible(!TK.isEmpty(string));
    }

    public void setImage(Icon icon) {
        this.image.setIcon(icon);
    }

    public void setImage(Image image) {
        this.image.setImage(image);
    }

    public void setName(String string) {
        this.name.setText(string);
        this.name.setVisible(!TK.isEmpty(string));
    }

    public void setRating(float f) {
        float f2 = f < 0.2f ? 0.0f : f;
        this.rating.setValue(f2);
        this.rating.setVisible(f2 != 0.0f);
    }

    public void setRating(int n) {
        this.setRating((float)TK.range(n, 0, 0, 100) / 100.0f);
    }

    public void setStatus(String string, Color color, String string2) {
        this.status.setText(string, this.convertFG(color));
        UI.setStyle(string2, this.status);
        this.status.setVisible(!TK.isEmpty(string));
    }

    public void setSummary(String string) {
        if (TK.isEmpty(string)) {
            this.summary.setStyle("font-style: italic");
            this.summary.setText(UI._("No Summary"));
        } else {
            this.summary.setStyle("font-style: normal");
            this.summary.setText(string);
        }
    }

    public void setVersion(String string) {
        this.version.setText(string);
        this.version.setVisible(!TK.isEmpty(string));
    }

    @Override
    protected JComponent createView() {
        Font font = UI.createDefaultFont();
        this.extra = new ItemStatus(font);
        this.image = new MLabel();
        this.image.setHorizontalAlignment(0);
        this.image.setHorizontalTextPosition(0);
        this.name = new MLabel();
        this.name.setStyle("font-weight: bold");
        this.summary = new MLabel();
        this.version = new MLabel();
        this.rating = new MRating();
        this.rating.setVisible(false);
        this.status = new ItemStatus(font);
        this.status.setVisible(false);
        UI.setStyle("margin: 2px", this.extra, this.status);
        MRenderer.OptimizedPanel optimizedPanel = new MRenderer.OptimizedPanel(true);
        optimizedPanel.getGroupLayout().addGap().addFixedComponent(this.image, true, this.imageSize).addContentGap().beginRows().beginColumns().addComponent(this.name).addComponent(this.version).end().addHStretchComponent(this.summary).addComponent(this.rating).addComponent(this.status).end().addComponent((Component)this.extra, true);
        return optimizedPanel;
    }

    protected abstract void onRenderStuff(T var1);

    @Override
    protected final void onRender(T t) {
        this.name.setForeground(null);
        this.summary.setForeground(null);
        this.version.setForeground(null);
        this.setToolTipText(null);
        this.onRenderStuff(t);
        if (this.getToolTipText() == null && this.summary.getText() != null) {
            this.setToolTipText(this.summary.getText());
        }
    }

    private Color convertFG(Color color) {
        return color == null ? null : MColor.getBrighter(color, 85);
    }
}

