/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.opendocument;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.table.TableModel;
import org.makagiga.commons.FS;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MZip;
import org.makagiga.commons.XMLBuilder;
import org.makagiga.opendocument.Content;
import org.makagiga.opendocument.Manifest;
import org.makagiga.opendocument.SpreadsheetWriter;
import org.makagiga.opendocument.TextWriter;

@Deprecated
public abstract class DocumentWriter
implements Closeable {
    protected ByteArrayOutputStream byteStream;
    protected Content content;
    protected Manifest manifest = new Manifest();
    protected MZip zip;
    protected Object defaultContent;
    protected PrintStream printStream;

    public DocumentWriter(OutputStream outputStream) throws IOException {
        this.init(outputStream);
    }

    public DocumentWriter(String string) throws IOException {
        File file = new File(string);
        String string2 = string;
        String string3 = file.getName();
        if (FS.getExtension(string3) == null) {
            string2 = string2 + this.getExtension();
        }
        this.init(new FS.BufferedFileOutput(string2));
    }

    @Override
    public void close() throws IOException {
        this.endContent();
        this.writeManifest();
        FS.close(this.zip);
    }

    public Content beginDefaultContent() throws IOException {
        this.beginContent();
        if (this instanceof SpreadsheetWriter) {
            this.defaultContent = this;
            this.content.beginSpreadsheet();
        } else if (this instanceof TextWriter) {
            this.defaultContent = this;
            this.content.beginText();
        } else {
            this.defaultContent = null;
            throw new UnsupportedOperationException("Cannot detect the default content");
        }
        return this.content;
    }

    public abstract String getExtension();

    public abstract String getMimeType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String string, OutputStream outputStream) throws IOException {
        TextWriter textWriter = null;
        try {
            textWriter = new TextWriter(outputStream);
            Content content = textWriter.beginDefaultContent();
            content.addTextBlock(string);
        }
        catch (Throwable throwable) {
            FS.close(textWriter);
            throw throwable;
        }
        FS.close(textWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String string, TableModel tableModel, Content.TableModelFilter tableModelFilter, OutputStream outputStream) throws IOException {
        SpreadsheetWriter spreadsheetWriter = null;
        try {
            spreadsheetWriter = new SpreadsheetWriter(outputStream);
            Content content = spreadsheetWriter.beginDefaultContent();
            content.beginTable(string);
            content.addTableModel(tableModel, tableModelFilter);
            content.endTable();
        }
        catch (Throwable throwable) {
            FS.close(spreadsheetWriter);
            throw throwable;
        }
        FS.close(spreadsheetWriter);
    }

    protected Content beginContent() throws IOException {
        this.beginEntry("content.xml", "text/xml");
        this.content = new Content();
        return this.content;
    }

    protected void beginEntry(String string) throws IOException {
        this.zip.beginEntry(string);
        this.byteStream = new ByteArrayOutputStream(4096);
        this.printStream = new PrintStream((OutputStream)this.byteStream, false, "UTF8");
    }

    protected void beginEntry(String string, String string2) throws IOException {
        this.beginEntry(string);
        this.manifest.addFileEntry(string2, string);
    }

    protected void endContent() throws IOException {
        if (this.defaultContent instanceof SpreadsheetWriter) {
            this.content.endSpreadsheet();
        } else if (this.defaultContent instanceof TextWriter) {
            this.content.endText();
        }
        this.content.end();
        this.content.save(this.zip.getOutputStream(), false);
        this.content = null;
        this.endEntry();
    }

    protected void endEntry() throws IOException {
        this.zip.copyToEntry(new ByteArrayInputStream(this.byteStream.toByteArray()));
        FS.close(this.byteStream);
        FS.close(this.printStream);
        this.byteStream = null;
        this.printStream = null;
    }

    protected void writeManifest() throws IOException {
        this.beginEntry("META-INF/manifest.xml");
        this.manifest.write(this.printStream, this.getMimeType());
        this.endEntry();
    }

    protected void writeMeta() throws IOException {
        this.beginEntry("meta.xml", "text/xml");
        XMLBuilder xMLBuilder = new XMLBuilder();
        xMLBuilder.beginTag("office:document-meta", "xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0", "xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "office:version", "1.0");
        xMLBuilder.beginTag("office:meta");
        xMLBuilder.doubleTag("meta:generator", XMLBuilder.escape(MApplication.getFullName() + "/" + MApplication.getFullVersion()), new Object[0]);
        xMLBuilder.doubleTag("meta:creation-date", XMLBuilder.escape(MDate.now().format("yyyy-MM-dd'T'HH:mm:ss")), new Object[0]);
        xMLBuilder.endTag("office:meta");
        xMLBuilder.endTag("office:document-meta");
        xMLBuilder.save(this.printStream, false);
        this.endEntry();
    }

    protected void writeMimeType() throws IOException {
        this.beginEntry("mimetype");
        this.printStream.print(this.getMimeType());
        this.endEntry();
    }

    protected void writeSettings() throws IOException {
        this.beginEntry("settings.xml", "text/xml");
        XMLBuilder xMLBuilder = new XMLBuilder();
        xMLBuilder.beginTag("office:document-settings", "xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0", "xmlns:config", "urn:oasis:names:tc:opendocument:xmlns:config:1.0", "office:version", "1.0");
        xMLBuilder.endTag("office:document-settings");
        xMLBuilder.save(this.printStream, false);
        this.endEntry();
    }

    protected void writeStyles() throws IOException {
        this.beginEntry("styles.xml", "text/xml");
        XMLBuilder xMLBuilder = new XMLBuilder();
        xMLBuilder.beginTag("office:document-styles", "xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0", "office:version", "1.0");
        xMLBuilder.endTag("office:document-styles");
        xMLBuilder.save(this.printStream, false);
        this.endEntry();
    }

    private void init(OutputStream outputStream) throws IOException {
        this.zip = MZip.write(outputStream);
        this.writeMeta();
        this.writeMimeType();
        this.writeSettings();
        this.writeStyles();
    }
}

