/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.awt.Window;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MFileChooser;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.MZip;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.plugins.LookAndFeelSettings;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginType;

public final class PluginInstaller {
    @Deprecated
    public static final int SHOW_RESTART_INFO = 1;
    public static final int UPDATE = 2;

    public static File getTargetFile(File file, String string) {
        String string2 = file.getPath();
        return new File(string2.substring(0, string2.length() - string.length()) + ".jar");
    }

    public static void install(Window window, File file) throws PluginException {
        PluginInstaller.install(window, file, 0);
    }

    public static void install(Window window, File file, int n) throws PluginException {
        Serializable serializable;
        MProperties mProperties = PluginInstaller.getPluginProperties(file);
        MLogger.info("plugin", "Installing \"%s\"...", file);
        String string = FS.makeConfigPath("plugins", 1);
        MZip mZip = null;
        try {
            mZip = MZip.read(file);
            mZip.unpackTo(string, 1);
            if (mProperties != null) {
                String string2;
                serializable = Config.getDefault();
                String string3 = mProperties.getProperty("String.id");
                String string4 = mProperties.getProperty("String.type");
                if ((n & 2) == 0 && PluginType.LOOK_AND_FEEL.getType().equals(string4) && !TK.isEmpty(string2 = mProperties.getProperty("String.x.lafClassName"))) {
                    MLogger.info("plugin", "Setting default Look And Feel: %s", string2);
                    LookAndFeelSettings.writeLAFConfig((Config)serializable, string2, true);
                }
                ((Config)serializable).removeBoolean("Plugin.enabled." + string3);
                ((Config)serializable).sync();
            }
        }
        catch (Exception exception) {
            throw new PluginException(UI._("Installation failed"), exception);
        }
        finally {
            FS.close(mZip);
        }
        serializable = new Flags(n);
        if (((Flags)serializable).isSet(1L)) {
            MMessage.info(window, "Installation successful.\nRestart application to apply changes.");
        }
    }

    public static boolean showInstallDialog(Window window) {
        MFileChooser mFileChooser = MFileChooser.createFileChooser(window, UI._("Select a Makagiga Plugin you want to install"));
        mFileChooser.addFilter(UI._("Makagiga Plugin"), "mgplugin");
        mFileChooser.setApproveText(UI._("Install"));
        mFileChooser.setConfigKey("plugin");
        if (mFileChooser.openDialog()) {
            try {
                PluginInstaller.install(window, mFileChooser.getSelectedFile());
                return true;
            }
            catch (PluginException pluginException) {
                MMessage.error(window, pluginException);
            }
        }
        return false;
    }

    public static void unpackJar(File file, File file2, boolean bl) throws IOException {
        MLogger.info("plugin", "Unpacking \"%s\"...", file.getPath());
        FilterInputStream filterInputStream = null;
        JarOutputStream jarOutputStream = null;
        String string = file2.getPath() + ".tmp";
        try {
            filterInputStream = new FS.BufferedFileInput(file);
            if (bl) {
                filterInputStream = new GZIPInputStream(filterInputStream);
            }
            jarOutputStream = new JarOutputStream(new FS.BufferedFileOutput(string));
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            unpacker.unpack((InputStream)filterInputStream, jarOutputStream);
            FS.close(filterInputStream);
            FS.close(jarOutputStream);
            file2.delete();
            FS.rename(string, file2.getPath());
            if (!file.equals(file2)) {
                file.delete();
            }
        }
        catch (IOException iOException) {
            try {
                FS.deleteFile(string);
                throw iOException;
            }
            catch (Throwable throwable) {
                FS.close(filterInputStream);
                FS.close(jarOutputStream);
                throw throwable;
            }
        }
        FS.close(filterInputStream);
        FS.close(jarOutputStream);
    }

    public static void unpackJars(String string) throws IOException {
        String string2 = ".jar.pack.gz";
        for (File file : FS.listFiles(new File(string), FS.FILE_FILTER)) {
            if (!file.getPath().endsWith(string2)) continue;
            PluginInstaller.unpackJar(file, PluginInstaller.getTargetFile(file, string2), true);
        }
    }

    private PluginInstaller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MProperties getPluginProperties(File file) {
        MZip mZip = null;
        try {
            mZip = MZip.read(file);
            for (ZipEntry zipEntry : mZip) {
                if (zipEntry.isDirectory() || !zipEntry.getName().endsWith("}/plugin.properties")) continue;
                MProperties mProperties = new MProperties();
                mProperties.loadUTF8(mZip.getInputStream());
                MProperties mProperties2 = mProperties;
                return mProperties2;
            }
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
        finally {
            FS.close(mZip);
        }
        return null;
    }
}

