/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.plugins;

import java.awt.Color;
import org.makagiga.commons.MColor;
import org.makagiga.commons.UI;
import org.makagiga.ghns.StuffRenderer;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginType;

public class PluginRenderer
extends StuffRenderer<PluginInfo> {
    private boolean showVersion;
    boolean showType;

    public PluginRenderer(boolean bl) {
        this.showVersion = bl;
    }

    protected String getDisplayName(PluginInfo pluginInfo) {
        return pluginInfo.toString();
    }

    @Override
    protected void onRenderStuff(PluginInfo pluginInfo) {
        Object object;
        this.setImage(pluginInfo.getIcon());
        this.setName(this.getDisplayName(pluginInfo));
        String string = (String)pluginInfo.shortDescription.get();
        if (string == null) {
            string = "";
        }
        if (this.showType && (object = PluginType.fromType((String)pluginInfo.type.get())) != null) {
            string = "[" + ((PluginType)((Object)object)).getText() + "] " + string;
        }
        this.setSummary(string);
        if (this.showVersion && !pluginInfo.isInternal()) {
            this.setVersion(pluginInfo.version.toString());
        } else {
            this.setVersion(null);
        }
        object = "font-weight: bold";
        if (((Boolean)pluginInfo.test.get()).booleanValue()) {
            this.setExtra(UI._("Test"), Color.BLUE, (String)object);
        } else if (((Boolean)pluginInfo.enabled.get()).booleanValue()) {
            this.setExtra(null, null, null);
        } else {
            this.setExtra(pluginInfo.isCompatible() ? UI._("Disabled") : UI._("Incompatible"), MColor.DARK_RED, (String)object);
        }
    }
}

