/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.util.Comparator;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.makagiga.commons.MDate;
import org.makagiga.commons.TK;
import org.makagiga.todo.Column;
import org.makagiga.todo.Priority;
import org.makagiga.todo.Task;

public class Sorter<M extends TableModel>
extends TableRowSorter<M> {
    public Sorter(M m) {
        super(m);
        this.setSortsOnUpdates(false);
        this.setComparator(Column.DONE.ordinal(), new Comparator<Boolean>(){

            @Override
            public int compare(Boolean bl, Boolean bl2) {
                return bl.compareTo(bl2);
            }
        });
        this.setComparator(Column.PRIORITY.ordinal(), new Comparator<Priority>(){

            @Override
            public int compare(Priority priority, Priority priority2) {
                return priority.compareTo(priority2);
            }
        });
        this.setComparator(Column.COMPLETE.ordinal(), new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return n.compareTo(n2);
            }
        });
        Comparator<MDate> comparator = new Comparator<MDate>(){

            @Override
            public int compare(MDate mDate, MDate mDate2) {
                return mDate.compareTo(mDate2);
            }
        };
        this.setComparator(Column.DATE_TIME.ordinal(), comparator);
        this.setComparator(Column.COMPLETE_DATE_TIME.ordinal(), comparator);
        this.setComparator(Column.START_DATE_TIME.ordinal(), comparator);
        this.setComparator(Column.CIRCLE.ordinal(), new Comparator<Task>(){

            @Override
            public int compare(Task task, Task task2) {
                return TK.compare(task.getComplete(), task2.getComplete());
            }
        });
    }

    @Override
    protected boolean useToString(int n) {
        return n == Column.CATEGORY.ordinal() || n == Column.SUMMARY.ordinal();
    }
}

