/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.io.Serializable;
import java.util.Comparator;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;
import org.makagiga.todo.Column;
import org.makagiga.todo.Task;

public abstract class TaskComparator
implements Comparator<Task>,
Serializable {
    public static final TaskComparator BY_CATEGORY = new ByCategory();
    public static final TaskComparator BY_COMPLETE = new ByComplete();
    public static final TaskComparator BY_COMPLETE_DATE_TIME = new ByCompleteDateTime();
    public static final TaskComparator BY_DATE_TIME = new ByDateTime();
    public static final TaskComparator BY_DONE = new ByDone();
    public static final TaskComparator BY_PRIORITY = new ByPriority();
    public static final TaskComparator BY_START_DATE_TIME = new ByStartDateTime();
    public static final TaskComparator BY_SUMMARY = new BySummary();

    @Override
    public int compare(Task task, Task task2) {
        int n = this.compareValues(task, task2);
        if (n == 0) {
            n = this.compareValues2(task, task2);
        }
        return n;
    }

    public static TaskComparator get(Column column) {
        switch (column) {
            case DONE: {
                return BY_DONE;
            }
            case SUMMARY: {
                return BY_SUMMARY;
            }
            case PRIORITY: {
                return BY_PRIORITY;
            }
            case COMPLETE: {
                return BY_COMPLETE;
            }
            case DATE_TIME: {
                return BY_DATE_TIME;
            }
            case START_DATE_TIME: {
                return BY_START_DATE_TIME;
            }
            case COMPLETE_DATE_TIME: {
                return BY_COMPLETE_DATE_TIME;
            }
            case CATEGORY: {
                return BY_CATEGORY;
            }
            case CIRCLE: {
                return BY_COMPLETE;
            }
        }
        throw new WTFError(column);
    }

    protected abstract int compareValues(Task var1, Task var2);

    protected int compareValues2(Task task, Task task2) {
        return BY_SUMMARY.compare(task, task2);
    }

    private TaskComparator() {
    }

    private static final class BySummary
    extends TaskComparator {
        private BySummary() {
        }

        @Override
        protected int compareValues(Task task, Task task2) {
            return TK.compareIgnoreCase(task.getSummary(), task2.getSummary(), "");
        }

        @Override
        protected int compareValues2(Task task, Task task2) {
            return 0;
        }
    }

    private static final class ByStartDateTime
    extends TaskComparator {
        private ByStartDateTime() {
        }

        @Override
        protected int compareValues(Task task, Task task2) {
            return task.getStartDateTime().compareTo(task2.getStartDateTime());
        }
    }

    private static final class ByPriority
    extends TaskComparator {
        private ByPriority() {
        }

        @Override
        protected int compareValues(Task task, Task task2) {
            return task.getPriority().compareTo(task2.getPriority()) * -1;
        }
    }

    private static final class ByDone
    extends TaskComparator {
        private ByDone() {
        }

        @Override
        protected int compareValues(Task task, Task task2) {
            return Boolean.valueOf(task.isDone()).compareTo(task2.isDone());
        }
    }

    private static final class ByDateTime
    extends TaskComparator {
        private ByDateTime() {
        }

        @Override
        protected int compareValues(Task task, Task task2) {
            return task.getDateTime().compareTo(task2.getDateTime());
        }
    }

    private static final class ByCompleteDateTime
    extends TaskComparator {
        private ByCompleteDateTime() {
        }

        @Override
        protected int compareValues(Task task, Task task2) {
            return task.getCompleteDateTime().compareTo(task2.getCompleteDateTime());
        }
    }

    private static final class ByComplete
    extends TaskComparator {
        private ByComplete() {
        }

        @Override
        protected int compareValues(Task task, Task task2) {
            return TK.compare(task.getComplete(), task2.getComplete());
        }
    }

    private static final class ByCategory
    extends TaskComparator {
        private ByCategory() {
        }

        @Override
        protected int compareValues(Task task, Task task2) {
            return TK.compareIgnoreCase(task.getCategory(), task2.getCategory(), "");
        }
    }
}

