/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.makagiga.chart.ChartModel;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.Config;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MCalendar;
import org.makagiga.commons.MCellTip;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDataTransfer;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MDateSpinner;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MTable;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MUndoManager;
import org.makagiga.commons.MV;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.category.CategoryListEditor;
import org.makagiga.commons.category.CategoryListRenderer;
import org.makagiga.commons.category.CategoryManager;
import org.makagiga.commons.mv.BooleanRenderer;
import org.makagiga.commons.swing.Input;
import org.makagiga.todo.CircleEditor;
import org.makagiga.todo.CircleRenderer;
import org.makagiga.todo.Column;
import org.makagiga.todo.CompleteEditor;
import org.makagiga.todo.CompleteRenderer;
import org.makagiga.todo.DateTimeEditor;
import org.makagiga.todo.DateTimeRenderer;
import org.makagiga.todo.Filter;
import org.makagiga.todo.Priority;
import org.makagiga.todo.PriorityEditor;
import org.makagiga.todo.PriorityRenderer;
import org.makagiga.todo.Sorter;
import org.makagiga.todo.SummaryEditor;
import org.makagiga.todo.SummaryRenderer;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskModel;
import org.makagiga.todo.TaskSelection;
import org.makagiga.todo.TaskState;

public class TaskTable
extends MTable<TaskModel> {
    public static final MActionInfo DELETE_COMPLETED = new MActionInfo(UI._("Delete Completed"), "ui/complete", 68, 3);
    public static final MActionInfo DELETE_SELECTED = new MActionInfo(UI._("Delete Selected"), "ui/delete", 127, 0);
    private ActionGroup editActionGroup = new ActionGroup();
    private ChangeListener categoryChangeListener;
    private int fontSize = -1;
    private ListSelectionListener listSelectionListener;
    private final MUndoManager undoManager;
    private final Sorter<TaskModel> sorter;
    private TableCellEditor categoryEditor;
    private TableCellEditor circleEditor;
    private TableCellEditor completeEditor;
    private TableCellEditor dateTimeEditor;
    private TableCellEditor doneEditor;
    private TableCellEditor priorityEditor;
    private TableCellEditor summaryEditor;
    private UndoableEditListener undoableEditListener;

    public TaskTable() {
        super(new TaskModel());
        this.getColumnManager().setDefaultColumnOrder(Column.CIRCLE, Column.DONE, Column.SUMMARY, Column.DATE_TIME, Column.PRIORITY, Column.CATEGORY);
        this.getColumnManager().updateProperties();
        this.setAutoResizeMode(0);
        this.setSurrendersFocusOnKeystroke(true);
        TableColumn tableColumn = this.getTaskColumn(Column.DONE);
        tableColumn.setCellRenderer(new BooleanRenderer());
        tableColumn = this.getTaskColumn(Column.SUMMARY);
        tableColumn.setCellRenderer(new SummaryRenderer());
        tableColumn = this.getTaskColumn(Column.PRIORITY);
        tableColumn.setCellRenderer(new PriorityRenderer());
        tableColumn = this.getTaskColumn(Column.COMPLETE);
        tableColumn.setCellRenderer(new CompleteRenderer());
        DateTimeRenderer dateTimeRenderer = new DateTimeRenderer();
        tableColumn = this.getTaskColumn(Column.DATE_TIME);
        tableColumn.setCellRenderer(dateTimeRenderer);
        tableColumn = this.getTaskColumn(Column.START_DATE_TIME);
        tableColumn.setCellRenderer(dateTimeRenderer);
        tableColumn = this.getTaskColumn(Column.COMPLETE_DATE_TIME);
        tableColumn.setCellRenderer(dateTimeRenderer);
        tableColumn = this.getTaskColumn(Column.CATEGORY);
        tableColumn.setCellRenderer(new CategoryListRenderer(CategoryManager.getSharedInstance()));
        tableColumn = this.getTaskColumn(Column.CIRCLE);
        tableColumn.setCellRenderer(new CircleRenderer());
        this.sorter = new Sorter(this.getModel());
        this.setRowSorter(this.sorter);
        this.initDragAndDrop();
        this.categoryChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TaskTable.this.repaint();
            }
        };
        CategoryManager.getSharedInstance().addChangeListener(this.categoryChangeListener);
        this.undoManager = new MUndoManager(this, -1){

            @Override
            public void updateUserActions() {
                JComponent jComponent = this.getOwner();
                if (jComponent instanceof TaskTable) {
                    ((TaskTable)TaskTable.class.cast(jComponent)).getEditActionGroup().update();
                }
            }
        };
        this.undoableEditListener = this.undoManager.createUndoableEditListener();
        ((TaskModel)this.getModel()).addUndoableEditListener(this.undoableEditListener);
        this.editActionGroup = new EditActionGroup(this);
        this.editActionGroup.add("undo", this.undoManager.getUndoAction()).setShowTextInToolBar(true);
        this.editActionGroup.add("redo", this.undoManager.getRedoAction());
        this.editActionGroup.addSeparator();
        this.editActionGroup.add("cut", new CutAction(this));
        this.editActionGroup.add("copy", new CopyAction(this)).setShowTextInToolBar(true);
        this.editActionGroup.add("paste", new PasteAction(this)).setShowTextInToolBar(true);
        this.editActionGroup.addSeparator();
        this.editActionGroup.add("delete-completed", new DeleteCompletedAction(this)).setShowTextInToolBar(true);
        this.editActionGroup.add("delete", new DeleteAction(this)).setVisibleInToolBar(false);
        this.editActionGroup.addSeparator();
        this.editActionGroup.add("select-all", new SelectAllAction(this)).setVisibleInToolBar(false);
        this.editActionGroup.add("unselect-all", new UnselectAllAction(this)).setVisibleInToolBar(false);
        this.editActionGroup.connect("undo", (JComponent)this, 0);
        this.editActionGroup.connect("redo", (JComponent)this, 0);
        this.editActionGroup.connect("delete-completed", (JComponent)this, 0);
        this.editActionGroup.connect("unselect-all", (JComponent)this, 0);
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TaskTable.this.editActionGroup.update();
                TaskTable.this.updateStatusText();
            }
        };
        this.getSelectionModel().addListSelectionListener(this.listSelectionListener);
    }

    public void addTask(String string, boolean bl) {
        this.addTask(string, Priority.DEFAULT, 0, 0L, MDate.currentTime(), 0L, bl);
    }

    public void addTask(Task task) {
        ((TaskModel)this.getModel()).addRow(task);
    }

    public void addTask(String string, Priority priority, int n, long l, long l2, long l3, boolean bl) {
        this.addTask(new Task(string, priority, n, l, l2, l3));
        if (bl) {
            this.selectRow(this.convertRowIndexToView(((TaskModel)this.getModel()).getRowCount() - 1));
        }
    }

    public boolean copy(boolean bl) {
        TaskSelection taskSelection = this.getTaskSelection();
        if (taskSelection == null) {
            return false;
        }
        try {
            MClipboard.setContents(taskSelection);
            if (bl) {
                this.deleteSelected();
            }
            return true;
        }
        catch (ClipboardException clipboardException) {
            MLogger.exception(clipboardException);
            return false;
        }
    }

    public ChartModel createChartModel() {
        return TaskModel.createChartModel(this.getTaskList());
    }

    public MMenu createSetValueMenu(int[] nArray) {
        MMenu mMenu = new MMenu(UI._("Modify Selected: {0}", nArray.length));
        if (nArray.length > 0 && !((TaskModel)this.getModel()).isLocked()) {
            mMenu.setSplitMenu(true);
            Task task = nArray.length == 1 ? (Task)((TaskModel)this.getModel()).getRowAt(this.convertRowIndexToModel(nArray[0])) : null;
            boolean bl = task != null && task.isDone();
            SetValueAction<Boolean> setValueAction = new SetValueAction<Boolean>(this, nArray, new MActionInfo(Column.DONE.toString(), null), Column.DONE, !bl);
            setValueAction.setEnabled(task != null);
            mMenu.addCheckBox(setValueAction, bl);
            mMenu.addTitle(Column.PRIORITY.toString());
            for (Priority priority : Priority.valuesReversed()) {
                mMenu.addRadioButton(new SetPriorityAction(this, nArray, priority), task != null && priority == task.getPriority());
            }
            mMenu.addTitle(Column.DATE_TIME.toString(), MActionInfo.SET_DATE_TIME.getIconName());
            mMenu.add(new SetDateTimeAction(this, nArray, TaskState.TODAY.toActionInfo(), TaskState.TODAY));
            mMenu.add(new SetDateTimeAction(this, nArray, TaskState.TOMORROW.toActionInfo(), TaskState.TOMORROW));
            mMenu.addSeparator();
            mMenu.add(new SetDateTimeAction(this, nArray, MActionInfo.SET_DATE_TIME, TaskState.LATER));
            mMenu.add(new SetDateTimeAction(this, nArray, MActionInfo.NO_DATE_TIME, TaskState.UNKNOWN));
            mMenu.addTitle(Column.COMPLETE.toString());
            for (int i = 0; i < 110; i += 10) {
                mMenu.addRadioButton(new SetCompleteAction(this, nArray, i), task != null && i == task.getComplete());
            }
        } else {
            mMenu.setEnabled(false);
        }
        return mMenu;
    }

    public void deleteCompletedItems() {
        this.doneEdit();
        int n = this.getSelectedRow();
        try {
            for (int i = ((TaskModel)this.getModel()).getRowCount() - 1; i >= 0; --i) {
                if (!this.getTaskAt(i).isDone()) continue;
                this.removeRow(i);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            MLogger.exception(arrayIndexOutOfBoundsException);
        }
        this.selectRow(n);
    }

    public boolean deleteCompletedItems(Window window) {
        int n = this.getCompletedItemCount();
        if (n == 0) {
            MStatusBar.warning(UI._("No completed tasks"));
            return false;
        }
        StringList stringList = new StringList(n);
        for (Task task : this.getTaskList()) {
            if (!task.isDone()) continue;
            stringList.add(task.getSummary());
        }
        if (!this.canCancelEdit(window, UI._("Delete Completed Tasks"))) {
            return false;
        }
        if (MMessage.customConfirm(window, MIcon.stock("ui/complete"), new MActionInfo(UI._("Delete Completed Tasks"), "ui/complete"), null, UI.makeHTML(UI._("Are you sure you want to delete <b>all completed</b> tasks?<br><br>Completed Tasks: {0}", n)), stringList.toArray())) {
            this.deleteCompletedItems();
            return true;
        }
        return false;
    }

    public boolean deleteSelectedItems(Window window) {
        return this.deleteSelected(window, UI.makeHTML(UI._("Are you sure you want to delete <b>all selected</b> tasks?") + "<br><br>" + TK.escapeXML(this.getSelectionText())), Column.SUMMARY.ordinal());
    }

    @Override
    public Object dispose(Object ... objectArray) {
        Object object;
        if (this.categoryChangeListener != null) {
            CategoryManager.getSharedInstance().removeChangeListener(this.categoryChangeListener);
            this.categoryChangeListener = null;
        }
        if (this.listSelectionListener != null) {
            object = this.getSelectionModel();
            if (object != null) {
                object.removeListSelectionListener(this.listSelectionListener);
            }
            this.listSelectionListener = null;
        }
        if (this.undoableEditListener != null) {
            object = (TaskModel)this.getModel();
            if (object != null) {
                ((AbstractListTableModel)object).removeUndoableEditListener(this.undoableEditListener);
            }
            this.undoableEditListener = null;
        }
        this.editActionGroup = TK.dispose(this.editActionGroup);
        return super.dispose(objectArray);
    }

    public void filterTasks(String string) {
        this.getTaskSorter().setRowFilter(TK.isEmpty(string) ? null : new Filter(string));
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        Column column = Column.values()[this.convertColumnIndexToModel(n2)];
        switch (column) {
            case CATEGORY: {
                if (this.categoryEditor == null) {
                    this.categoryEditor = new CategoryListEditor(CategoryManager.getSharedInstance());
                }
                return this.categoryEditor;
            }
            case CIRCLE: {
                if (this.circleEditor == null) {
                    this.circleEditor = new CircleEditor();
                }
                return this.circleEditor;
            }
            case COMPLETE: {
                if (this.completeEditor == null) {
                    this.completeEditor = new DefaultCellEditor(new CompleteEditor());
                }
                return this.completeEditor;
            }
            case DATE_TIME: 
            case START_DATE_TIME: {
                if (this.dateTimeEditor == null) {
                    this.dateTimeEditor = new DateTimeEditor();
                }
                return this.dateTimeEditor;
            }
            case DONE: {
                if (this.doneEditor == null) {
                    this.doneEditor = new DefaultCellEditor(new BooleanRenderer());
                }
                return this.doneEditor;
            }
            case PRIORITY: {
                if (this.priorityEditor == null) {
                    this.priorityEditor = new DefaultCellEditor(new PriorityEditor());
                }
                return this.priorityEditor;
            }
            case SUMMARY: {
                if (this.summaryEditor == null) {
                    this.summaryEditor = new SummaryEditor();
                }
                return this.summaryEditor;
            }
        }
        return super.getCellEditor(n, n2);
    }

    public int getCompletedItemCount() {
        int n = 0;
        for (Task task : this.getTaskList()) {
            if (!task.isDone()) continue;
            ++n;
        }
        return n;
    }

    public ActionGroup getEditActionGroup() {
        return this.editActionGroup;
    }

    public Task getTaskAt(int n) {
        return (Task)((TaskModel)this.getModel()).getRowAt(n);
    }

    public TableColumn getTaskColumn(Column column) {
        int n = column.toView(this);
        if (n == -1) {
            return null;
        }
        return this.getColumnModel().getColumn(n);
    }

    public List<Task> getTaskList() {
        return ((TaskModel)this.getModel()).getRows();
    }

    public TaskSelection getTaskSelection() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return null;
        }
        TaskSelection taskSelection = new TaskSelection();
        for (int n : nArray) {
            taskSelection.addTask(this.getTaskAt(this.convertRowIndexToModel(n)));
        }
        return taskSelection;
    }

    public Sorter<TaskModel> getTaskSorter() {
        return this.sorter;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return super.getToolTipLocation(mouseEvent);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    @Override
    public boolean isCellTipEnabled(int n, int n2) {
        if (n2 == Column.COMPLETE.toView(this)) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            return tableColumn.getWidth() < 30;
        }
        return super.isCellTipEnabled(n, n2);
    }

    public boolean paste() {
        return MDataTransfer.importFromClipboard(this);
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        MCellTip.getInstance().setVisible(false);
        return super.prepareEditor(tableCellEditor, n, n2);
    }

    public void read(Config config, Config config2, Config.GlobalEntry globalEntry) {
        this.getColumnManager().readConfig(config, config2, globalEntry);
        this.fontSize = config.readInt(globalEntry.getGlobalEntry("Font.size"), -1, 8, 128);
        if (this.fontSize != -1) {
            this.setStyle("font-size: " + this.fontSize);
            this.updateFontSize(this.fontSize);
        }
        this.setGridVisible(config.read(globalEntry.getGlobalEntry("showGrid"), false));
    }

    public int selectTask(Task task) {
        int n = ((TaskModel)this.getModel()).getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getTaskAt(i).equals(task)) continue;
            int n2 = this.convertRowIndexToView(i);
            if (n2 == -1) {
                return -1;
            }
            this.selectRow(n2);
            return n2;
        }
        return -1;
    }

    public void updateFontSize(int n) {
        this.fontSize = n;
        if (this.fontSize != -1) {
            this.setRowHeight(this.fontSize + 12);
        }
    }

    public void write(Config config, Config config2, Config.GlobalEntry globalEntry) {
        this.getColumnManager().writeConfig(config, config2, globalEntry);
        this.writeFontSize(config, globalEntry);
        config.write(globalEntry.getGlobalEntry("showGrid"), this.isGridVisible());
    }

    public void writeFontSize(Config config, Config.GlobalEntry globalEntry) {
        if (this.fontSize != -1) {
            config.write(globalEntry.getGlobalEntry("Font.size"), this.fontSize);
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
    }

    @Deprecated
    protected int getDefaultColumnWidth(Column column) {
        return column.getPreferredWidth();
    }

    protected void updateStatusText() {
    }

    private void initDragAndDrop() {
        this.setDragEnabled((Boolean)Kiosk.actionDragDrop.get());
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                boolean bl = transferSupport.isDataFlavorSupported(TaskSelection.TASK_FLAVOR);
                if (bl && transferSupport.isDrop() && TaskTable.this.getSortOrder() != SortOrder.UNSORTED) {
                    return false;
                }
                if (bl) {
                    if (transferSupport.isDrop()) {
                        transferSupport.setShowDropLocation(true);
                    }
                    return true;
                }
                if (transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    if (transferSupport.isDrop()) {
                        transferSupport.setShowDropLocation(false);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 2;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                Object object;
                int n = ((TaskModel)TaskTable.this.getModel()).getRowCount();
                List list = null;
                String[] stringArray = null;
                Transferable transferable = MDataTransfer.getTransferable(transferSupport);
                try {
                    Object object2 = object = transferable.isDataFlavorSupported(TaskSelection.TASK_FLAVOR) ? transferable.getTransferData(TaskSelection.TASK_FLAVOR) : null;
                    if (object instanceof List) {
                        list = (List)object;
                        if (list.isEmpty()) {
                            return false;
                        }
                    } else {
                        Object object3;
                        object = transferable.getTransferData(DataFlavor.stringFlavor);
                        if (object instanceof String && !((String)(object3 = (String)object)).isEmpty()) {
                            stringArray = ((String)object3).split("\n");
                        }
                    }
                }
                catch (IOException iOException) {
                    MLogger.exception(iOException);
                    return false;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    MLogger.exception(unsupportedFlavorException);
                    return false;
                }
                if (list != null) {
                    if (transferSupport.isDrop()) {
                        object = (JTable.DropLocation)transferSupport.getDropLocation();
                        int n2 = ((JTable.DropLocation)object).getRow();
                        if (n2 == -1) {
                            return false;
                        }
                        for (Task task : list) {
                            if (n2 >= TaskTable.this.getRowCount()) {
                                ((TaskModel)TaskTable.this.getModel()).addRow(task);
                            } else {
                                ((TaskModel)TaskTable.this.getModel()).insertRow(TaskTable.this.convertRowIndexToModel(n2), task);
                            }
                            ++n2;
                        }
                        TaskTable.this.deleteSelected();
                    } else {
                        for (Object object3 : list) {
                            TaskTable.this.addTask((Task)((Task)object3).clone());
                        }
                        TaskTable.this.selectFrom(n);
                    }
                } else if (stringArray != null) {
                    return TaskTable.this.pastePlainText(n, stringArray);
                }
                return true;
            }

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                return TaskTable.this.getTaskSelection();
            }
        });
    }

    private void pasteLines(int n, StringList stringList) {
        for (String string : stringList) {
            this.addTask(string.replace('\t', ' '), false);
        }
        this.selectFrom(n);
    }

    private boolean pastePlainText(int n, String[] stringArray) {
        StringList stringList = new StringList(stringArray.length);
        for (String object2 : stringArray) {
            if (object2.trim().isEmpty()) continue;
            stringList.add(object2);
        }
        if (stringList.isEmpty()) {
            return false;
        }
        if (stringList.size() == 1) {
            this.pasteLines(n, stringList);
            return true;
        }
        final BooleanProperty booleanProperty = new BooleanProperty();
        MDialog mDialog = new MDialog(UI.windowFor(this), MActionInfo.PASTE, 5);
        MButton mButton = new MButton(UI._("Paste as single task"), MActionInfo.PASTE.getIconName()){

            @Override
            protected void onClick() {
                booleanProperty.yes();
                MDialog mDialog = (MDialog)this.getWindowAncestor();
                mDialog.accept();
            }
        };
        MButton mButton2 = new MButton(UI._("Paste as {0} tasks", stringList.size()), MActionInfo.PASTE.getIconName()){

            @Override
            protected void onClick() {
                booleanProperty.no();
                MDialog mDialog = (MDialog)this.getWindowAncestor();
                mDialog.accept();
            }
        };
        MList<String> mList = new MList<String>();
        mList.setCellRenderer(MRenderer.getSharedInstance());
        mList.setSingleSelectionMode();
        mList.addAllItems(stringList);
        MPanel mPanel = mDialog.getCenterPanel();
        mPanel.setGroupLayout(true);
        mPanel.getGroupLayout().beginRows().addComponent(mButton).addSeparator().addComponent(mButton2).addScrollable(mList, UI._("Tasks:")).end();
        mDialog.packFixed();
        if (!mDialog.exec()) {
            return false;
        }
        if (((Boolean)booleanProperty.get()).booleanValue()) {
            this.addTask(TK.toString(stringArray, "\n"), true);
        } else {
            this.pasteLines(n, stringList);
        }
        return true;
    }

    private void selectFrom(int n) {
        this.clearSelection();
        int n2 = ((TaskModel)this.getModel()).getRowCount();
        for (int i = n; i < n2; ++i) {
            int n3 = this.convertRowIndexToView(i);
            if (n3 == -1) continue;
            this.addRowSelectionInterval(n3, n3);
        }
        this.scrollToRow(this.convertRowIndexToView(n));
    }

    void setupCellEditor(JComponent jComponent) {
        JTextField jTextField = jComponent instanceof MDateSpinner ? ((MDateSpinner)MDateSpinner.class.cast(jComponent)).getTextField() : (jComponent instanceof MTextField ? (MTextField)jComponent : null);
        if (UI.isMetal()) {
            jComponent.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        } else if (UI.isNimbus() && jTextField != null) {
            UI.NimbusOverrides nimbusOverrides = new UI.NimbusOverrides();
            nimbusOverrides.put("TextField.contentMargins", new Insets(0, 5, 0, 5));
            nimbusOverrides.install(jTextField, true);
        }
        if (jTextField != null) {
            jTextField.setFont(this.getFont());
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        Object object;
        if (bl && ("copy".equals(object = this.getInputMap(n).get(keyStroke)) || "cut".equals(object) || "paste".equals(object))) {
            this.editActionGroup.fire(object.toString(), this);
            return true;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    private static final class UnselectAllAction
    extends MDataAction.Weak<TaskTable> {
        @Override
        public void onAction() {
            ((TaskTable)this.get()).clearSelection();
        }

        private UnselectAllAction(TaskTable taskTable) {
            super(taskTable, MActionInfo.UNSELECT_ALL);
            this.setEnabled(false);
        }
    }

    private static final class SelectAllAction
    extends MDataAction.Weak<TaskTable> {
        @Override
        public void onAction() {
            ((TaskTable)this.get()).selectAll();
        }

        private SelectAllAction(TaskTable taskTable) {
            super(taskTable, MActionInfo.SELECT_ALL);
            this.setEnabled(false);
        }
    }

    private static final class PasteAction
    extends MDataAction.Weak<TaskTable> {
        @Override
        public void onAction() {
            if (!((TaskTable)this.get()).paste()) {
                MStatusBar.error(UI._("Paste failed"));
            }
        }

        private PasteAction(TaskTable taskTable) {
            super(taskTable, MActionInfo.PASTE);
            this.setEnabled(false);
        }
    }

    private static final class EditActionGroup
    extends ActionGroup {
        private final WeakReference<TaskTable> taskTableRef;

        @Override
        public void update() {
            TaskTable taskTable = (TaskTable)this.taskTableRef.get();
            boolean bl = taskTable.isSelection();
            boolean bl2 = ((TaskModel)taskTable.getModel()).isLocked();
            taskTable.undoManager.updateUndoRedoActions(!bl2);
            this.setEnabled("copy", bl);
            this.setEnabled("cut", bl && !bl2);
            this.setEnabled("delete", bl && !bl2);
            this.setEnabled("delete-completed", !taskTable.isEmpty(MV.MODEL) && !bl2);
            this.setEnabled("paste", !bl2);
            this.setEnabled("select-all", !taskTable.isEmpty(MV.VIEW));
            this.setEnabled("unselect-all", bl);
        }

        private EditActionGroup(TaskTable taskTable) {
            this.taskTableRef = new WeakReference<TaskTable>(taskTable);
        }
    }

    private static final class DeleteCompletedAction
    extends MDataAction.Weak<TaskTable> {
        @Override
        public void onAction() {
            TaskTable taskTable = (TaskTable)this.get();
            if (taskTable.deleteCompletedItems(this.getSourceWindow())) {
                taskTable.updateStatusText();
            }
        }

        private DeleteCompletedAction(TaskTable taskTable) {
            super(taskTable, DELETE_COMPLETED);
            this.setEnabled(false);
            this.setHTMLHelp(UI._("Deletes all the completed tasks."));
        }
    }

    private static final class DeleteAction
    extends MDataAction.Weak<TaskTable> {
        @Override
        public void onAction() {
            TaskTable taskTable = (TaskTable)this.get();
            if (taskTable.deleteSelectedItems(this.getSourceWindow())) {
                taskTable.updateStatusText();
            }
        }

        private DeleteAction(TaskTable taskTable) {
            super(taskTable, DELETE_SELECTED);
            this.setEnabled(false);
            this.setHTMLHelp(UI._("Deletes all the selected tasks."));
        }
    }

    private static final class CutAction
    extends MDataAction.Weak<TaskTable> {
        @Override
        public void onAction() {
            TaskTable taskTable = (TaskTable)this.get();
            if (!taskTable.canCancelEdit(this.getSourceWindow(), this.getName())) {
                return;
            }
            if (!taskTable.copy(true)) {
                MStatusBar.error(UI._("Cut failed"));
            }
        }

        private CutAction(TaskTable taskTable) {
            super(taskTable, MActionInfo.CUT);
            this.setEnabled(false);
        }
    }

    private static final class CopyAction
    extends MDataAction.Weak<TaskTable> {
        @Override
        public void onAction() {
            if (!((TaskTable)this.get()).copy(false)) {
                MStatusBar.error(UI._("Copy failed"));
            }
        }

        private CopyAction(TaskTable taskTable) {
            super(taskTable, MActionInfo.COPY);
            this.setEnabled(false);
        }
    }

    public static class SetValueAction<T>
    extends MDataAction.Weak<TaskTable> {
        protected final Column column;
        protected final int[] selectedViewRows;
        protected final T value;

        public SetValueAction(TaskTable taskTable, int[] nArray, MActionInfo mActionInfo, Column column, T t) {
            super(taskTable, mActionInfo);
            this.selectedViewRows = (int[])nArray.clone();
            this.column = column;
            this.value = t;
        }

        @Override
        public void onAction() {
            int[] nArray;
            TaskTable taskTable = (TaskTable)this.get();
            TaskModel taskModel = (TaskModel)taskTable.getModel();
            for (int n : nArray = taskTable.getSelectedRows()) {
                int n2 = taskTable.convertRowIndexToModel(n);
                Object object = this.convertValue();
                if (object == this.value) {
                    object = this.convertValue(taskModel, n2);
                }
                taskModel.setValueAt(object, n2, this.column.ordinal());
            }
        }

        @Deprecated
        protected Object convertValue() {
            return this.value;
        }

        protected Object convertValue(TaskModel taskModel, int n) {
            return this.value;
        }
    }

    public static class SetPriorityAction
    extends SetValueAction<Priority> {
        public SetPriorityAction(TaskTable taskTable, int[] nArray, Priority priority) {
            super(taskTable, nArray, new MActionInfo(priority.toString(), null), Column.PRIORITY, priority);
            this.setSmallIcon(priority.getSmallColorIcon());
        }
    }

    public static class SetDateTimeAction
    extends SetValueAction<TaskState> {
        private boolean setTime;
        private MCalendar newValue;

        public SetDateTimeAction(TaskTable taskTable, int[] nArray, MActionInfo mActionInfo, TaskState taskState) {
            super(taskTable, nArray, mActionInfo, Column.DATE_TIME, taskState);
        }

        @Override
        public void onAction() {
            Task task;
            if (this.value == TaskState.UNKNOWN) {
                this.newValue = null;
                super.onAction();
                return;
            }
            TaskTable taskTable = (TaskTable)this.get();
            Task task2 = task = this.selectedViewRows.length == 1 ? (Task)((TaskModel)taskTable.getModel()).getRowAt(taskTable.convertRowIndexToModel(this.selectedViewRows[0])) : null;
            if (this.value == TaskState.TODAY) {
                this.newValue = MCalendar.now();
                if (task != null && task.getDateTime().isValid()) {
                    this.newValue.setTime(MCalendar.of(task.getDateTime()));
                } else {
                    this.newValue.addHour(1);
                }
            } else if (this.value == TaskState.TOMORROW) {
                this.newValue = MCalendar.tomorrow();
                if (task != null && task.getDateTime().isValid()) {
                    this.newValue.setTime(MCalendar.of(task.getDateTime()));
                }
            } else if (this.value == TaskState.LATER) {
                this.newValue = task != null && task.getDateTime().isValid() ? MCalendar.of(task.getDateTime()) : MCalendar.now();
            } else {
                throw new WTFError((Enum)this.value);
            }
            if (this.selectedViewRows.length == 1 || this.value == TaskState.LATER) {
                MCalendar mCalendar = Input.getDateTime(this.getSourceWindow(), this.newValue, this.getName(), 1, 3);
                if (mCalendar == null) {
                    return;
                }
                this.newValue = mCalendar;
                this.setTime = true;
            } else {
                this.setTime = false;
            }
            super.onAction();
        }

        @Override
        @Deprecated
        protected Object convertValue() {
            return super.convertValue();
        }

        @Override
        protected Object convertValue(TaskModel taskModel, int n) {
            if (this.column == Column.DATE_TIME && this.newValue == null) {
                return MDate.invalid();
            }
            MDate mDate = (MDate)taskModel.getValueAt(n, this.column.ordinal());
            MCalendar mCalendar = MCalendar.of(mDate);
            mCalendar.setDate(this.newValue);
            if (this.selectedViewRows.length == 1 || !mDate.isValid() || this.setTime) {
                mCalendar.setTime(this.newValue);
            }
            return mCalendar.toDate();
        }
    }

    public static class SetCompleteAction
    extends SetValueAction<Integer> {
        public SetCompleteAction(TaskTable taskTable, int[] nArray, int n) {
            super(taskTable, nArray, new MActionInfo(n + " %", null), Column.COMPLETE, n);
        }
    }
}

