/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools;

import java.awt.Color;
import java.io.File;
import java.security.BasicPermission;
import java.util.HashMap;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MSplashScreen;
import org.makagiga.commons.SafeMode;
import org.makagiga.commons.SimpleProgressBar;
import org.makagiga.commons.TK;
import org.makagiga.console.Console;
import org.makagiga.editors.ConsoleTab;
import org.makagiga.editors.Editor;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.tree.TreeFS;
import org.makagiga.tree.Tree;
import org.makagiga.tree.tracker.Tracker;

public final class SessionManager {
    private static String currentItem;

    public static void deletePrivateData() {
        SessionManager.checkPermission("deletePrivateData");
        Config config = SessionManager.getSessionConfig("default");
        if (!config.isError()) {
            config.removeAll();
            config.sync();
        }
    }

    public static String getCurrentItem() {
        SessionManager.checkPermission("getCurrentItem");
        return currentItem;
    }

    @Deprecated
    public static boolean isOpen(MetaInfo metaInfo) {
        return metaInfo.isOpen();
    }

    public static boolean restore() {
        return SessionManager.restore("default");
    }

    @SafeMode
    public static boolean restore(String string) {
        Object object;
        String string2;
        Object object2;
        int n;
        Object object3;
        int n2;
        MLogger.info("session", "Restoring \"%s\" session...", string);
        SessionManager.checkPermission("restore");
        TK.checkNullOrEmpty(string);
        Config config = SessionManager.getSessionConfig(string);
        Tree tree = Tree.getInstance();
        if (config.isError()) {
            tree.selectItem(TreeFS.getInstance().getRoot(), false);
            return false;
        }
        final HashMap hashMap = new HashMap();
        new Tree.Scanner(){

            @Override
            public void processItem(MetaInfo metaInfo) {
                if (metaInfo.isFile()) {
                    hashMap.put(metaInfo.getFilePath(), metaInfo);
                }
            }
        };
        if (((Boolean)Vars.tabsRecentlyClosedTabs.get()).booleanValue() && (n2 = config.readInt("Recent.count", 0)) > 0) {
            object3 = Tabs.getInstance().getRecentlyClosedTabs();
            for (n = 1; n < n2 + 1; ++n) {
                object2 = "Recent.id." + n;
                string2 = config.read((String)object2, null);
                if (string2 != null && (object = Tracker.getByID(string2)) != null) {
                    object3.add(object);
                }
                config.removeString((String)object2);
            }
            config.removeInt("Recent.count");
        }
        if ((n2 = config.readInt("Tree.count", 0)) > 0) {
            object3 = MApplication.getLightBrandColor();
            MSplashScreen.setTextColor((Color)object3);
            MSplashScreen.setTextMargin(2);
            MSplashScreen.setTextShadowColor(null);
            MSplashScreen.setVerticalTextPosition(1);
            int n3 = n = !MApplication.isSafeMode() && (Boolean)Vars.treeReopenFiles.get() != false ? 1 : 0;
            if (n != 0) {
                object2 = MSplashScreen.getProgressBar();
                ((SimpleProgressBar)object2).setForeground(MColor.deriveAlpha(object3, 128));
                ((SimpleProgressBar)object2).setMaximum(n2);
                ((SimpleProgressBar)object2).setValue(0);
            }
            for (int i = 1; i < n2 + 1; ++i) {
                string2 = "Tree.path." + i;
                object = config.read(string2, null);
                if (n != 0 && object != null) {
                    MetaInfo metaInfo;
                    File file = new File((String)object);
                    if (!file.isAbsolute()) {
                        file = new File(FS.getPlatformConfigPath((String)object));
                    }
                    if ((metaInfo = (MetaInfo)hashMap.get(file.getPath())) != null) {
                        MSplashScreen.setText(null, i);
                        Tabs.getInstance().openEditor(metaInfo);
                    }
                }
                config.removeString(string2);
            }
            config.removeInt("Tree.count");
        }
        for (AbstractFS abstractFS : tree.getFileSystems().values()) {
            boolean bl = config.read("Tree.VFS." + abstractFS.getID() + ".expanded", false);
            if (!bl) continue;
            tree.setExpanded(abstractFS.getRoot(), true);
        }
        currentItem = config.read("Tree.current", null);
        if (currentItem != null) {
            object3 = new File(currentItem);
            if (!((File)object3).isAbsolute()) {
                object3 = new File(FS.getPlatformConfigPath(currentItem));
            }
            currentItem = ((File)object3).getPath();
        }
        if (((Boolean)Kiosk.consoleEnabled.get()).booleanValue() && config.read("Console.open", false)) {
            Console.getInstance(true);
        }
        config.sync();
        if (tree.getSelectedItems().length == 0) {
            tree.selectItem(TreeFS.getInstance().getRoot(), false);
        }
        return true;
    }

    public static boolean save() {
        return SessionManager.save("default");
    }

    public static boolean save(String string) {
        int n;
        MLogger.info("session", "Saving \"%s\" session...", string);
        SessionManager.checkPermission("save");
        TK.checkNullOrEmpty(string);
        Config config = SessionManager.getSessionConfig(string);
        config.removeAll();
        Tabs tabs = Tabs.getInstance();
        if (((Boolean)Vars.tabsRecentlyClosedTabs.get()).booleanValue()) {
            n = 0;
            for (MetaInfo object2 : tabs.getRecentlyClosedTabs()) {
                if (!object2.isFile()) continue;
                config.write("Recent.id." + ++n, object2.getID());
            }
            config.write("Recent.count", n);
        }
        n = 0;
        for (Editor editor : tabs) {
            MetaInfo metaInfo = editor.getMetaInfo();
            if (metaInfo == null || !metaInfo.isFile()) continue;
            config.write("Tree.path." + ++n, FS.getPortableConfigPath(metaInfo.getFilePath()));
        }
        config.write("Tree.count", n);
        Tree tree = Tree.getInstance();
        for (AbstractFS abstractFS : tree.getFileSystems().values()) {
            config.write("Tree.VFS." + abstractFS.getID() + ".expanded", tree.isExpanded(abstractFS.getRoot()));
        }
        MetaInfo metaInfo = tabs.getCurrentMetaInfo();
        if (metaInfo != null && metaInfo.isFile() && !TK.isEmpty(metaInfo.getFilePath())) {
            currentItem = metaInfo.getFilePath();
            config.write("Tree.current", FS.getPortableConfigPath(currentItem));
        } else {
            currentItem = null;
            config.removeString("Tree.current");
        }
        if (Console.isInstance() && tabs.findEditor(ConsoleTab.class) != null) {
            config.write("Console.open", true);
        }
        config.sync();
        return true;
    }

    private SessionManager() {
    }

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(string));
        }
    }

    private static Config getSessionConfig(String string) {
        return new Config(FS.makePath(SessionManager.getSessionsDir(), string + ".properties"));
    }

    private static String getSessionsDir() {
        return FS.makeConfigPath("sessions", 1);
    }

    public static final class Permission
    extends BasicPermission {
        private Permission(String string) {
            super(string);
        }
    }
}

