/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools.summary;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.makagiga.commons.Config;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.category.Category;
import org.makagiga.commons.category.CategoryList;
import org.makagiga.commons.category.CategoryManager;
import org.makagiga.commons.category.CategoryMenu;
import org.makagiga.tools.summary.SummaryData;

final class SummaryCategory {
    private static Map<SummaryData.DayKey, Category> categoryMap = TK.newHashMap();

    public static CategoryMenu createMenu(final SummaryData.DayKey dayKey) {
        CategoryManager categoryManager = CategoryManager.getSharedInstance();
        CategoryList categoryList = new CategoryList();
        categoryList.addAll(categoryMap.values());
        return new CategoryMenu(categoryManager, categoryList.toString()){

            @Override
            protected void onCategoryChange(Category category) {
                MLogger.XXX(category);
                super.onCategoryChange(category);
                categoryMap.put(dayKey, category);
            }
        };
    }

    public Category get(SummaryData.DayKey dayKey) {
        return categoryMap.get(dayKey);
    }

    SummaryCategory() {
        String string = Config.getDefault().read("Summary.category", null);
        if (string != null) {
            CategoryManager categoryManager = CategoryManager.getSharedInstance();
            List<String> list = TK.fastSplit(string, ',');
            for (String string2 : list) {
                String string3;
                Category category;
                int n = string2.indexOf(61);
                if (n == -1 || (category = categoryManager.getCategory(string3 = string2.substring(n + 1))) == null) continue;
                String string4 = string2.substring(0, n);
                System.out.printf("%s:%s\n", string4, string3);
                MDate mDate = MDate.parse(string4, "yyyy-MM-dd", Locale.ENGLISH, null);
                if (mDate == null) continue;
                categoryMap.put(new SummaryData.DayKey(mDate.getCalendar()), category);
            }
        }
    }
}

