/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree;

import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.DropMode;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.makagiga.Sidebar;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MTree;
import org.makagiga.commons.MTreeItem;
import org.makagiga.commons.MTreeModel;
import org.makagiga.commons.MTreeScanner;
import org.makagiga.commons.MV;
import org.makagiga.commons.SafeMode;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.category.CategoryManager;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSDynamic;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSOpen;
import org.makagiga.fs.FSPlugin;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MetaInfoComparator;
import org.makagiga.fs.dnd.DnDTransferHandler;
import org.makagiga.fs.tree.TreeFS;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginType;
import org.makagiga.search.Index;
import org.makagiga.search.SortComparator;
import org.makagiga.search.SortMethod;
import org.makagiga.tree.ItemRenderer;
import org.makagiga.tree.TreePanel;
import org.makagiga.tree.tracker.Tracker;
import org.makagiga.tree.tracker.TrackerEvent;

public final class Tree
extends MTree<MetaInfo, MTreeModel<MetaInfo>> {
    private DnDTransferHandler dndTransferHandler;
    private final Map<String, AbstractFS> fileSystems = new HashMap<String, AbstractFS>();
    private static final MetaInfo[] EMPTY_META_INFO_ARRAY = new MetaInfo[0];
    private static Tree _instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(MetaInfo metaInfo, MetaInfo metaInfo2) {
        Tree tree = this;
        synchronized (tree) {
            metaInfo.add(metaInfo2);
            ((DefaultTreeModel)this.getModel()).nodesWereInserted(metaInfo, new int[]{metaInfo.getChildCount(MV.VIEW) - 1});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteItem(MetaInfo metaInfo) {
        Tracker.add(metaInfo, TrackerEvent.ID.ITEM_REMOVED);
        Tree tree = this;
        synchronized (tree) {
            MTreeItem mTreeItem = metaInfo.getParentItem();
            if (mTreeItem != null) {
                int n = mTreeItem.getIndex(metaInfo, MV.VIEW);
                metaInfo.removeFromParent();
                if (n == -1) {
                    ((DefaultTreeModel)this.getModel()).nodeStructureChanged(metaInfo);
                } else {
                    ((DefaultTreeModel)this.getModel()).nodesWereRemoved(mTreeItem, new int[]{n}, new Object[]{metaInfo});
                }
            }
        }
    }

    public MetaInfo getCurrentFolder(boolean bl) {
        MetaInfo[] metaInfoArray = this.getSelectedItems();
        if (metaInfoArray.length == 0) {
            return TreeFS.getInstance().getRoot();
        }
        MetaInfo metaInfo = metaInfoArray[0];
        if (metaInfo.isAnyFile()) {
            metaInfo = metaInfo.getParentFolder();
        }
        if (metaInfo == null) {
            return metaInfoArray[0].getFS().getRoot();
        }
        if (metaInfo.isDynamicFolder()) {
            return bl ? metaInfo : metaInfo.getParentFolder();
        }
        return metaInfo;
    }

    public Map<String, AbstractFS> getFileSystems() {
        return this.fileSystems;
    }

    public AbstractFS getFS(String string) {
        return string == null ? null : this.fileSystems.get(string);
    }

    public static synchronized Tree getInstance() {
        if (_instance == null) {
            new Tree();
        }
        return _instance;
    }

    public MetaInfo[] getSelectedItems() {
        Object[] objectArray = this.getSelectionPaths();
        if (TK.isEmpty(objectArray)) {
            return EMPTY_META_INFO_ARRAY;
        }
        MetaInfo[] metaInfoArray = new MetaInfo[objectArray.length];
        for (int i = 0; i < metaInfoArray.length; ++i) {
            metaInfoArray[i] = (MetaInfo)((TreePath)objectArray[i]).getLastPathComponent();
        }
        return metaInfoArray;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (!((Boolean)Vars.treeToolTips.get()).booleanValue()) {
            return null;
        }
        MetaInfo metaInfo = (MetaInfo)this.getItemForLocation(mouseEvent.getPoint());
        if (metaInfo != null) {
            if (metaInfo.isFSRoot()) {
                return metaInfo.toString();
            }
            int n = 112;
            String string = metaInfo.getToolTipText(n);
            if (string == null) {
                UI.hideToolTip(this);
            }
            return string;
        }
        return null;
    }

    public void invalidatePreview(MetaInfo metaInfo) {
        new Scanner(metaInfo, false){

            @Override
            public void processItem(MetaInfo metaInfo) {
                if (metaInfo.isFile()) {
                    metaInfo.invalidatePreview(false);
                }
            }
        };
    }

    public boolean open(MetaInfo metaInfo) {
        return this.open(null, metaInfo);
    }

    public boolean open(InputEvent inputEvent, MetaInfo metaInfo) {
        int n;
        Serializable serializable;
        if (metaInfo == null) {
            return false;
        }
        if (metaInfo.isAnyFolder()) {
            Sidebar.getInstance().goTo(Sidebar.Tab.TREE, false);
            if (metaInfo.isLink()) {
                this.focusItem(metaInfo.getLink());
            } else {
                this.focusItem(metaInfo);
            }
            if (metaInfo.isDynamicFolder()) {
                if (metaInfo.isLink()) {
                    MetaInfo metaInfo2 = metaInfo.getLink();
                    if (metaInfo2.isEmpty(MV.MODEL)) {
                        return this.dynamicOpen(inputEvent, metaInfo2);
                    }
                    this.setExpanded(metaInfo2, true);
                } else {
                    return this.dynamicOpen(inputEvent, metaInfo);
                }
            }
            return true;
        }
        if (metaInfo.isFile()) {
            return Tabs.getInstance().openEditor(metaInfo.isLink() ? metaInfo.getLink() : metaInfo);
        }
        if (metaInfo.isVirtualFile()) {
            serializable = metaInfo.isLink() ? metaInfo.getLink() : metaInfo;
            this.focusItem(serializable);
            if (((MetaInfo)serializable).getFS() instanceof FSOpen) {
                try {
                    int n2 = 0;
                    if (inputEvent instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)inputEvent;
                        if (MMouseAdapter.isLeft(mouseEvent)) {
                            n2 = 1;
                        } else if (MMouseAdapter.isMiddle(mouseEvent)) {
                            n2 = 2;
                        }
                    }
                    ((FSOpen)FSOpen.class.cast(((MetaInfo)serializable).getFS())).open(n2, (MetaInfo)serializable);
                    return true;
                }
                catch (FSException fSException) {
                    MLogger.exception(fSException);
                    MStatusBar.error(fSException.getMessage());
                }
            }
        }
        if (metaInfo.isDummy() && (n = ((Tabs)(serializable = Tabs.getInstance())).findEditor(metaInfo)) != -1) {
            ((Tabs)serializable).selectEditorAt(n);
            return true;
        }
        return false;
    }

    public void openPrivileged(MetaInfo metaInfo) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            this.open(metaInfo);
        } else {
            Tracker.add(metaInfo, TrackerEvent.ID.ITEM_OPEN);
        }
    }

    public void removeAllChildren(MetaInfo metaInfo) {
        this.removeAllChildren(metaInfo, true);
    }

    public synchronized void removeAllChildren(MetaInfo metaInfo, final boolean bl) {
        final Tabs tabs = Tabs.getInstance();
        new Scanner(metaInfo, false){

            @Override
            public void processItem(MetaInfo metaInfo) {
                int n;
                Tracker.add(metaInfo, TrackerEvent.ID.ITEM_REMOVED);
                if (metaInfo.isAnyFile() && (n = tabs.findEditor(metaInfo)) != -1) {
                    tabs.closeEditorAt(n, 3);
                    if (bl) {
                        metaInfo.sync();
                    }
                }
            }
        };
        metaInfo.removeAllChildren();
    }

    public void saveAllItems() {
        for (AbstractFS abstractFS : this.fileSystems.values()) {
            new Scanner(abstractFS.getRoot()){

                @Override
                public void processItem(MetaInfo metaInfo) {
                    if (metaInfo.isAnyFolder() || metaInfo.isFile()) {
                        metaInfo.sync();
                    }
                }
            };
            abstractFS.getRoot().sync();
        }
    }

    public void setExtraInfo(MetaInfo metaInfo, Object object) {
        metaInfo.setExtraInfo(object);
        metaInfo.refresh(true);
    }

    public void sort(MetaInfo metaInfo, final SortMethod sortMethod) {
        Comparator<MutableTreeNode> comparator = new Comparator<MutableTreeNode>(){
            private MetaInfoComparator metaInfoComparator;
            {
                this.metaInfoComparator = SortComparator.createMetaInfoComparator(sortMethod);
            }

            @Override
            public int compare(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2) {
                return this.metaInfoComparator.compare((MetaInfo)mutableTreeNode, (MetaInfo)mutableTreeNode2);
            }
        };
        ((MTreeModel)this.getModel()).sort(metaInfo, comparator);
    }

    @Override
    protected MMenu createContextMenu() {
        return TreePanel.getInstance().createTreeMenu(null, false);
    }

    @Override
    protected void onAction(InputEvent inputEvent, int n) {
        MetaInfo metaInfo = (MetaInfo)this.getItemAtRow(n);
        if (metaInfo.isAnyFile() || metaInfo.isDynamicFolder()) {
            this.open(inputEvent, metaInfo);
        } else if (metaInfo.isFolder()) {
            this.open(inputEvent, metaInfo);
            if (metaInfo.isLink()) {
                this.toggleItem(metaInfo.getLink());
            } else {
                this.toggleItem(metaInfo);
            }
        } else if (metaInfo.isFSRoot()) {
            this.dynamicOpen(null, metaInfo);
            this.toggleRow(n);
        }
    }

    private Tree() {
        if (_instance != null) {
            throw new WTFError("org.makagiga.tree.Tree already created");
        }
        _instance = this;
        this.setCellRenderer(new ItemRenderer());
        this.setRowHeight(-1);
        ((MTreeModel)this.getModel()).setRootItem(MetaInfo.createMainRoot());
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.registerFS(TreeFS.getInstance());
        this.initFS();
        ((DefaultTreeModel)this.getModel()).reload();
        this.initDragAndDrop();
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                MetaInfo metaInfo = (MetaInfo)treePath.getLastPathComponent();
                if (metaInfo.isFolder()) {
                    Tree.this.invalidatePreview(metaInfo);
                }
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                MetaInfo metaInfo = (MetaInfo)treePath.getLastPathComponent();
                if (metaInfo.isSortable()) {
                    Tree.this.sort(metaInfo, metaInfo.getSortMethod());
                }
            }
        });
        CategoryManager.getSharedInstance().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Tree.this.repaint();
            }
        });
        Index.getInstance();
    }

    private boolean dynamicOpen(InputEvent inputEvent, MetaInfo metaInfo) {
        AbstractFS abstractFS = metaInfo.getFS();
        if (abstractFS instanceof FSDynamic) {
            if (this.isExpanded(metaInfo) && inputEvent != null) {
                this.setExpanded(metaInfo, false);
                return true;
            }
            try {
                metaInfo.setLastOpenTime();
                boolean bl = ((FSDynamic)FSDynamic.class.cast(abstractFS)).dynamic(0, metaInfo);
                metaInfo.reload();
                if (inputEvent != null) {
                    this.setExpanded(metaInfo, true);
                }
                return bl;
            }
            catch (FSException fSException) {
                MMessage.error(null, fSException);
                return false;
            }
        }
        return false;
    }

    private void initDragAndDrop() {
        this.setDragEnabled((Boolean)Kiosk.actionDragDrop.get());
        this.dndTransferHandler = new DnDTransferHandler();
        this.setTransferHandler(this.dndTransferHandler);
        this.setDropMode(DropMode.ON);
        try {
            this.getDropTarget().addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                    Tree.this.dndTransferHandler.reset();
                }

                @Override
                public void drop(DropTargetDropEvent dropTargetDropEvent) {
                }
            });
        }
        catch (TooManyListenersException tooManyListenersException) {
            MLogger.exception(tooManyListenersException);
        }
    }

    @SafeMode
    private void initFS() {
        for (PluginInfo pluginInfo : PluginType.FILE_SYSTEM.get()) {
            try {
                this.registerFS((AbstractFS)((FSPlugin)FSPlugin.class.cast(pluginInfo.getPluggable())).create());
            }
            catch (Exception exception) {
                MMessage.error(null, exception);
            }
        }
    }

    private void registerFS(AbstractFS abstractFS) {
        if (this.fileSystems.containsKey(abstractFS.getID())) {
            MLogger.error("vfs", "File system is already registered: \"%s\"", abstractFS);
            return;
        }
        MLogger.info("vfs", "Registering file system: \"%s\"", abstractFS);
        this.fileSystems.put(abstractFS.getID(), abstractFS);
        ((MetaInfo)((MTreeModel)this.getModel()).getRootItem()).add(abstractFS.getRoot());
    }

    public static abstract class Scanner
    extends MTreeScanner<MetaInfo> {
        public Scanner() {
            super(((MTreeModel)Tree.getInstance().getModel()).getRootItem());
        }

        public Scanner(AbstractFS abstractFS) {
            super(abstractFS.getRoot());
        }

        public Scanner(MetaInfo metaInfo) {
            super(metaInfo, 1);
        }

        public Scanner(MetaInfo metaInfo, boolean bl) {
            super(metaInfo, bl ? 1 : 0);
        }
    }

    public static abstract class OpenAllInTabsAction
    extends MDataAction.Weak<MMenu> {
        public OpenAllInTabsAction() {
            this((MMenu)null);
        }

        public OpenAllInTabsAction(MMenu mMenu) {
            super(mMenu, UI._("Open All in Tabs"));
        }

        @Override
        public void onAction() {
            List<MetaInfo> list = this.getFileList();
            if (TK.isEmpty(list)) {
                return;
            }
            if (list.size() > 5 && !MMessage.customConfirm(null, MIcon.stock("ui/question"), new MActionInfo(UI._("Open"), "ui/ok"), null, UI._("Open all files?"), list.toArray())) {
                return;
            }
            Tree tree = Tree.getInstance();
            for (MetaInfo metaInfo : list) {
                tree.open(metaInfo);
            }
        }

        protected abstract List<MetaInfo> getFileList();

        protected MMenu getParent() {
            return (MMenu)this.get();
        }
    }
}

