/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree;

import org.makagiga.Vars;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.UI;
import org.makagiga.tree.TreeSettings;

public final class TreeSettingsButton
extends MButton {
    public TreeSettingsButton() {
        super(UI._("Tree Settings"), "ui/tree");
        this.setPopupMenuEnabled(true);
    }

    @Override
    protected MMenu onPopupMenu() {
        MMenu mMenu = new MMenu();
        mMenu.addCheckBox(new Action(UI._("Small Icons"), Vars.treeSmallIcons, false));
        mMenu.addCheckBox(new Action(UI._("Tool Tips"), Vars.treeToolTips, false));
        MMenu mMenu2 = new MMenu(UI._("Thumbnails"), "ui/image");
        mMenu2.addRadioButton(new Action(UI._("No Thumbnails"), Vars.treePreview, true));
        int n = 10;
        for (int i = 0; i < n; ++i) {
            int n2 = i * 25 + 25;
            String string = n2 == 25 ? UI._("Small") : (n2 == (Integer)Vars.treePreviewSize.getDefaultValue() ? UI._("Default") : (n2 == 250 ? UI._("Large") : "-"));
            Action action = new Action(string, Vars.treePreviewSize, true);
            action.putValue("org.makagiga.tree.TreeSettingsButton$Action.INT_VALUE", n2);
            action.setLongDescription(Integer.toString(n2));
            mMenu2.addRadioButton(action, (Boolean)Vars.treePreview.get() != false && n2 == (Integer)Vars.treePreviewSize.get());
        }
        mMenu2.addSeparator();
        mMenu2.addCheckBox(new Action(UI._("Meta Info (image size, etc)"), Vars.treeShowMetaInfo, true)).setEnabled((Boolean)Vars.treePreview.get());
        mMenu.add(mMenu2);
        mMenu.addTitle(UI._("Show Properties"));
        mMenu.addCheckBox(new Action(UI._("Categories"), Vars.treeShowCategories, false));
        mMenu.addCheckBox(new Action(UI._("Tags"), Vars.treeShowTags, false));
        mMenu.addCheckBox(new Action(UI._("Rating"), Vars.treeShowRating, false));
        return mMenu;
    }

    private static final class Action<T>
    extends MDataAction<PropertyAccess<T>> {
        private final boolean updatePreview;
        private static final String INT_VALUE = "org.makagiga.tree.TreeSettingsButton$Action.INT_VALUE";

        @Override
        public void onAction() {
            PropertyAccess propertyAccess = (PropertyAccess)this.getData();
            if (propertyAccess == Vars.treePreview) {
                Vars.treePreview.set(!this.isEnabled());
            } else {
                Object object = Boolean.class.equals(propertyAccess.getType()) ? Boolean.valueOf(this.isSelected()) : this.getValue(INT_VALUE);
                propertyAccess.set(object);
            }
            if (propertyAccess == Vars.treePreviewSize) {
                Vars.treePreview.yes();
            }
            TreeSettings.updateTreeView(this.updatePreview);
        }

        private Action(String string, PropertyAccess<T> propertyAccess, boolean bl) {
            super(propertyAccess, string);
            this.updatePreview = bl;
            if (propertyAccess == Vars.treePreview) {
                this.setSelected(!Vars.treePreview.booleanValue());
            } else if (Boolean.class.equals(propertyAccess.getType())) {
                this.setSelected((Boolean)propertyAccess.get());
            }
        }
    }
}

