/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree.tracker;

import java.security.BasicPermission;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.TK;
import org.makagiga.fs.MetaInfo;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskList;
import org.makagiga.todo.TaskModel;
import org.makagiga.todo.TaskTable;
import org.makagiga.tree.Tree;
import org.makagiga.tree.tracker.TrackerEvent;
import org.makagiga.tree.tracker.TrackerItem;
import org.makagiga.tree.tracker.TrackerListener;

public final class Tracker {
    private static EventListenerList listenerList = new EventListenerList();
    private static final Map<String, MetaInfo> metaInfoMap = new HashMap<String, MetaInfo>();
    private static MLogger log = MLogger.get("tracker");
    private static MTimer schedulerTimer;
    private static final Queue<TrackerItem> queue;

    public static void add(MetaInfo metaInfo, TrackerEvent.ID iD) {
        Tracker.add(metaInfo, iD, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(MetaInfo metaInfo, TrackerEvent.ID iD, Object object) {
        Object object2;
        Object object3;
        if (metaInfo == null) {
            log.error("Cannot schedule \"null\" item");
            return;
        }
        if (metaInfo.isLink()) {
            return;
        }
        if (!metaInfo.isVirtualFile()) {
            if (iD == TrackerEvent.ID.ITEM_ADDED) {
                object3 = metaInfo.getID();
                if (object3 != null) {
                    object2 = metaInfoMap;
                    synchronized (object2) {
                        metaInfoMap.put((String)object3, metaInfo);
                    }
                }
            } else if (iD == TrackerEvent.ID.ITEM_REMOVED && (object3 = metaInfo.getID()) != null) {
                object2 = metaInfoMap;
                synchronized (object2) {
                    metaInfoMap.remove(object3);
                }
            }
        }
        if (metaInfo.isFile()) {
            object3 = new TrackerItem(metaInfo, iD, object);
            ((TrackerItem)object3).extension = metaInfo.getExtension();
            ((TrackerItem)object3).todo = "mgtodo".equals(((TrackerItem)object3).extension);
            if (iD == TrackerEvent.ID.ITEM_REMOVED || iD == TrackerEvent.ID.ITEM_RENAMED) {
                Tracker.fireItemChanged(((TrackerItem)object3).createEvent());
            } else {
                if (iD == TrackerEvent.ID.ITEM_OPEN) {
                    ((TrackerItem)object3).priority = -2;
                } else if (((TrackerItem)object3).todo) {
                    ((TrackerItem)object3).priority = -1;
                }
                object2 = queue;
                synchronized (object2) {
                    queue.add((TrackerItem)object3);
                }
            }
        } else if (metaInfo.isFolder()) {
            object3 = new TrackerItem(metaInfo, iD, object);
            Tracker.fireItemChanged(((TrackerItem)object3).createEvent());
        }
    }

    public static void addTrackerListener(TrackerListener trackerListener) {
        log.debugFormat("Add Listener: %s (#%d)", trackerListener.getClass(), listenerList.getListenerCount() + 1);
        Tracker.checkPermission("addTrackerListener");
        listenerList.add(TrackerListener.class, trackerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsFileType(String string) {
        Queue<TrackerItem> queue = Tracker.queue;
        synchronized (queue) {
            for (TrackerItem trackerItem : Tracker.queue) {
                if (!string.equals(trackerItem.extension)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaInfo getByID(String string) {
        Map<String, MetaInfo> map = metaInfoMap;
        synchronized (map) {
            return metaInfoMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, MetaInfo> getIDMap() {
        Map<String, MetaInfo> map = metaInfoMap;
        synchronized (map) {
            return Collections.unmodifiableMap(metaInfoMap);
        }
    }

    public static void notifyTaskChange(MetaInfo metaInfo, TaskTable taskTable, TableModelEvent tableModelEvent) {
        TrackerEvent.ID iD = Tracker.toTrackerEventID(tableModelEvent);
        if (iD != null) {
            if (iD == TrackerEvent.ID.TODO_CHANGED || iD == TrackerEvent.ID.TODO_REMOVED) {
                MArrayList<Task> mArrayList = new MArrayList<Task>((Collection<Task>)taskTable.getTaskList());
                Tracker.add(metaInfo, iD, mArrayList);
            } else {
                Tracker.add(metaInfo, iD, Tracker.createTaskList(taskTable, tableModelEvent));
            }
        }
    }

    public static void removeTrackerListener(TrackerListener trackerListener) {
        log.debugFormat("Remove Listener: %s (#%d)", trackerListener.getClass(), listenerList.getListenerCount() - 1);
        listenerList.remove(TrackerListener.class, trackerListener);
    }

    public static synchronized void startScheduler() {
        if (schedulerTimer != null) {
            log.error("Scheduler already running");
            return;
        }
        schedulerTimer = new MTimer(MTimer.Format.SECONDS, 2){

            @Override
            protected boolean onTimeout() {
                Tracker.doSchedule(10);
                return true;
            }
        };
        schedulerTimer.start();
    }

    private Tracker() {
    }

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(string));
        }
    }

    private static TaskList createTaskList(TaskTable taskTable, TableModelEvent tableModelEvent) {
        TaskList taskList = new TaskList();
        TaskModel taskModel = (TaskModel)taskTable.getModel();
        for (int i = tableModelEvent.getFirstRow(); i <= tableModelEvent.getLastRow(); ++i) {
            taskList.add(taskModel.getRowAt(i));
        }
        return taskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSchedule(int n) {
        int n2;
        Queue<TrackerItem> queue = Tracker.queue;
        synchronized (queue) {
            n2 = Tracker.queue.size();
        }
        if (n2 == 0) {
            return;
        }
        for (int i = 0; n == -1 || i < n; ++i) {
            TrackerItem trackerItem;
            Object object = Tracker.queue;
            synchronized (object) {
                trackerItem = Tracker.queue.poll();
            }
            if (trackerItem == null) break;
            object = trackerItem.createEvent();
            if (((TrackerEvent)object).getID() == TrackerEvent.ID.ITEM_OPEN) {
                Tree.getInstance().open(trackerItem.getMetaInfo());
                continue;
            }
            Tracker.fireItemChanged((TrackerEvent)object);
        }
    }

    private static void fireItemChanged(TrackerEvent trackerEvent) {
        TrackerListener[] trackerListenerArray = (TrackerListener[])listenerList.getListeners(TrackerListener.class);
        for (int i = trackerListenerArray.length - 1; i >= 0; --i) {
            trackerListenerArray[i].itemChanged(trackerEvent);
        }
    }

    private static TrackerEvent.ID toTrackerEventID(TableModelEvent tableModelEvent) {
        switch (tableModelEvent.getType()) {
            case -1: {
                return TrackerEvent.ID.TODO_REMOVED;
            }
            case 1: {
                return TrackerEvent.ID.TODO_ADDED;
            }
            case 0: {
                return TrackerEvent.ID.TODO_CHANGED;
            }
        }
        return null;
    }

    static {
        queue = new PriorityQueue<TrackerItem>(256, new Comparator<TrackerItem>(){

            @Override
            public int compare(TrackerItem trackerItem, TrackerItem trackerItem2) {
                int n = TK.compare(trackerItem.priority, trackerItem2.priority);
                if (n == 0) {
                    n = TK.compare(trackerItem.number, trackerItem2.number);
                }
                return n;
            }
        });
    }

    public static final class Permission
    extends BasicPermission {
        private Permission(String string) {
            super(string);
        }
    }
}

