/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree.version;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.FS;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MList;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.UI;
import org.makagiga.commons.preview.DefaultPreview;
import org.makagiga.commons.preview.Preview;
import org.makagiga.commons.preview.PreviewPanel;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorCrypto;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tree.version.VersionControl;
import org.makagiga.tree.version.VersionException;
import org.makagiga.tree.version.VersionInfo;

public final class VersionPanel
extends MPanel {
    private final ActionGroup actionGroup;
    private final EditorCrypto.InfoLabel infoLabel;
    private final MCheckBox versionEnabled;
    private final MetaInfo metaInfo;
    private final MList<VersionInfo> versionList;

    public VersionPanel(final MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
        this.actionGroup = new ActionGroup();
        this.actionGroup.add("new", new MAction(MActionInfo.NEW){

            @Override
            public void onAction() {
                VersionPanel.this.newVersion();
            }
        });
        this.actionGroup.add("revert", new MAction(MActionInfo.REVERT){

            @Override
            public void onAction() {
                VersionPanel.this.revertVersion();
            }
        });
        this.actionGroup.addSeparator();
        this.actionGroup.add("delete", new MAction(MActionInfo.DELETE_NO_KEY_STROKE){

            @Override
            public void onAction() {
                VersionPanel.this.deleteVersion();
            }
        });
        MToolBar mToolBar = this.actionGroup.createToolBar();
        mToolBar.setOpaque(false);
        mToolBar.addSeparator();
        this.versionEnabled = new MCheckBox(UI._("Backup on save")){

            @Override
            protected void onClick() {
                VersionControl.setEnabled(metaInfo, this.isSelected());
                VersionPanel.this.updateComponents();
            }
        };
        this.versionEnabled.setOpaque(false);
        this.versionEnabled.setSelected(VersionControl.isEnabled(metaInfo));
        mToolBar.add(this.versionEnabled);
        mToolBar.readConfig("version");
        this.addNorth(mToolBar);
        this.versionList = new MList<VersionInfo>(){

            @Override
            protected void onAction() {
                if (this.getActionType() == MList.ActionType.ITEM_POPUP_MENU) {
                    VersionPanel.this.actionGroup.createMenu().showPopup(this.getActionEvent());
                }
            }

            @Override
            protected void onSelect() {
                VersionPanel.this.updateComponents();
            }
        };
        this.versionList.setCellRenderer(VersionInfo.createListCellRenderer());
        this.versionList.setText(UI._("No Items"));
        this.addCenter(MPanel.createVLabelPanel(this.versionList, UI._("Versions:")));
        this.infoLabel = new EditorCrypto.InfoLabel();
        this.addSouth(this.infoLabel);
        this.updateList();
    }

    public void updateComponents() {
        this.infoLabel.update(this.metaInfo);
        boolean bl = (Boolean)Vars.versionEnabled.get() != false && this.metaInfo.canModify();
        boolean bl2 = bl && VersionControl.isEnabled(this.metaInfo);
        int[] nArray = this.versionList.getSelectedIndices();
        this.actionGroup.setEnabled("delete", bl2 && nArray.length > 0);
        this.actionGroup.setEnabled("new", bl2);
        this.actionGroup.setEnabled("revert", bl2 && nArray.length == 1);
        this.versionEnabled.setEnabled(bl);
        this.versionList.setEnabled(bl2);
    }

    private void deleteVersion() {
        List<VersionInfo> list = this.versionList.getSelectedItems();
        if (!MMessage.simpleConfirm(this.getWindowAncestor(), MActionInfo.DELETE, list.toArray())) {
            return;
        }
        for (VersionInfo versionInfo : list) {
            try {
                VersionControl.delete(versionInfo, true);
                this.versionList.removeItem(versionInfo);
            }
            catch (VersionException versionException) {
                MMessage.error(null, versionException);
                break;
            }
        }
    }

    private void newVersion() {
        String string = MMessage.input(null, null, UI._("Name:"), UI._("New Version"), "ui/newfile", "versionname");
        if (string != null) {
            this.newVersion(string);
        }
    }

    private void newVersion(String string) {
        try {
            Tabs tabs = Tabs.getInstance();
            int n = tabs.findEditor(this.metaInfo);
            if (n != -1) {
                tabs.saveEditor((Editor)tabs.getTabAt(n), 1);
            }
            VersionInfo versionInfo = VersionControl.create(this.metaInfo, string);
            this.versionList.addItem(versionInfo);
            this.versionList.setSelectedItem(versionInfo, true);
        }
        catch (VersionException versionException) {
            MMessage.error(null, versionException);
        }
    }

    private boolean preview(VersionInfo versionInfo) {
        MDialog mDialog = new MDialog(null, UI._("Revert: {0}", versionInfo.toString()), "ui/revert");
        mDialog.changeButton((AbstractButton)mDialog.getOKButton(), MActionInfo.REVERT);
        String string = versionInfo.getPath();
        string = FS.getBaseName(string);
        string = FS.getBaseName(string);
        Preview preview = DefaultPreview.getInstance().getPreview(FS.getExtension(string));
        if (preview == null) {
            return true;
        }
        PreviewPanel previewPanel = new PreviewPanel(preview, 400);
        previewPanel.update(new File(versionInfo.getPath()));
        mDialog.addCenter(previewPanel);
        mDialog.pack();
        boolean bl = mDialog.exec(previewPanel);
        previewPanel.cancel(true);
        return bl;
    }

    private void revertVersion() {
        try {
            VersionInfo versionInfo = this.versionList.getSelectedItem();
            if (!this.preview(versionInfo)) {
                return;
            }
            this.newVersion(UI._("Autosave"));
            Tabs tabs = Tabs.getInstance();
            int n = tabs.findEditor(this.metaInfo);
            if (n != -1) {
                tabs.closeEditorAt(n, 3);
            }
            VersionControl.revert(this.metaInfo, versionInfo);
            tabs.openEditor(this.metaInfo);
            this.updateList();
        }
        catch (VersionException versionException) {
            MMessage.error(null, versionException);
        }
    }

    private void updateList() {
        this.versionList.clear();
        try {
            this.versionList.addAllItems((Collection<VersionInfo>)VersionControl.getAllVersions(this.metaInfo));
        }
        catch (VersionException versionException) {
            MMessage.error(null, versionException);
        }
        this.updateComponents();
    }
}

